/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.core;

import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import java.util.concurrent.atomic.AtomicBoolean;

class CrashlyticsUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final CrashListener crashListener;
    private final SettingsDataProvider settingsDataProvider;
    private final Thread.UncaughtExceptionHandler defaultHandler;
    private final AtomicBoolean isHandlingException;

    public CrashlyticsUncaughtExceptionHandler(CrashListener crashListener, SettingsDataProvider settingsProvider, Thread.UncaughtExceptionHandler defaultHandler) {
        this.crashListener = crashListener;
        this.settingsDataProvider = settingsProvider;
        this.defaultHandler = defaultHandler;
        this.isHandlingException = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        this.isHandlingException.set(true);
        try {
            this.crashListener.onUncaughtException(this.settingsDataProvider, thread, ex);
        }
        catch (Exception e) {
            Logger.getLogger().e("FirebaseCrashlytics", "An error occurred in the uncaught exception handler", e);
        }
        finally {
            Logger.getLogger().d("FirebaseCrashlytics", "Crashlytics completed exception processing. Invoking default exception handler.");
            this.defaultHandler.uncaughtException(thread, ex);
            this.isHandlingException.set(false);
        }
    }

    boolean isHandlingException() {
        return this.isHandlingException.get();
    }

    static interface CrashListener {
        public void onUncaughtException(SettingsDataProvider var1, Thread var2, Throwable var3);
    }
}

