/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.send;

import android.content.Context;
import androidx.annotation.NonNull;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.Transport;
import com.google.android.datatransport.cct.CCTDestination;
import com.google.android.datatransport.runtime.Destination;
import com.google.android.datatransport.runtime.TransportRuntime;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender$$Lambda$1;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender$$Lambda$2;
import java.nio.charset.Charset;

public class DataTransportCrashlyticsReportSender {
    private static final CrashlyticsReportJsonTransform TRANSFORM = new CrashlyticsReportJsonTransform();
    private static final String CRASHLYTICS_ENDPOINT = DataTransportCrashlyticsReportSender.mergeStrings("hts/cahyiseot-agolai.o/1frlglgc/aclg", "tp:/rsltcrprsp.ogepscmv/ieo/eaybtho");
    private static final String CRASHLYTICS_API_KEY = DataTransportCrashlyticsReportSender.mergeStrings("AzSBpY4F0rHiHFdinTvM", "IayrSTFL9eJ69YeSUO2");
    private static final String CRASHLYTICS_TRANSPORT_NAME = "FIREBASE_CRASHLYTICS_REPORT";
    private final Transport<CrashlyticsReport> transport;

    public static DataTransportCrashlyticsReportSender create(Context context) {
        TransportRuntime.initialize((Context)context);
        Transport transport = TransportRuntime.getInstance().newFactory((Destination)new CCTDestination(CRASHLYTICS_ENDPOINT, CRASHLYTICS_API_KEY)).getTransport(CRASHLYTICS_TRANSPORT_NAME, CrashlyticsReport.class, Encoding.of((String)"json"), DataTransportCrashlyticsReportSender$$Lambda$1.lambdaFactory$());
        return new DataTransportCrashlyticsReportSender((Transport<CrashlyticsReport>)transport);
    }

    DataTransportCrashlyticsReportSender(Transport<CrashlyticsReport> transport) {
        this.transport = transport;
    }

    public Task<CrashlyticsReport> sendReport(@NonNull CrashlyticsReport report) {
        TaskCompletionSource tcs = new TaskCompletionSource();
        this.transport.schedule(Event.ofUrgent((Object)report), DataTransportCrashlyticsReportSender$$Lambda$2.lambdaFactory$(tcs, report));
        return tcs.getTask();
    }

    private static String mergeStrings(String part1, String part2) {
        int sizeDiff = part1.length() - part2.length();
        if (sizeDiff < 0 || sizeDiff > 1) {
            throw new IllegalArgumentException("Invalid input received");
        }
        StringBuilder url = new StringBuilder(part1.length() + part2.length());
        for (int i = 0; i < part1.length(); ++i) {
            url.append(part1.charAt(i));
            if (part2.length() <= i) continue;
            url.append(part2.charAt(i));
        }
        return url.toString();
    }

    static /* synthetic */ void lambda$sendReport$1(TaskCompletionSource tcs, CrashlyticsReport report, Exception error) {
        if (error != null) {
            tcs.trySetException(error);
            return;
        }
        tcs.trySetResult((Object)report);
    }

    static /* synthetic */ byte[] lambda$create$0(CrashlyticsReport r) {
        return TRANSFORM.reportToJson(r).getBytes(Charset.forName("UTF-8"));
    }
}

