/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.Utils;

public class DataCollectionArbiter {
    private static final String FIREBASE_CRASHLYTICS_COLLECTION_ENABLED = "firebase_crashlytics_collection_enabled";
    private Object taskLock = new Object();
    TaskCompletionSource<Void> dataCollectionEnabledTask = new TaskCompletionSource();
    boolean taskResolved = false;
    private final SharedPreferences sharedPreferences;
    private volatile boolean crashlyticsDataCollectionExplicitlySet;
    private volatile boolean crashlyticsDataCollectionEnabled;
    private final FirebaseApp firebaseApp;
    private TaskCompletionSource<Void> dataCollectionExplicitlyApproved = new TaskCompletionSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollectionArbiter(FirebaseApp app) {
        this.firebaseApp = app;
        Context applicationContext = app.getApplicationContext();
        if (applicationContext == null) {
            throw new RuntimeException("null context");
        }
        this.sharedPreferences = CommonUtils.getSharedPrefs(applicationContext);
        boolean enabled = true;
        boolean explicitlySet = false;
        if (this.sharedPreferences.contains(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) {
            enabled = this.sharedPreferences.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, true);
            explicitlySet = true;
        } else {
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = applicationContext.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED)) {
                    enabled = applicationInfo.metaData.getBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED);
                    explicitlySet = true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.getLogger().d("Unable to get PackageManager. Falling through", e);
            }
        }
        this.crashlyticsDataCollectionEnabled = enabled;
        this.crashlyticsDataCollectionExplicitlySet = explicitlySet;
        Object object = this.taskLock;
        synchronized (object) {
            if (this.isAutomaticDataCollectionEnabled()) {
                this.dataCollectionEnabledTask.trySetResult(null);
                this.taskResolved = true;
            }
        }
    }

    public boolean isAutomaticDataCollectionEnabled() {
        if (this.crashlyticsDataCollectionExplicitlySet) {
            return this.crashlyticsDataCollectionEnabled;
        }
        return this.firebaseApp.isDataCollectionDefaultEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> waitForAutomaticDataCollectionEnabled() {
        Object object = this.taskLock;
        synchronized (object) {
            return this.dataCollectionEnabledTask.getTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CommitPrefEdits", "ApplySharedPref"})
    public void setCrashlyticsDataCollectionEnabled(boolean enabled) {
        this.crashlyticsDataCollectionEnabled = enabled;
        this.crashlyticsDataCollectionExplicitlySet = true;
        this.sharedPreferences.edit().putBoolean(FIREBASE_CRASHLYTICS_COLLECTION_ENABLED, enabled).commit();
        Object object = this.taskLock;
        synchronized (object) {
            if (enabled) {
                if (!this.taskResolved) {
                    this.dataCollectionEnabledTask.trySetResult(null);
                    this.taskResolved = true;
                }
            } else if (this.taskResolved) {
                this.dataCollectionEnabledTask = new TaskCompletionSource();
                this.taskResolved = false;
            }
        }
    }

    public Task<Void> waitForDataCollectionPermission() {
        return Utils.race(this.dataCollectionExplicitlyApproved.getTask(), this.waitForAutomaticDataCollectionEnabled());
    }

    public void grantDataCollectionPermission(boolean dataCollectionToken) {
        if (!dataCollectionToken) {
            throw new IllegalStateException("An invalid data collection token was used.");
        }
        this.dataCollectionExplicitlyApproved.trySetResult(null);
    }
}

