/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.DeliveryMechanism;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.settings.SettingsCacheBehavior;
import com.google.firebase.crashlytics.internal.settings.SettingsController;
import com.google.firebase.crashlytics.internal.settings.model.AppRequestData;
import com.google.firebase.crashlytics.internal.settings.model.AppSettingsData;
import com.google.firebase.crashlytics.internal.settings.network.CreateAppSpiCall;
import com.google.firebase.crashlytics.internal.settings.network.UpdateAppSpiCall;
import java.util.concurrent.Executor;

public class Onboarding {
    static final String CRASHLYTICS_API_ENDPOINT = "com.crashlytics.ApiEndpoint";
    private final HttpRequestFactory requestFactory = new HttpRequestFactory();
    private final FirebaseApp app;
    private final Context context;
    private PackageManager packageManager;
    private String packageName;
    private PackageInfo packageInfo;
    private String versionCode;
    private String versionName;
    private String installerPackageName;
    private String applicationLabel;
    private String targetAndroidSdkVersion;
    private IdManager idManager;
    private DataCollectionArbiter dataCollectionArbiter;

    public Onboarding(FirebaseApp app, Context context, IdManager idManager, DataCollectionArbiter dataCollectionArbiter) {
        this.app = app;
        this.context = context;
        this.idManager = idManager;
        this.dataCollectionArbiter = dataCollectionArbiter;
    }

    public Context getContext() {
        return this.context;
    }

    private static String getVersion() {
        return CrashlyticsCore.getVersion();
    }

    public boolean onPreExecute() {
        try {
            this.installerPackageName = this.idManager.getInstallerPackageName();
            this.packageManager = this.context.getPackageManager();
            this.packageName = this.context.getPackageName();
            this.packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
            this.versionCode = Integer.toString(this.packageInfo.versionCode);
            this.versionName = this.packageInfo.versionName == null ? "0.0" : this.packageInfo.versionName;
            this.applicationLabel = this.packageManager.getApplicationLabel(this.context.getApplicationInfo()).toString();
            this.targetAndroidSdkVersion = Integer.toString(this.context.getApplicationInfo().targetSdkVersion);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.getLogger().e("Failed init", e);
            return false;
        }
    }

    public void doOnboarding(final Executor backgroundExecutor, final SettingsController settingsDataController) {
        final String googleAppId = this.app.getOptions().getApplicationId();
        this.dataCollectionArbiter.waitForDataCollectionPermission().onSuccessTask(backgroundExecutor, (SuccessContinuation)new SuccessContinuation<Void, AppSettingsData>(){

            @NonNull
            public Task<AppSettingsData> then(@Nullable Void ignored) throws Exception {
                return settingsDataController.getAppSettings();
            }
        }).onSuccessTask(backgroundExecutor, (SuccessContinuation)new SuccessContinuation<AppSettingsData, Void>(){

            @NonNull
            public Task<Void> then(@Nullable AppSettingsData appSettingsData) throws Exception {
                try {
                    boolean dataCollectionToken = true;
                    Onboarding.this.performAutoConfigure(appSettingsData, googleAppId, settingsDataController, backgroundExecutor, true);
                }
                catch (Exception e) {
                    Logger.getLogger().e("Error performing auto configuration.", e);
                    throw e;
                }
                return null;
            }
        });
    }

    public SettingsController retrieveSettingsData(Context context, FirebaseApp app, Executor backgroundExecutor) {
        String googleAppId = app.getOptions().getApplicationId();
        SettingsController controller = SettingsController.create(context, googleAppId, this.idManager, this.requestFactory, this.versionCode, this.versionName, this.getOverridenSpiEndpoint(), this.dataCollectionArbiter);
        controller.loadSettingsData(backgroundExecutor).continueWith(backgroundExecutor, (Continuation)new Continuation<Void, Object>(){

            public Object then(@NonNull Task<Void> task) throws Exception {
                if (!task.isSuccessful()) {
                    Logger.getLogger().e("Error fetching settings.", task.getException());
                }
                return null;
            }
        });
        return controller;
    }

    private void performAutoConfigure(AppSettingsData appSettings, String googleAppId, SettingsController settingsController, Executor backgroundExecutor, boolean dataCollectionToken) {
        if ("new".equals(appSettings.status)) {
            if (this.performCreateApp(appSettings, googleAppId, dataCollectionToken)) {
                settingsController.loadSettingsData(SettingsCacheBehavior.SKIP_CACHE_LOOKUP, backgroundExecutor);
            } else {
                Logger.getLogger().e("Failed to create app with Crashlytics service.", null);
            }
        } else if ("configured".equals(appSettings.status)) {
            settingsController.loadSettingsData(SettingsCacheBehavior.SKIP_CACHE_LOOKUP, backgroundExecutor);
        } else if (appSettings.updateRequired) {
            Logger.getLogger().d("Server says an update is required - forcing a full App update.");
            this.performUpdateApp(appSettings, googleAppId, dataCollectionToken);
        }
    }

    private boolean performCreateApp(AppSettingsData appSettings, String googleAppId, boolean dataCollectionToken) {
        AppRequestData requestData = this.buildAppRequest(appSettings.organizationId, googleAppId);
        return new CreateAppSpiCall(this.getOverridenSpiEndpoint(), appSettings.url, this.requestFactory, Onboarding.getVersion()).invoke(requestData, dataCollectionToken);
    }

    private boolean performUpdateApp(AppSettingsData appSettings, String googleAppId, boolean dataCollectionToken) {
        AppRequestData requestData = this.buildAppRequest(appSettings.organizationId, googleAppId);
        return new UpdateAppSpiCall(this.getOverridenSpiEndpoint(), appSettings.url, this.requestFactory, Onboarding.getVersion()).invoke(requestData, dataCollectionToken);
    }

    private AppRequestData buildAppRequest(String organizationId, String googleAppId) {
        Context context = this.getContext();
        String mappingFileId = CommonUtils.getMappingFileId(context);
        String instanceId = CommonUtils.createInstanceIdFrom(mappingFileId, googleAppId, this.versionName, this.versionCode);
        int source = DeliveryMechanism.determineFrom(this.installerPackageName).getId();
        String appIdentifier = this.getIdManager().getAppIdentifier();
        return new AppRequestData(organizationId, googleAppId, appIdentifier, this.versionName, this.versionCode, instanceId, this.applicationLabel, source, this.targetAndroidSdkVersion, "0");
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue(this.context, CRASHLYTICS_API_ENDPOINT);
    }

    private IdManager getIdManager() {
        return this.idManager;
    }
}

