/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.ndk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.ndk.ProcMapEntry;
import com.google.firebase.crashlytics.internal.ndk.ProcMapEntryParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BinaryImagesConverter {
    private static final String DATA_DIR = "/data";
    private final Context context;
    private final FileIdStrategy fileIdStrategy;

    BinaryImagesConverter(Context context, FileIdStrategy fileIdStrategy) {
        this.context = context;
        this.fileIdStrategy = fileIdStrategy;
    }

    @NonNull
    byte[] convert(String raw) throws IOException {
        JSONArray binaryImagesJson = this.parseProcMapsJsonFromString(raw);
        return BinaryImagesConverter.generateBinaryImagesJsonString(binaryImagesJson);
    }

    @NonNull
    byte[] convert(BufferedReader reader) throws IOException {
        JSONArray binaryImagesJson = this.parseProcMapsJsonFromStream(reader);
        return BinaryImagesConverter.generateBinaryImagesJsonString(binaryImagesJson);
    }

    @NonNull
    private JSONArray parseProcMapsJsonFromStream(BufferedReader reader) throws IOException {
        String mapEntryString;
        JSONArray binaryImagesJson = new JSONArray();
        while ((mapEntryString = reader.readLine()) != null) {
            JSONObject mapJson = this.jsonFromMapEntryString(mapEntryString);
            if (mapJson == null) continue;
            binaryImagesJson.put((Object)mapJson);
        }
        return binaryImagesJson;
    }

    @NonNull
    private JSONArray parseProcMapsJsonFromString(String rawProcMapsString) {
        String mapsString;
        JSONArray binaryImagesJson = new JSONArray();
        try {
            JSONObject rawObj = new JSONObject(rawProcMapsString);
            JSONArray maps = rawObj.getJSONArray("maps");
            mapsString = BinaryImagesConverter.joinMapsEntries(maps);
        }
        catch (JSONException e) {
            Logger.getLogger().w("Unable to parse proc maps string", e);
            return binaryImagesJson;
        }
        String[] mapsEntries = mapsString.split("\\|");
        for (int i = 0; i < mapsEntries.length; ++i) {
            String mapEntryString = mapsEntries[i];
            JSONObject mapJson = this.jsonFromMapEntryString(mapEntryString);
            if (mapJson == null) continue;
            binaryImagesJson.put((Object)mapJson);
        }
        return binaryImagesJson;
    }

    @Nullable
    private JSONObject jsonFromMapEntryString(String mapEntryString) {
        String uuid;
        ProcMapEntry mapInfo = ProcMapEntryParser.parse(mapEntryString);
        if (mapInfo == null || !BinaryImagesConverter.isRelevant(mapInfo)) {
            return null;
        }
        String path = mapInfo.path;
        File binFile = this.getLibraryFile(path);
        try {
            uuid = this.fileIdStrategy.createId(binFile);
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not generate ID for file " + mapInfo.path, e);
            return null;
        }
        try {
            return BinaryImagesConverter.createBinaryImageJson(uuid, mapInfo);
        }
        catch (JSONException e) {
            Logger.getLogger().d("Could not create a binary image json string", e);
            return null;
        }
    }

    @NonNull
    private File getLibraryFile(String path) {
        File libFile = new File(path);
        if (!libFile.exists()) {
            libFile = this.correctDataPath(libFile);
        }
        return libFile;
    }

    @NonNull
    private File correctDataPath(File missingFile) {
        if (Build.VERSION.SDK_INT < 9) {
            return missingFile;
        }
        if (missingFile.getAbsolutePath().startsWith(DATA_DIR)) {
            try {
                ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 0);
                missingFile = new File(ai.nativeLibraryDir, missingFile.getName());
            }
            catch (PackageManager.NameNotFoundException e) {
                Logger.getLogger().e("Error getting ApplicationInfo", e);
            }
        }
        return missingFile;
    }

    @NonNull
    private static byte[] generateBinaryImagesJsonString(JSONArray binaryImages) {
        JSONObject binaryImagesObject = new JSONObject();
        try {
            binaryImagesObject.put("binary_images", (Object)binaryImages);
        }
        catch (JSONException e) {
            Logger.getLogger().w("Binary images string is null", e);
            return new byte[0];
        }
        return binaryImagesObject.toString().getBytes(Charset.forName("UTF-8"));
    }

    @NonNull
    private static JSONObject createBinaryImageJson(String uuid, ProcMapEntry mapEntry) throws JSONException {
        JSONObject binaryImage = new JSONObject();
        binaryImage.put("base_address", mapEntry.address);
        binaryImage.put("size", mapEntry.size);
        binaryImage.put("name", (Object)mapEntry.path);
        binaryImage.put("uuid", (Object)uuid);
        return binaryImage;
    }

    @NonNull
    private static String joinMapsEntries(JSONArray array) throws JSONException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length(); ++i) {
            sb.append(array.getString(i));
        }
        return sb.toString();
    }

    private static boolean isRelevant(ProcMapEntry mapEntry) {
        return mapEntry.perms.indexOf(120) != -1 && mapEntry.path.indexOf(47) != -1;
    }

    static interface FileIdStrategy {
        public String createId(File var1) throws IOException;
    }
}

