/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.app.ApplicationExitInfo;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CrashlyticsLifecycleEvents;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportDataCapture;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.common.UserMetadata;
import com.google.firebase.crashlytics.internal.log.LogFileManager;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.send.DataTransportCrashlyticsReportSender;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class SessionReportingCoordinator
implements CrashlyticsLifecycleEvents {
    private static final String EVENT_TYPE_CRASH = "crash";
    private static final String EVENT_TYPE_LOGGED = "error";
    private static final int EVENT_THREAD_IMPORTANCE = 4;
    private static final int MAX_CHAINED_EXCEPTION_DEPTH = 8;
    private final CrashlyticsReportDataCapture dataCapture;
    private final CrashlyticsReportPersistence reportPersistence;
    private final DataTransportCrashlyticsReportSender reportsSender;
    private final LogFileManager logFileManager;
    private final UserMetadata reportMetadata;

    public static SessionReportingCoordinator create(Context context, IdManager idManager, FileStore fileStore, AppData appData, LogFileManager logFileManager, UserMetadata userMetadata, StackTraceTrimmingStrategy stackTraceTrimmingStrategy, SettingsDataProvider settingsProvider) {
        File rootFilesDirectory = new File(fileStore.getFilesDirPath());
        CrashlyticsReportDataCapture dataCapture = new CrashlyticsReportDataCapture(context, idManager, appData, stackTraceTrimmingStrategy);
        CrashlyticsReportPersistence reportPersistence = new CrashlyticsReportPersistence(rootFilesDirectory, settingsProvider);
        DataTransportCrashlyticsReportSender reportSender = DataTransportCrashlyticsReportSender.create(context);
        return new SessionReportingCoordinator(dataCapture, reportPersistence, reportSender, logFileManager, userMetadata);
    }

    SessionReportingCoordinator(CrashlyticsReportDataCapture dataCapture, CrashlyticsReportPersistence reportPersistence, DataTransportCrashlyticsReportSender reportsSender, LogFileManager logFileManager, UserMetadata reportMetadata) {
        this.dataCapture = dataCapture;
        this.reportPersistence = reportPersistence;
        this.reportsSender = reportsSender;
        this.logFileManager = logFileManager;
        this.reportMetadata = reportMetadata;
    }

    @Override
    public void onBeginSession(@NonNull String sessionId, long timestampSeconds) {
        CrashlyticsReport capturedReport = this.dataCapture.captureReportData(sessionId, timestampSeconds);
        this.reportPersistence.persistReport(capturedReport);
    }

    @Override
    public void onLog(long timestamp, String log) {
        this.logFileManager.writeToLog(timestamp, log);
    }

    @Override
    public void onCustomKey(String key, String value) {
        this.reportMetadata.setCustomKey(key, value);
    }

    @Override
    public void onUserId(String userId) {
        this.reportMetadata.setUserId(userId);
    }

    public void persistFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().v("Persisting fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_CRASH, timestamp, true);
    }

    public void persistNonFatalEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, long timestamp) {
        Logger.getLogger().v("Persisting non-fatal event for session " + sessionId);
        this.persistEvent(event, thread, sessionId, EVENT_TYPE_LOGGED, timestamp, false);
    }

    @RequiresApi(api=30)
    public void persistAppExitInfoEvent(String sessionId, ApplicationExitInfo applicationExitInfo, LogFileManager logFileManagerForSession, UserMetadata userMetadataForSession) {
        long sessionStartTime = this.reportPersistence.getStartTimestampMillis(sessionId);
        if (applicationExitInfo.getTimestamp() < sessionStartTime) {
            return;
        }
        if (applicationExitInfo.getReason() != 6) {
            return;
        }
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureAnrEventData(SessionReportingCoordinator.convertApplicationExitInfo(applicationExitInfo));
        Logger.getLogger().d("Persisting anr for session " + sessionId);
        this.reportPersistence.persistEvent(this.addLogsAndCustomKeysToEvent(capturedEvent, logFileManagerForSession, userMetadataForSession), sessionId, true);
    }

    public void finalizeSessionWithNativeEvent(@NonNull String sessionId, @NonNull List<NativeSessionFile> nativeSessionFiles) {
        ArrayList<CrashlyticsReport.FilesPayload.File> nativeFiles = new ArrayList<CrashlyticsReport.FilesPayload.File>();
        for (NativeSessionFile nativeSessionFile : nativeSessionFiles) {
            CrashlyticsReport.FilesPayload.File filePayload = nativeSessionFile.asFilePayload();
            if (filePayload == null) continue;
            nativeFiles.add(filePayload);
        }
        this.reportPersistence.finalizeSessionWithNativeEvent(sessionId, CrashlyticsReport.FilesPayload.builder().setFiles(ImmutableList.from(nativeFiles)).build());
    }

    public void persistUserId(@NonNull String sessionId) {
        String userId = this.reportMetadata.getUserId();
        if (userId == null) {
            Logger.getLogger().v("Could not persist user ID; no user ID available");
            return;
        }
        this.reportPersistence.persistUserIdForSession(userId, sessionId);
    }

    public void finalizeSessions(long timestamp, @Nullable String currentSessionId) {
        this.reportPersistence.finalizeReports(currentSessionId, timestamp);
    }

    @NonNull
    public List<String> listSortedOpenSessionIds() {
        return this.reportPersistence.listSortedOpenSessionIds();
    }

    public boolean hasReportsToSend() {
        return this.reportPersistence.hasFinalizedReports();
    }

    public void removeAllReports() {
        this.reportPersistence.deleteAllReports();
    }

    public Task<Void> sendReports(@NonNull Executor reportSendCompleteExecutor) {
        List<CrashlyticsReportWithSessionId> reportsToSend = this.reportPersistence.loadFinalizedReports();
        ArrayList<Task> sendTasks = new ArrayList<Task>();
        for (CrashlyticsReportWithSessionId reportToSend : reportsToSend) {
            sendTasks.add(this.reportsSender.sendReport(reportToSend).continueWith(reportSendCompleteExecutor, this::onReportSendComplete));
        }
        return Tasks.whenAll(sendTasks);
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event capturedEvent) {
        return this.addLogsAndCustomKeysToEvent(capturedEvent, this.logFileManager, this.reportMetadata);
    }

    private CrashlyticsReport.Session.Event addLogsAndCustomKeysToEvent(CrashlyticsReport.Session.Event capturedEvent, LogFileManager logFileManager, UserMetadata reportMetadata) {
        CrashlyticsReport.Session.Event.Builder eventBuilder = capturedEvent.toBuilder();
        String content = logFileManager.getLogString();
        if (content != null) {
            eventBuilder.setLog(CrashlyticsReport.Session.Event.Log.builder().setContent(content).build());
        } else {
            Logger.getLogger().v("No log data to include with this event.");
        }
        List<CrashlyticsReport.CustomAttribute> sortedCustomAttributes = SessionReportingCoordinator.getSortedCustomAttributes(reportMetadata.getCustomKeys());
        List<CrashlyticsReport.CustomAttribute> sortedInternalKeys = SessionReportingCoordinator.getSortedCustomAttributes(reportMetadata.getInternalKeys());
        if (!sortedCustomAttributes.isEmpty()) {
            eventBuilder.setApp(capturedEvent.getApp().toBuilder().setCustomAttributes(ImmutableList.from(sortedCustomAttributes)).setInternalKeys(ImmutableList.from(sortedInternalKeys)).build());
        }
        return eventBuilder.build();
    }

    private void persistEvent(@NonNull Throwable event, @NonNull Thread thread, @NonNull String sessionId, @NonNull String eventType, long timestamp, boolean includeAllThreads) {
        boolean isHighPriority = eventType.equals(EVENT_TYPE_CRASH);
        CrashlyticsReport.Session.Event capturedEvent = this.dataCapture.captureEventData(event, thread, eventType, timestamp, 4, 8, includeAllThreads);
        this.reportPersistence.persistEvent(this.addLogsAndCustomKeysToEvent(capturedEvent), sessionId, isHighPriority);
    }

    private boolean onReportSendComplete(@NonNull Task<CrashlyticsReportWithSessionId> task) {
        if (task.isSuccessful()) {
            CrashlyticsReportWithSessionId report = (CrashlyticsReportWithSessionId)task.getResult();
            Logger.getLogger().d("Crashlytics report successfully enqueued to DataTransport: " + report.getSessionId());
            this.reportPersistence.deleteFinalizedReport(report.getSessionId());
            return true;
        }
        Logger.getLogger().w("Crashlytics report could not be enqueued to DataTransport", task.getException());
        return false;
    }

    @NonNull
    private static List<CrashlyticsReport.CustomAttribute> getSortedCustomAttributes(@NonNull Map<String, String> attributes) {
        ArrayList<CrashlyticsReport.CustomAttribute> attributesList = new ArrayList<CrashlyticsReport.CustomAttribute>();
        attributesList.ensureCapacity(attributes.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributesList.add(CrashlyticsReport.CustomAttribute.builder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        Collections.sort(attributesList, (attr1, attr2) -> attr1.getKey().compareTo(attr2.getKey()));
        return attributesList;
    }

    @RequiresApi(api=30)
    private static CrashlyticsReport.ApplicationExitInfo convertApplicationExitInfo(ApplicationExitInfo applicationExitInfo) {
        String traceFile = null;
        try {
            traceFile = SessionReportingCoordinator.convertInputStreamToString(applicationExitInfo.getTraceInputStream());
        }
        catch (IOException | NullPointerException e) {
            Logger.getLogger().w("Could not get input trace in application exit info: " + applicationExitInfo.toString() + " Error: " + e);
        }
        return CrashlyticsReport.ApplicationExitInfo.builder().setImportance(applicationExitInfo.getImportance()).setProcessName(applicationExitInfo.getProcessName()).setReasonCode(applicationExitInfo.getReason()).setTimestamp(applicationExitInfo.getTimestamp()).setPid(applicationExitInfo.getPid()).setPss(applicationExitInfo.getPss()).setRss(applicationExitInfo.getRss()).setTraceFile(traceFile).build();
    }

    @RequiresApi(api=19)
    @VisibleForTesting
    public static String convertInputStreamToString(@Nullable InputStream inputStream) throws IOException, NullPointerException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                stringBuilder.append((char)c);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }
}

