/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal;

import android.content.Context;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import java.io.IOException;
import java.io.InputStream;

public class DevelopmentPlatformProvider {
    private static final String UNITY_PLATFORM = "Unity";
    private static final String FLUTTER_PLATFORM = "Flutter";
    private static final String UNITY_VERSION_FIELD = "com.google.firebase.crashlytics.unity_version";
    private static final String FLUTTER_ASSET_FILE = "flutter_assets/NOTICES.Z";
    private final Context context;
    @Nullable
    private DevelopmentPlatform developmentPlatform;

    public DevelopmentPlatformProvider(Context context) {
        this.context = context;
        this.developmentPlatform = null;
    }

    @Nullable
    public String getDevelopmentPlatform() {
        return this.initDevelopmentPlatform().developmentPlatform;
    }

    @Nullable
    public String getDevelopmentPlatformVersion() {
        return this.initDevelopmentPlatform().developmentPlatformVersion;
    }

    public static boolean isUnity(Context context) {
        return CommonUtils.getResourcesIdentifier(context, UNITY_VERSION_FIELD, "string") != 0;
    }

    private boolean assetFileExists(String file) {
        boolean bl;
        block9: {
            if (this.context.getAssets() == null) {
                return false;
            }
            InputStream ignored = this.context.getAssets().open(file);
            try {
                bl = true;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    private DevelopmentPlatform initDevelopmentPlatform() {
        if (this.developmentPlatform == null) {
            this.developmentPlatform = new DevelopmentPlatform();
        }
        return this.developmentPlatform;
    }

    private class DevelopmentPlatform {
        @Nullable
        private final String developmentPlatform;
        @Nullable
        private final String developmentPlatformVersion;

        private DevelopmentPlatform() {
            int unityEditorId = CommonUtils.getResourcesIdentifier(DevelopmentPlatformProvider.this.context, DevelopmentPlatformProvider.UNITY_VERSION_FIELD, "string");
            if (unityEditorId != 0) {
                this.developmentPlatform = DevelopmentPlatformProvider.UNITY_PLATFORM;
                this.developmentPlatformVersion = DevelopmentPlatformProvider.this.context.getResources().getString(unityEditorId);
                Logger.getLogger().v("Unity Editor version is: " + this.developmentPlatformVersion);
                return;
            }
            if (DevelopmentPlatformProvider.this.assetFileExists(DevelopmentPlatformProvider.FLUTTER_ASSET_FILE)) {
                this.developmentPlatform = DevelopmentPlatformProvider.FLUTTER_PLATFORM;
                this.developmentPlatformVersion = null;
                Logger.getLogger().v("Development platform is: Flutter");
                return;
            }
            this.developmentPlatform = null;
            this.developmentPlatformVersion = null;
        }
    }
}

