/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;

final class AutoValue_CrashlyticsReport
extends CrashlyticsReport {
    private final String sdkVersion;
    private final String gmpAppId;
    private final int platform;
    private final String installationUuid;
    private final String firebaseInstallationId;
    private final String firebaseAuthenticationToken;
    private final String appQualitySessionId;
    private final String buildVersion;
    private final String displayVersion;
    private final CrashlyticsReport.Session session;
    private final CrashlyticsReport.FilesPayload ndkPayload;
    private final CrashlyticsReport.ApplicationExitInfo appExitInfo;

    private AutoValue_CrashlyticsReport(String sdkVersion, String gmpAppId, int platform, String installationUuid, @Nullable String firebaseInstallationId, @Nullable String firebaseAuthenticationToken, @Nullable String appQualitySessionId, String buildVersion, String displayVersion, @Nullable CrashlyticsReport.Session session, @Nullable CrashlyticsReport.FilesPayload ndkPayload, @Nullable CrashlyticsReport.ApplicationExitInfo appExitInfo) {
        this.sdkVersion = sdkVersion;
        this.gmpAppId = gmpAppId;
        this.platform = platform;
        this.installationUuid = installationUuid;
        this.firebaseInstallationId = firebaseInstallationId;
        this.firebaseAuthenticationToken = firebaseAuthenticationToken;
        this.appQualitySessionId = appQualitySessionId;
        this.buildVersion = buildVersion;
        this.displayVersion = displayVersion;
        this.session = session;
        this.ndkPayload = ndkPayload;
        this.appExitInfo = appExitInfo;
    }

    @Override
    @NonNull
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Override
    @NonNull
    public String getGmpAppId() {
        return this.gmpAppId;
    }

    @Override
    public int getPlatform() {
        return this.platform;
    }

    @Override
    @NonNull
    public String getInstallationUuid() {
        return this.installationUuid;
    }

    @Override
    @Nullable
    public String getFirebaseInstallationId() {
        return this.firebaseInstallationId;
    }

    @Override
    @Nullable
    public String getFirebaseAuthenticationToken() {
        return this.firebaseAuthenticationToken;
    }

    @Override
    @Nullable
    public String getAppQualitySessionId() {
        return this.appQualitySessionId;
    }

    @Override
    @NonNull
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Override
    @NonNull
    public String getDisplayVersion() {
        return this.displayVersion;
    }

    @Override
    @Nullable
    public CrashlyticsReport.Session getSession() {
        return this.session;
    }

    @Override
    @Nullable
    public CrashlyticsReport.FilesPayload getNdkPayload() {
        return this.ndkPayload;
    }

    @Override
    @Nullable
    public CrashlyticsReport.ApplicationExitInfo getAppExitInfo() {
        return this.appExitInfo;
    }

    public String toString() {
        return "CrashlyticsReport{sdkVersion=" + this.sdkVersion + ", gmpAppId=" + this.gmpAppId + ", platform=" + this.platform + ", installationUuid=" + this.installationUuid + ", firebaseInstallationId=" + this.firebaseInstallationId + ", firebaseAuthenticationToken=" + this.firebaseAuthenticationToken + ", appQualitySessionId=" + this.appQualitySessionId + ", buildVersion=" + this.buildVersion + ", displayVersion=" + this.displayVersion + ", session=" + this.session + ", ndkPayload=" + this.ndkPayload + ", appExitInfo=" + this.appExitInfo + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CrashlyticsReport) {
            CrashlyticsReport that = (CrashlyticsReport)o;
            return this.sdkVersion.equals(that.getSdkVersion()) && this.gmpAppId.equals(that.getGmpAppId()) && this.platform == that.getPlatform() && this.installationUuid.equals(that.getInstallationUuid()) && (this.firebaseInstallationId == null ? that.getFirebaseInstallationId() == null : this.firebaseInstallationId.equals(that.getFirebaseInstallationId())) && (this.firebaseAuthenticationToken == null ? that.getFirebaseAuthenticationToken() == null : this.firebaseAuthenticationToken.equals(that.getFirebaseAuthenticationToken())) && (this.appQualitySessionId == null ? that.getAppQualitySessionId() == null : this.appQualitySessionId.equals(that.getAppQualitySessionId())) && this.buildVersion.equals(that.getBuildVersion()) && this.displayVersion.equals(that.getDisplayVersion()) && (this.session == null ? that.getSession() == null : this.session.equals(that.getSession())) && (this.ndkPayload == null ? that.getNdkPayload() == null : this.ndkPayload.equals(that.getNdkPayload())) && (this.appExitInfo == null ? that.getAppExitInfo() == null : this.appExitInfo.equals(that.getAppExitInfo()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sdkVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.gmpAppId.hashCode();
        h$ *= 1000003;
        h$ ^= this.platform;
        h$ *= 1000003;
        h$ ^= this.installationUuid.hashCode();
        h$ *= 1000003;
        h$ ^= this.firebaseInstallationId == null ? 0 : this.firebaseInstallationId.hashCode();
        h$ *= 1000003;
        h$ ^= this.firebaseAuthenticationToken == null ? 0 : this.firebaseAuthenticationToken.hashCode();
        h$ *= 1000003;
        h$ ^= this.appQualitySessionId == null ? 0 : this.appQualitySessionId.hashCode();
        h$ *= 1000003;
        h$ ^= this.buildVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.displayVersion.hashCode();
        h$ *= 1000003;
        h$ ^= this.session == null ? 0 : this.session.hashCode();
        h$ *= 1000003;
        h$ ^= this.ndkPayload == null ? 0 : this.ndkPayload.hashCode();
        h$ *= 1000003;
        return h$ ^= this.appExitInfo == null ? 0 : this.appExitInfo.hashCode();
    }

    @Override
    protected CrashlyticsReport.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CrashlyticsReport.Builder {
        private String sdkVersion;
        private String gmpAppId;
        private Integer platform;
        private String installationUuid;
        private String firebaseInstallationId;
        private String firebaseAuthenticationToken;
        private String appQualitySessionId;
        private String buildVersion;
        private String displayVersion;
        private CrashlyticsReport.Session session;
        private CrashlyticsReport.FilesPayload ndkPayload;
        private CrashlyticsReport.ApplicationExitInfo appExitInfo;

        Builder() {
        }

        private Builder(CrashlyticsReport source) {
            this.sdkVersion = source.getSdkVersion();
            this.gmpAppId = source.getGmpAppId();
            this.platform = source.getPlatform();
            this.installationUuid = source.getInstallationUuid();
            this.firebaseInstallationId = source.getFirebaseInstallationId();
            this.firebaseAuthenticationToken = source.getFirebaseAuthenticationToken();
            this.appQualitySessionId = source.getAppQualitySessionId();
            this.buildVersion = source.getBuildVersion();
            this.displayVersion = source.getDisplayVersion();
            this.session = source.getSession();
            this.ndkPayload = source.getNdkPayload();
            this.appExitInfo = source.getAppExitInfo();
        }

        @Override
        public CrashlyticsReport.Builder setSdkVersion(String sdkVersion) {
            if (sdkVersion == null) {
                throw new NullPointerException("Null sdkVersion");
            }
            this.sdkVersion = sdkVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setGmpAppId(String gmpAppId) {
            if (gmpAppId == null) {
                throw new NullPointerException("Null gmpAppId");
            }
            this.gmpAppId = gmpAppId;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setPlatform(int platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setInstallationUuid(String installationUuid) {
            if (installationUuid == null) {
                throw new NullPointerException("Null installationUuid");
            }
            this.installationUuid = installationUuid;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setFirebaseInstallationId(@Nullable String firebaseInstallationId) {
            this.firebaseInstallationId = firebaseInstallationId;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setFirebaseAuthenticationToken(@Nullable String firebaseAuthenticationToken) {
            this.firebaseAuthenticationToken = firebaseAuthenticationToken;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setAppQualitySessionId(@Nullable String appQualitySessionId) {
            this.appQualitySessionId = appQualitySessionId;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setBuildVersion(String buildVersion) {
            if (buildVersion == null) {
                throw new NullPointerException("Null buildVersion");
            }
            this.buildVersion = buildVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setDisplayVersion(String displayVersion) {
            if (displayVersion == null) {
                throw new NullPointerException("Null displayVersion");
            }
            this.displayVersion = displayVersion;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setSession(CrashlyticsReport.Session session) {
            this.session = session;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setNdkPayload(CrashlyticsReport.FilesPayload ndkPayload) {
            this.ndkPayload = ndkPayload;
            return this;
        }

        @Override
        public CrashlyticsReport.Builder setAppExitInfo(CrashlyticsReport.ApplicationExitInfo appExitInfo) {
            this.appExitInfo = appExitInfo;
            return this;
        }

        @Override
        public CrashlyticsReport build() {
            String missing = "";
            if (this.sdkVersion == null) {
                missing = missing + " sdkVersion";
            }
            if (this.gmpAppId == null) {
                missing = missing + " gmpAppId";
            }
            if (this.platform == null) {
                missing = missing + " platform";
            }
            if (this.installationUuid == null) {
                missing = missing + " installationUuid";
            }
            if (this.buildVersion == null) {
                missing = missing + " buildVersion";
            }
            if (this.displayVersion == null) {
                missing = missing + " displayVersion";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CrashlyticsReport(this.sdkVersion, this.gmpAppId, this.platform, this.installationUuid, this.firebaseInstallationId, this.firebaseAuthenticationToken, this.appQualitySessionId, this.buildVersion, this.displayVersion, this.session, this.ndkPayload, this.appExitInfo);
        }
    }
}

