/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.metadata.FileLogStore;
import com.google.firebase.crashlytics.internal.metadata.QueueFileLogStore;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.File;

public class LogFileManager {
    private static final String LOGFILE_NAME = "userlog";
    private static final NoopLogStore NOOP_LOG_STORE = new NoopLogStore();
    static final int MAX_LOG_SIZE = 65536;
    private final FileStore fileStore;
    private FileLogStore currentLog;

    public LogFileManager(FileStore fileStore) {
        this.fileStore = fileStore;
        this.currentLog = NOOP_LOG_STORE;
    }

    public LogFileManager(FileStore fileStore, String currentSessionId) {
        this(fileStore);
        this.setCurrentSession(currentSessionId);
    }

    public final void setCurrentSession(String sessionId) {
        this.currentLog.closeLogFile();
        this.currentLog = NOOP_LOG_STORE;
        if (sessionId == null) {
            return;
        }
        this.setLogFile(this.getWorkingFileForSession(sessionId), 65536);
    }

    public void writeToLog(long timestamp, String msg) {
        this.currentLog.writeToLog(timestamp, msg);
    }

    public byte[] getBytesForLog() {
        return this.currentLog.getLogAsBytes();
    }

    @Nullable
    public String getLogString() {
        return this.currentLog.getLogAsString();
    }

    public void clearLog() {
        this.currentLog.deleteLogFile();
    }

    void setLogFile(File workingFile, int maxLogSize) {
        this.currentLog = new QueueFileLogStore(workingFile, maxLogSize);
    }

    private File getWorkingFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, LOGFILE_NAME);
    }

    private static final class NoopLogStore
    implements FileLogStore {
        private NoopLogStore() {
        }

        @Override
        public void writeToLog(long timestamp, String msg) {
        }

        @Override
        public byte[] getLogAsBytes() {
            return null;
        }

        @Override
        public String getLogAsString() {
            return null;
        }

        @Override
        public void closeLogFile() {
        }

        @Override
        public void deleteLogFile() {
        }
    }
}

