/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.metadata;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.metadata.RolloutAssignment;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RolloutAssignmentList {
    private final List<RolloutAssignment> rolloutsState = new ArrayList<RolloutAssignment>();
    private final int maxEntries;
    static final String ROLLOUTS_STATE = "rolloutsState";

    public RolloutAssignmentList(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public synchronized List<RolloutAssignment> getRolloutAssignmentList() {
        return Collections.unmodifiableList(new ArrayList<RolloutAssignment>(this.rolloutsState));
    }

    @CanIgnoreReturnValue
    public synchronized boolean updateRolloutAssignmentList(List<RolloutAssignment> newMapList) {
        this.rolloutsState.clear();
        int nOverLimit = 0;
        if (newMapList.size() > this.maxEntries) {
            Logger.getLogger().w("Ignored " + nOverLimit + " entries when adding rollout assignments. Maximum allowable: " + this.maxEntries);
            List<RolloutAssignment> maxAllowedNewMapList = newMapList.subList(0, this.maxEntries);
            return this.rolloutsState.addAll(maxAllowedNewMapList);
        }
        return this.rolloutsState.addAll(newMapList);
    }

    public List<CrashlyticsReport.Session.Event.RolloutAssignment> getReportRolloutsState() {
        List<RolloutAssignment> rolloutAssignments = this.getRolloutAssignmentList();
        ArrayList<CrashlyticsReport.Session.Event.RolloutAssignment> rolloutsState = new ArrayList<CrashlyticsReport.Session.Event.RolloutAssignment>();
        for (int i = 0; i < rolloutAssignments.size(); ++i) {
            rolloutsState.add(rolloutAssignments.get(i).toReportProto());
        }
        return rolloutsState;
    }
}

