/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.google.firebase.crashlytics.internal.ProcessDetailsProvider;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.BatteryState;
import com.google.firebase.crashlytics.internal.common.BuildIdInfo;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.settings.SettingsProvider;
import com.google.firebase.crashlytics.internal.stacktrace.StackTraceTrimmingStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.TrimmedThrowableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CrashlyticsReportDataCapture {
    private static final Map<String, Integer> ARCHITECTURES_BY_NAME = new HashMap<String, Integer>();
    static final String GENERATOR;
    static final int GENERATOR_TYPE = 3;
    static final int REPORT_ANDROID_PLATFORM = 4;
    static final int SESSION_ANDROID_PLATFORM = 3;
    static final String SIGNAL_DEFAULT = "0";
    private final Context context;
    private final IdManager idManager;
    private final AppData appData;
    private final StackTraceTrimmingStrategy stackTraceTrimmingStrategy;
    private final SettingsProvider settingsProvider;
    private final ProcessDetailsProvider processDetailsProvider = ProcessDetailsProvider.INSTANCE;

    public CrashlyticsReportDataCapture(Context context, IdManager idManager, AppData appData, StackTraceTrimmingStrategy stackTraceTrimmingStrategy, SettingsProvider settingsProvider) {
        this.context = context;
        this.idManager = idManager;
        this.appData = appData;
        this.stackTraceTrimmingStrategy = stackTraceTrimmingStrategy;
        this.settingsProvider = settingsProvider;
    }

    public CrashlyticsReport captureReportData(String identifier, long timestampSeconds) {
        return this.buildReportData().setSession(this.populateSessionData(identifier, timestampSeconds)).build();
    }

    public CrashlyticsReport.Session.Event captureEventData(Throwable event, Thread eventThread, String type, long timestamp, int eventThreadImportance, int maxChainedExceptions, boolean includeAllThreads) {
        int orientation = this.context.getResources().getConfiguration().orientation;
        TrimmedThrowableData trimmedEvent = TrimmedThrowableData.makeTrimmedThrowableData(event, this.stackTraceTrimmingStrategy);
        return CrashlyticsReport.Session.Event.builder().setType(type).setTimestamp(timestamp).setApp(this.populateEventApplicationData(orientation, trimmedEvent, eventThread, eventThreadImportance, maxChainedExceptions, includeAllThreads)).setDevice(this.populateEventDeviceData(orientation)).build();
    }

    public CrashlyticsReport.Session.Event captureAnrEventData(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        int orientation = this.context.getResources().getConfiguration().orientation;
        return CrashlyticsReport.Session.Event.builder().setType("anr").setTimestamp(applicationExitInfo.getTimestamp()).setApp(this.populateEventApplicationData(orientation, this.addBuildIdInfo(applicationExitInfo))).setDevice(this.populateEventDeviceData(orientation)).build();
    }

    private CrashlyticsReport.ApplicationExitInfo addBuildIdInfo(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        List<CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch> buildIdMappingForArchImmutableList = null;
        if (this.settingsProvider.getSettingsSync().featureFlagData.collectBuildIds && this.appData.buildIdInfoList.size() > 0) {
            ArrayList<CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch> buildIdMappingForArchList = new ArrayList<CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch>();
            for (BuildIdInfo buildIdInfo : this.appData.buildIdInfoList) {
                buildIdMappingForArchList.add(CrashlyticsReport.ApplicationExitInfo.BuildIdMappingForArch.builder().setLibraryName(buildIdInfo.getLibraryName()).setArch(buildIdInfo.getArch()).setBuildId(buildIdInfo.getBuildId()).build());
            }
            buildIdMappingForArchImmutableList = Collections.unmodifiableList(buildIdMappingForArchList);
        }
        return CrashlyticsReport.ApplicationExitInfo.builder().setImportance(applicationExitInfo.getImportance()).setProcessName(applicationExitInfo.getProcessName()).setReasonCode(applicationExitInfo.getReasonCode()).setTimestamp(applicationExitInfo.getTimestamp()).setPid(applicationExitInfo.getPid()).setPss(applicationExitInfo.getPss()).setRss(applicationExitInfo.getRss()).setTraceFile(applicationExitInfo.getTraceFile()).setBuildIdMappingForArch(buildIdMappingForArchImmutableList).build();
    }

    private CrashlyticsReport.Builder buildReportData() {
        return CrashlyticsReport.builder().setSdkVersion("20.0.3").setGmpAppId(this.appData.googleAppId).setInstallationUuid(this.idManager.getInstallIds().getCrashlyticsInstallId()).setFirebaseInstallationId(this.idManager.getInstallIds().getFirebaseInstallationId()).setFirebaseAuthenticationToken(this.idManager.getInstallIds().getFirebaseAuthenticationToken()).setBuildVersion(this.appData.versionCode).setDisplayVersion(this.appData.versionName).setPlatform(4);
    }

    private CrashlyticsReport.Session populateSessionData(String identifier, long timestampSeconds) {
        return CrashlyticsReport.Session.builder().setStartedAt(timestampSeconds).setIdentifier(identifier).setGenerator(GENERATOR).setApp(this.populateSessionApplicationData()).setOs(this.populateSessionOperatingSystemData()).setDevice(this.populateSessionDeviceData()).setGeneratorType(3).build();
    }

    private CrashlyticsReport.Session.Application populateSessionApplicationData() {
        CrashlyticsReport.Session.Application.Builder builder = CrashlyticsReport.Session.Application.builder().setIdentifier(this.idManager.getAppIdentifier()).setVersion(this.appData.versionCode).setDisplayVersion(this.appData.versionName).setInstallationUuid(this.idManager.getInstallIds().getCrashlyticsInstallId()).setDevelopmentPlatform(this.appData.developmentPlatformProvider.getDevelopmentPlatform()).setDevelopmentPlatformVersion(this.appData.developmentPlatformProvider.getDevelopmentPlatformVersion());
        return builder.build();
    }

    private CrashlyticsReport.Session.OperatingSystem populateSessionOperatingSystemData() {
        return CrashlyticsReport.Session.OperatingSystem.builder().setPlatform(3).setVersion(Build.VERSION.RELEASE).setBuildVersion(Build.VERSION.CODENAME).setJailbroken(CommonUtils.isRooted()).build();
    }

    private CrashlyticsReport.Session.Device populateSessionDeviceData() {
        StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
        int arch = CrashlyticsReportDataCapture.getDeviceArchitecture();
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        long totalRam = CommonUtils.calculateTotalRamInBytes(this.context);
        long diskSpace = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
        boolean isEmulator = CommonUtils.isEmulator();
        int state = CommonUtils.getDeviceState();
        String manufacturer = Build.MANUFACTURER;
        String modelClass = Build.PRODUCT;
        return CrashlyticsReport.Session.Device.builder().setArch(arch).setModel(Build.MODEL).setCores(availableProcessors).setRam(totalRam).setDiskSpace(diskSpace).setSimulator(isEmulator).setState(state).setManufacturer(manufacturer).setModelClass(modelClass).build();
    }

    private CrashlyticsReport.Session.Event.Application populateEventApplicationData(int orientation, TrimmedThrowableData trimmedEvent, Thread eventThread, int eventThreadImportance, int maxChainedExceptions, boolean includeAllThreads) {
        Boolean isBackground = null;
        CrashlyticsReport.Session.Event.Application.ProcessDetails currentProcessDetails = this.processDetailsProvider.getCurrentProcessDetails(this.context);
        if (currentProcessDetails.getImportance() > 0) {
            isBackground = currentProcessDetails.getImportance() != 100;
        }
        return CrashlyticsReport.Session.Event.Application.builder().setBackground(isBackground).setCurrentProcessDetails(currentProcessDetails).setAppProcessDetails(this.processDetailsProvider.getAppProcessDetails(this.context)).setUiOrientation(orientation).setExecution(this.populateExecutionData(trimmedEvent, eventThread, eventThreadImportance, maxChainedExceptions, includeAllThreads)).build();
    }

    private CrashlyticsReport.Session.Event.Application populateEventApplicationData(int orientation, CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        boolean isBackground = applicationExitInfo.getImportance() != 100;
        return CrashlyticsReport.Session.Event.Application.builder().setBackground(isBackground).setCurrentProcessDetails(this.processDetailsFromApplicationExitInfo(applicationExitInfo)).setUiOrientation(orientation).setExecution(this.populateExecutionData(applicationExitInfo)).build();
    }

    private CrashlyticsReport.Session.Event.Device populateEventDeviceData(int orientation) {
        BatteryState battery = BatteryState.get(this.context);
        Float batteryLevel = battery.getBatteryLevel();
        Double batteryLevelDouble = batteryLevel != null ? Double.valueOf(batteryLevel.doubleValue()) : null;
        int batteryVelocity = battery.getBatteryVelocity();
        boolean proximityEnabled = CommonUtils.getProximitySensorEnabled(this.context);
        long usedRamBytes = CrashlyticsReportDataCapture.ensureNonNegative(CommonUtils.calculateTotalRamInBytes(this.context) - CommonUtils.calculateFreeRamInBytes(this.context));
        long diskUsedBytes = CommonUtils.calculateUsedDiskSpaceInBytes(Environment.getDataDirectory().getPath());
        return CrashlyticsReport.Session.Event.Device.builder().setBatteryLevel(batteryLevelDouble).setBatteryVelocity(batteryVelocity).setProximityOn(proximityEnabled).setOrientation(orientation).setRamUsed(usedRamBytes).setDiskUsed(diskUsedBytes).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution populateExecutionData(TrimmedThrowableData trimmedEvent, Thread eventThread, int eventThreadImportance, int maxChainedExceptions, boolean includeAllThreads) {
        return CrashlyticsReport.Session.Event.Application.Execution.builder().setThreads(this.populateThreadsList(trimmedEvent, eventThread, eventThreadImportance, includeAllThreads)).setException(this.populateExceptionData(trimmedEvent, eventThreadImportance, maxChainedExceptions)).setSignal(this.populateSignalData()).setBinaries(this.populateBinaryImagesList()).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution populateExecutionData(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        return CrashlyticsReport.Session.Event.Application.Execution.builder().setAppExitInfo(applicationExitInfo).setSignal(this.populateSignalData()).setBinaries(this.populateBinaryImagesList()).build();
    }

    private List<CrashlyticsReport.Session.Event.Application.Execution.Thread> populateThreadsList(TrimmedThrowableData trimmedEvent, Thread eventThread, int eventThreadImportance, boolean includeAllThreads) {
        ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread> threadsList = new ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread>();
        threadsList.add(this.populateThreadData(eventThread, trimmedEvent.stacktrace, eventThreadImportance));
        if (includeAllThreads) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                Thread thread = entry.getKey();
                if (thread.equals(eventThread)) continue;
                threadsList.add(this.populateThreadData(thread, this.stackTraceTrimmingStrategy.getTrimmedStackTrace(entry.getValue())));
            }
        }
        return Collections.unmodifiableList(threadsList);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread populateThreadData(Thread thread, StackTraceElement[] stacktrace) {
        return this.populateThreadData(thread, stacktrace, 0);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread populateThreadData(Thread thread, StackTraceElement[] stacktrace, int importance) {
        return CrashlyticsReport.Session.Event.Application.Execution.Thread.builder().setName(thread.getName()).setImportance(importance).setFrames(this.populateFramesList(stacktrace, importance)).build();
    }

    private List<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame> populateFramesList(StackTraceElement[] stacktrace, int importance) {
        ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame> framesList = new ArrayList<CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame>();
        for (StackTraceElement element : stacktrace) {
            framesList.add(this.populateFrameData(element, CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.builder().setImportance(importance)));
        }
        return Collections.unmodifiableList(framesList);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Exception populateExceptionData(TrimmedThrowableData trimmedEvent, int eventThreadImportance, int maxChainedExceptions) {
        return this.populateExceptionData(trimmedEvent, eventThreadImportance, maxChainedExceptions, 0);
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Exception populateExceptionData(TrimmedThrowableData trimmedEvent, int eventThreadImportance, int maxChainedExceptions, int chainDepth) {
        String type = trimmedEvent.className;
        String reason = trimmedEvent.localizedMessage;
        StackTraceElement[] stacktrace = trimmedEvent.stacktrace != null ? trimmedEvent.stacktrace : new StackTraceElement[]{};
        TrimmedThrowableData cause = trimmedEvent.cause;
        int overflowCount = 0;
        if (chainDepth >= maxChainedExceptions) {
            TrimmedThrowableData skipped = cause;
            while (skipped != null) {
                skipped = skipped.cause;
                ++overflowCount;
            }
        }
        CrashlyticsReport.Session.Event.Application.Execution.Exception.Builder builder = CrashlyticsReport.Session.Event.Application.Execution.Exception.builder().setType(type).setReason(reason).setFrames(this.populateFramesList(stacktrace, eventThreadImportance)).setOverflowCount(overflowCount);
        if (cause != null && overflowCount == 0) {
            builder.setCausedBy(this.populateExceptionData(cause, eventThreadImportance, maxChainedExceptions, chainDepth + 1));
        }
        return builder.build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame populateFrameData(StackTraceElement element, CrashlyticsReport.Session.Event.Application.Execution.Thread.Frame.Builder frameBuilder) {
        long pc = 0L;
        if (element.isNativeMethod()) {
            pc = Math.max((long)element.getLineNumber(), 0L);
        }
        String symbol = element.getClassName() + "." + element.getMethodName();
        String file = element.getFileName();
        long offset = 0L;
        if (!element.isNativeMethod() && element.getLineNumber() > 0) {
            offset = element.getLineNumber();
        }
        return frameBuilder.setPc(pc).setSymbol(symbol).setFile(file).setOffset(offset).build();
    }

    private List<CrashlyticsReport.Session.Event.Application.Execution.BinaryImage> populateBinaryImagesList() {
        return Collections.singletonList(this.populateBinaryImageData());
    }

    private CrashlyticsReport.Session.Event.Application.Execution.BinaryImage populateBinaryImageData() {
        return CrashlyticsReport.Session.Event.Application.Execution.BinaryImage.builder().setBaseAddress(0L).setSize(0L).setName(this.appData.packageName).setUuid(this.appData.buildId).build();
    }

    private CrashlyticsReport.Session.Event.Application.Execution.Signal populateSignalData() {
        return CrashlyticsReport.Session.Event.Application.Execution.Signal.builder().setName(SIGNAL_DEFAULT).setCode(SIGNAL_DEFAULT).setAddress(0L).build();
    }

    private static int getDeviceArchitecture() {
        String primaryAbi = Build.CPU_ABI;
        if (TextUtils.isEmpty((CharSequence)primaryAbi)) {
            return 7;
        }
        Integer arch = ARCHITECTURES_BY_NAME.get(primaryAbi.toLowerCase(Locale.US));
        if (arch == null) {
            return 7;
        }
        return arch;
    }

    private static long ensureNonNegative(long value) {
        return value > 0L ? value : 0L;
    }

    private CrashlyticsReport.Session.Event.Application.ProcessDetails processDetailsFromApplicationExitInfo(CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
        return this.processDetailsProvider.buildProcessDetails(applicationExitInfo.getProcessName(), applicationExitInfo.getPid(), applicationExitInfo.getImportance());
    }

    static {
        ARCHITECTURES_BY_NAME.put("armeabi", 5);
        ARCHITECTURES_BY_NAME.put("armeabi-v7a", 6);
        ARCHITECTURES_BY_NAME.put("arm64-v8a", 9);
        ARCHITECTURES_BY_NAME.put("x86", 0);
        ARCHITECTURES_BY_NAME.put("x86_64", 1);
        GENERATOR = String.format(Locale.US, "Crashlytics Android SDK/%s", "20.0.3");
    }
}

