/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.database.collection.LLRBBlackValueNode;
import com.google.firebase.database.collection.LLRBEmptyNode;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBRedValueNode;
import java.util.Comparator;

@KeepForSdk
public abstract class LLRBValueNode<K, V>
implements LLRBNode<K, V> {
    private final K zzq;
    private final V value;
    private LLRBNode<K, V> zzr;
    private final LLRBNode<K, V> zzs;

    private static LLRBNode.Color zzb(LLRBNode lLRBNode) {
        if (lLRBNode.isRed()) {
            return LLRBNode.Color.zzo;
        }
        return LLRBNode.Color.zzn;
    }

    LLRBValueNode(K k, V v, LLRBNode<K, V> lLRBNode, LLRBNode<K, V> lLRBNode2) {
        this.zzq = k;
        this.value = v;
        this.zzr = lLRBNode == null ? LLRBEmptyNode.getInstance() : lLRBNode;
        this.zzs = lLRBNode2 == null ? LLRBEmptyNode.getInstance() : lLRBNode2;
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> getLeft() {
        return this.zzr;
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> getRight() {
        return this.zzs;
    }

    @Override
    @KeepForSdk
    public K getKey() {
        return this.zzq;
    }

    @Override
    @KeepForSdk
    public V getValue() {
        return this.value;
    }

    protected abstract LLRBNode.Color zza();

    protected abstract LLRBValueNode<K, V> zza(K var1, V var2, LLRBNode<K, V> var3, LLRBNode<K, V> var4);

    @Override
    @KeepForSdk
    public LLRBValueNode<K, V> copy(K k, V v, LLRBNode.Color color, LLRBNode<K, V> lLRBNode, LLRBNode<K, V> lLRBNode2) {
        LLRBNode<K, V> lLRBNode3;
        K k2 = k == null ? this.zzq : k;
        V v2 = v == null ? this.value : v;
        LLRBNode<K, V> lLRBNode4 = lLRBNode == null ? this.zzr : lLRBNode;
        LLRBNode<K, V> lLRBNode5 = lLRBNode3 = lLRBNode2 == null ? this.zzs : lLRBNode2;
        if (color == LLRBNode.Color.zzn) {
            return new LLRBRedValueNode<K, V>(k2, v2, lLRBNode4, lLRBNode3);
        }
        return new LLRBBlackValueNode<K, V>(k2, v2, lLRBNode4, lLRBNode3);
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> insert(K k, V v, Comparator<K> comparator) {
        LLRBValueNode<Object, Object> lLRBValueNode;
        int n = comparator.compare(k, this.zzq);
        if (n < 0) {
            LLRBNode<K, V> lLRBNode = this.zzr.insert(k, v, comparator);
            lLRBValueNode = this.zza(null, null, lLRBNode, null);
        } else if (n == 0) {
            lLRBValueNode = this.zza(k, v, null, null);
        } else {
            LLRBNode<K, V> lLRBNode = this.zzs.insert(k, v, comparator);
            lLRBValueNode = this.zza(null, null, null, lLRBNode);
        }
        return super.zzd();
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> remove(K k, Comparator<K> comparator) {
        LLRBValueNode<Object, Object> lLRBValueNode = this;
        if (comparator.compare(k, lLRBValueNode.zzq) < 0) {
            if (!(lLRBValueNode.zzr.isEmpty() || lLRBValueNode.zzr.isRed() || ((LLRBValueNode)lLRBValueNode.zzr).zzr.isRed())) {
                lLRBValueNode = super.zzc();
            }
            lLRBValueNode = lLRBValueNode.zza(null, null, lLRBValueNode.zzr.remove(k, comparator), null);
        } else {
            if (lLRBValueNode.zzr.isRed()) {
                lLRBValueNode = lLRBValueNode.zzf();
            }
            if (!(lLRBValueNode.zzs.isEmpty() || lLRBValueNode.zzs.isRed() || ((LLRBValueNode)lLRBValueNode.zzs).zzr.isRed())) {
                LLRBValueNode<Object, Object> lLRBValueNode2 = super.zzg();
                if (lLRBValueNode2.getLeft().getLeft().isRed()) {
                    lLRBValueNode2 = super.zzg();
                }
                lLRBValueNode = lLRBValueNode2;
            }
            if (comparator.compare(k, lLRBValueNode.zzq) == 0) {
                if (lLRBValueNode.zzs.isEmpty()) {
                    return LLRBEmptyNode.getInstance();
                }
                LLRBNode<K, V> lLRBNode = lLRBValueNode.zzs.getMin();
                lLRBValueNode = lLRBValueNode.zza(lLRBNode.getKey(), lLRBNode.getValue(), null, ((LLRBValueNode)lLRBValueNode.zzs).zzb());
            }
            lLRBValueNode = lLRBValueNode.zza(null, null, null, lLRBValueNode.zzs.remove(k, comparator));
        }
        return super.zzd();
    }

    @Override
    @KeepForSdk
    public boolean isEmpty() {
        return false;
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> getMin() {
        if (this.zzr.isEmpty()) {
            return this;
        }
        return this.zzr.getMin();
    }

    @Override
    @KeepForSdk
    public LLRBNode<K, V> getMax() {
        if (this.zzs.isEmpty()) {
            return this;
        }
        return this.zzs.getMax();
    }

    @Override
    @KeepForSdk
    public void inOrderTraversal(LLRBNode.NodeVisitor<K, V> nodeVisitor) {
        this.zzr.inOrderTraversal(nodeVisitor);
        nodeVisitor.visitEntry(this.zzq, this.value);
        this.zzs.inOrderTraversal(nodeVisitor);
    }

    @Override
    @KeepForSdk
    public boolean shortCircuitingInOrderTraversal(LLRBNode.ShortCircuitingNodeVisitor<K, V> shortCircuitingNodeVisitor) {
        if (this.zzr.shortCircuitingInOrderTraversal(shortCircuitingNodeVisitor) && shortCircuitingNodeVisitor.shouldContinue(this.zzq, this.value)) {
            return this.zzs.shortCircuitingInOrderTraversal(shortCircuitingNodeVisitor);
        }
        return false;
    }

    @Override
    @KeepForSdk
    public boolean shortCircuitingReverseOrderTraversal(LLRBNode.ShortCircuitingNodeVisitor<K, V> shortCircuitingNodeVisitor) {
        if (this.zzs.shortCircuitingReverseOrderTraversal(shortCircuitingNodeVisitor) && shortCircuitingNodeVisitor.shouldContinue(this.zzq, this.value)) {
            return this.zzr.shortCircuitingReverseOrderTraversal(shortCircuitingNodeVisitor);
        }
        return false;
    }

    void zza(LLRBNode<K, V> lLRBNode) {
        this.zzr = lLRBNode;
    }

    private final LLRBNode<K, V> zzb() {
        if (this.zzr.isEmpty()) {
            return LLRBEmptyNode.getInstance();
        }
        LLRBValueNode<K, V> lLRBValueNode = this;
        if (!lLRBValueNode.getLeft().isRed() && !lLRBValueNode.getLeft().getLeft().isRed()) {
            lLRBValueNode = lLRBValueNode.zzc();
        }
        return super.zzd();
    }

    private final LLRBValueNode<K, V> zzc() {
        LLRBValueNode<Object, Object> lLRBValueNode = this.zzg();
        if (lLRBValueNode.getRight().getLeft().isRed()) {
            lLRBValueNode = super.zzg();
        }
        return lLRBValueNode;
    }

    private final LLRBValueNode<K, V> zzd() {
        LLRBValueNode<K, V> lLRBValueNode = this;
        if (lLRBValueNode.zzs.isRed() && !lLRBValueNode.zzr.isRed()) {
            lLRBValueNode = lLRBValueNode.zze();
        }
        if (lLRBValueNode.zzr.isRed() && ((LLRBValueNode)lLRBValueNode.zzr).zzr.isRed()) {
            lLRBValueNode = super.zzf();
        }
        if (lLRBValueNode.zzr.isRed() && lLRBValueNode.zzs.isRed()) {
            lLRBValueNode = super.zzg();
        }
        return lLRBValueNode;
    }

    private final LLRBValueNode<K, V> zze() {
        LLRBValueNode lLRBValueNode = (LLRBValueNode)this.copy((Object)null, (Object)null, LLRBNode.Color.zzn, (LLRBNode)null, (LLRBNode)((LLRBValueNode)this.zzs).zzr);
        return (LLRBValueNode)this.zzs.copy(null, null, this.zza(), lLRBValueNode, null);
    }

    private final LLRBValueNode<K, V> zzf() {
        LLRBValueNode lLRBValueNode = (LLRBValueNode)this.copy((Object)null, (Object)null, LLRBNode.Color.zzn, (LLRBNode)((LLRBValueNode)this.zzr).zzs, (LLRBNode)null);
        return (LLRBValueNode)this.zzr.copy(null, null, this.zza(), null, lLRBValueNode);
    }

    private final LLRBValueNode<K, V> zzg() {
        LLRBNode<Object, Object> lLRBNode = this.zzr.copy(null, null, LLRBValueNode.zzb(this.zzr), null, null);
        LLRBNode<Object, Object> lLRBNode2 = this.zzs.copy(null, null, LLRBValueNode.zzb(this.zzs), null, null);
        return (LLRBValueNode)this.copy((Object)null, (Object)null, LLRBValueNode.zzb(this), (LLRBNode)lLRBNode, (LLRBNode)lLRBNode2);
    }
}

