/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.zzb;
import com.google.firebase.database.collection.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zza<K, V>
extends ImmutableSortedMap<K, V> {
    private final K[] zza;
    private final V[] zzb;
    private final Comparator<K> zzc;

    public static <A, B, C> zza<A, C> zza(List<A> list, Map<B, C> map, ImmutableSortedMap.Builder.KeyTranslator<A, B> keyTranslator, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(keyTranslator.translate(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zza<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zza<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return com.google.firebase.database.collection.zza.zza(new ArrayList<K>(map.keySet()), map, ImmutableSortedMap.Builder.identityTranslator(), comparator);
    }

    public zza(Comparator<K> comparator) {
        this.zza = new Object[0];
        this.zzb = new Object[0];
        this.zzc = comparator;
    }

    private zza(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zza = KArray;
        this.zzb = VArray;
        this.zzc = comparator;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzb(k) != -1;
    }

    @Override
    public final V get(K k) {
        int n = this.zzb(k);
        if (n != -1) {
            return this.zzb[n];
        }
        return null;
    }

    @Override
    public final ImmutableSortedMap<K, V> remove(K k) {
        int n = this.zzb(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = com.google.firebase.database.collection.zza.zza(this.zza, n);
        V[] VArray = com.google.firebase.database.collection.zza.zza(this.zzb, n);
        return new zza<K, V>(this.zzc, KArray, VArray);
    }

    @Override
    public final ImmutableSortedMap<K, V> insert(K k, V v) {
        int n = this.zzb(k);
        if (n != -1) {
            if (this.zza[n] == k && this.zzb[n] == v) {
                return this;
            }
            K[] KArray = com.google.firebase.database.collection.zza.zzb(this.zza, n, k);
            V[] VArray = com.google.firebase.database.collection.zza.zzb(this.zzb, n, v);
            return new zza<K, V>(this.zzc, KArray, VArray);
        }
        if (this.zza.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zza.length + 1);
            for (int i = 0; i < this.zza.length; ++i) {
                hashMap.put(this.zza[i], this.zzb[i]);
            }
            hashMap.put(k, v);
            return com.google.firebase.database.collection.zzc.zzb(hashMap, this.zzc);
        }
        int n2 = this.zza(k);
        K[] KArray = com.google.firebase.database.collection.zza.zza(this.zza, n2, k);
        V[] VArray = com.google.firebase.database.collection.zza.zza(this.zzb, n2, v);
        return new zza<K, V>(this.zzc, KArray, VArray);
    }

    @Override
    public final K getMinKey() {
        if (this.zza.length > 0) {
            return this.zza[0];
        }
        return null;
    }

    @Override
    public final K getMaxKey() {
        if (this.zza.length > 0) {
            return this.zza[this.zza.length - 1];
        }
        return null;
    }

    @Override
    public final int size() {
        return this.zza.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.zza.length == 0;
    }

    @Override
    public final void inOrderTraversal(LLRBNode.NodeVisitor<K, V> nodeVisitor) {
        for (int i = 0; i < this.zza.length; ++i) {
            nodeVisitor.visitEntry(this.zza[i], this.zzb[i]);
        }
    }

    private final Iterator<Map.Entry<K, V>> zza(int n, boolean bl) {
        return new zzb(this, n, bl);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.zza(0, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iteratorFrom(K k) {
        int n = this.zza(k);
        return this.zza(n, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> reverseIteratorFrom(K k) {
        int n = this.zza(k);
        if (n < this.zza.length && this.zzc.compare(this.zza[n], k) == 0) {
            return this.zza(n, true);
        }
        return this.zza(n - 1, true);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> reverseIterator() {
        return this.zza(this.zza.length - 1, true);
    }

    @Override
    public final K getPredecessorKey(K k) {
        int n = this.zzb(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        if (n > 0) {
            return this.zza[n - 1];
        }
        return null;
    }

    @Override
    public final K getSuccessorKey(K k) {
        int n = this.zzb(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find successor of nonexistent key");
        }
        if (n < this.zza.length - 1) {
            return this.zza[n + 1];
        }
        return null;
    }

    @Override
    public final int indexOf(K k) {
        return this.zzb(k);
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzc;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private final int zza(K k) {
        int n;
        for (n = 0; n < this.zza.length && this.zzc.compare(this.zza[n], k) < 0; ++n) {
        }
        return n;
    }

    private final int zzb(K k) {
        int n = 0;
        K[] KArray = this.zza;
        int n2 = this.zza.length;
        for (int i = 0; i < n2; ++i) {
            K k2 = KArray[i];
            if (this.zzc.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Object[] zza(zza zza2) {
        return zza2.zza;
    }

    static /* synthetic */ Object[] zzb(zza zza2) {
        return zza2.zzb;
    }
}

