/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbpn;
import com.google.android.gms.internal.zzbpp;
import com.google.android.gms.internal.zzbpq;
import com.google.android.gms.internal.zzbpr;
import com.google.android.gms.internal.zzbpt;
import com.google.android.gms.internal.zzbpu;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzbpo {
    private static final AtomicInteger zzchJ = new AtomicInteger(0);
    private static final Charset zzchK = Charset.forName("UTF-8");
    private volatile zza zzchL = zza.zzchX;
    private volatile Socket zzchM = null;
    private zzbpp zzchN = null;
    private final URI zzchO;
    private final zzbpt zzchP;
    private final zzbpu zzchQ;
    private final zzbpr zzchR;
    private final int zzayy = zzchJ.incrementAndGet();
    private final Thread zzchS = zzbpo.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzbpo.this.zzZM();
        }
    });
    private static ThreadFactory zzchT = Executors.defaultThreadFactory();
    private static zzbpn zzchU = new zzbpn(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return zzchT;
    }

    static zzbpn zzZG() {
        return zzchU;
    }

    public static void zza(ThreadFactory threadFactory, zzbpn zzbpn2) {
        zzchT = threadFactory;
        zzchU = zzbpn2;
    }

    public zzbpo(URI uRI, String string, Map<String, String> map) {
        this.zzchO = uRI;
        this.zzchR = new zzbpr(uRI, string, map);
        this.zzchP = new zzbpt(this);
        this.zzchQ = new zzbpu(this, "TubeSock", this.zzayy);
    }

    public void zza(zzbpp zzbpp2) {
        this.zzchN = zzbpp2;
    }

    zzbpp zzZH() {
        return this.zzchN;
    }

    public synchronized void connect() {
        if (this.zzchL != zza.zzchX) {
            this.zzchN.zza(new zzbpq("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzayy;
        zzbpo.zzZG().zza(this.zzZN(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzchL = zza.zzchY;
        this.zzZN().start();
    }

    public synchronized void zziT(String string) {
        this.zza((byte)1, string.getBytes(zzchK));
    }

    synchronized void zzW(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.zzchL != zza.zzchZ) {
            this.zzchN.zza(new zzbpq("error while sending data: not connected"));
        } else {
            try {
                this.zzchQ.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.zzchN.zza(new zzbpq("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzbpq zzbpq2) {
        this.zzchN.zza(zzbpq2);
        if (this.zzchL == zza.zzchZ) {
            this.close();
        }
        this.zzZJ();
    }

    public synchronized void close() {
        switch (this.zzchL) {
            case zzchX: {
                this.zzchL = zza.zzcib;
                return;
            }
            case zzchY: {
                this.zzZJ();
                return;
            }
            case zzchZ: {
                this.zzZK();
                return;
            }
            case zzcia: {
                return;
            }
            case zzcib: {
                return;
            }
        }
    }

    void zzZI() {
        this.zzZJ();
    }

    private synchronized void zzZJ() {
        if (this.zzchL == zza.zzcib) {
            return;
        }
        this.zzchP.zzZQ();
        this.zzchQ.zzZT();
        if (this.zzchM != null) {
            try {
                this.zzchM.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzchL = zza.zzcib;
        this.zzchN.onClose();
    }

    private void zzZK() {
        try {
            this.zzchL = zza.zzcia;
            this.zzchQ.zzZT();
            this.zzchQ.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.zzchN.zza(new zzbpq("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.zzchO.getScheme();
        String string2 = this.zzchO.getHost();
        int n = this.zzchO.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzbpq(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzchO);
                throw new zzbpq(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzchO);
                    throw new zzbpq(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzbpq(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzchO);
                throw new zzbpq(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzbpq(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzZL() throws InterruptedException {
        if (this.zzchQ.zzZN().getState() != Thread.State.NEW) {
            this.zzchQ.zzZN().join();
        }
        this.zzZN().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzZM() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.zzchM = socket;
                if (this.zzchL == zza.zzcib) {
                    try {
                        this.zzchM.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.zzchM = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzchR.zzZO());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzbpq("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    object2 = new String(byArray, zzchK);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                object2 = new String(byArray, zzchK);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzbpq(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzbpq(string);
            }
            this.zzchR.zzjd((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.zzchR.zzd(hashMap);
            this.zzchQ.zzb(outputStream);
            this.zzchP.zza((DataInputStream)object);
            this.zzchL = zza.zzchZ;
            this.zzchQ.zzZN().start();
            this.zzchN.zzWt();
            this.zzchP.run();
            return;
        }
        catch (zzbpq zzbpq2) {
            this.zzchN.zza(zzbpq2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzchN.zza(new zzbpq(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzZN() {
        return this.zzchS;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzchX = new zza();
        public static final /* enum */ zza zzchY = new zza();
        public static final /* enum */ zza zzchZ = new zza();
        public static final /* enum */ zza zzcia = new zza();
        public static final /* enum */ zza zzcib = new zza();
        private static final /* synthetic */ zza[] zzcic;

        public static zza[] values() {
            return (zza[])zzcic.clone();
        }

        static {
            zzcic = new zza[]{zzchX, zzchY, zzchZ, zzcia, zzcib};
        }
    }
}

