/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbol;
import com.google.android.gms.internal.zzbon;
import com.google.android.gms.internal.zzbov;
import com.google.android.gms.internal.zzbrn;
import com.google.android.gms.internal.zzbsm;
import com.google.android.gms.internal.zzbsn;
import com.google.android.gms.internal.zzbso;
import com.google.android.gms.internal.zzbsq;
import com.google.android.gms.internal.zzbsv;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzbot {
    private static long zzccN = 0L;
    private zzb zzccO;
    private boolean zzccP = false;
    private boolean zzccQ = false;
    private long zzccR = 0L;
    private zzbov zzccS;
    private zza zzccT;
    private ScheduledFuture<?> zzccU;
    private ScheduledFuture<?> zzccV;
    private final zzbol zzccW;
    private final ScheduledExecutorService zzcax;
    private final zzbrn zzcaJ;

    public zzbot(zzbol zzbol2, zzbon zzbon2, String string, zza zza2, String string2) {
        this.zzccW = zzbol2;
        this.zzcax = zzbol2.zzXs();
        this.zzccT = zza2;
        long l = zzccN++;
        this.zzcaJ = new zzbrn(zzbol2.zzXq(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.zzccO = this.zza(zzbon2, string, string2);
    }

    private zzb zza(zzbon zzbon2, String string, String string2) {
        String string3 = string != null ? string : zzbon2.getHost();
        URI uRI = zzbon.zza(string3, zzbon2.isSecure(), zzbon2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.zzccW.zzkn());
        zzbsm zzbsm2 = new zzbsm(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzbsm2);
        return zzc2;
    }

    public void open() {
        this.zzccO.connect();
        this.zzccV = this.zzcax.schedule(new Runnable(){

            @Override
            public void run() {
                zzbot.this.zzYb();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.zzcaJ.zzaaC()) {
            this.zzcaJ.zzi("websocket is being closed", new Object[0]);
        }
        this.zzccQ = true;
        this.zzccO.close();
        if (this.zzccV != null) {
            this.zzccV.cancel(true);
        }
        if (this.zzccU != null) {
            this.zzccU.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzXY();
        try {
            int n;
            String string = zzbsv.zzaF(map);
            String[] stringArray = zzbot.zzF(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.zzccO.zziS(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.zzccO.zziS(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.zzcaJ.zzd(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zziP(String string) {
        this.zzccS.zziT(string);
        --this.zzccR;
        if (this.zzccR == 0L) {
            try {
                this.zzccS.zzYi();
                Map<String, Object> map = zzbsv.zzje(this.zzccS.toString());
                this.zzccS = null;
                if (this.zzcaJ.zzaaC()) {
                    String string2 = String.valueOf(map);
                    this.zzcaJ.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.zzccT.zzat(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.zzccS.toString());
                this.zzcaJ.zzd(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.zzccS.toString());
                this.zzcaJ.zzd(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzqw(int n) {
        this.zzccR = n;
        this.zzccS = new zzbov();
        if (this.zzcaJ.zzaaC()) {
            long l = this.zzccR;
            this.zzcaJ.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zziQ(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzqw(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.zzqw(1);
        return string;
    }

    private void zziR(String string) {
        if (!this.zzccQ) {
            this.zzXY();
            if (this.isBuffering()) {
                this.zziP(string);
            } else {
                String string2 = this.zziQ(string);
                if (string2 != null) {
                    this.zziP(string2);
                }
            }
        }
    }

    private void zzXY() {
        if (!this.zzccQ) {
            if (this.zzccU != null) {
                this.zzccU.cancel(false);
                if (this.zzcaJ.zzaaC()) {
                    long l = this.zzccU.getDelay(TimeUnit.MILLISECONDS);
                    this.zzcaJ.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi("Reset keepAlive", new Object[0]);
            }
            this.zzccU = this.zzcax.schedule(this.zzXZ(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzXZ() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzbot.this.zzccO != null) {
                    zzbot.this.zzccO.zziS("0");
                    zzbot.this.zzXY();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.zzccS != null;
    }

    private void zzYa() {
        if (!this.zzccQ) {
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.zzccO = null;
        if (this.zzccU != null) {
            this.zzccU.cancel(false);
        }
    }

    private void shutdown() {
        this.zzccQ = true;
        this.zzccT.zzba(this.zzccP);
    }

    private void zzYb() {
        if (!this.zzccP && !this.zzccQ) {
            if (this.zzcaJ.zzaaC()) {
                this.zzcaJ.zzi("timed out on connect", new Object[0]);
            }
            this.zzccO.close();
        }
    }

    private static String[] zzF(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzbsn {
        private zzbsm zzccY;

        private zzc(zzbsm zzbsm2) {
            this.zzccY = zzbsm2;
            this.zzccY.zza(this);
        }

        @Override
        public void zzYc() {
            zzbot.this.zzcax.execute(new Runnable(){

                @Override
                public void run() {
                    zzbot.this.zzccV.cancel(false);
                    zzbot.this.zzccP = true;
                    if (zzbot.this.zzcaJ.zzaaC()) {
                        zzbot.this.zzcaJ.zzi("websocket opened", new Object[0]);
                    }
                    zzbot.this.zzXY();
                }
            });
        }

        @Override
        public void zza(zzbsq zzbsq2) {
            final String string = zzbsq2.getText();
            if (zzbot.this.zzcaJ.zzaaC()) {
                String string2 = String.valueOf(string);
                zzbot.this.zzcaJ.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzbot.this.zzcax.execute(new Runnable(){

                @Override
                public void run() {
                    zzbot.this.zziR(string);
                }
            });
        }

        @Override
        public void onClose() {
            zzbot.this.zzcax.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzbot.this.zzcaJ.zzaaC()) {
                        zzbot.this.zzcaJ.zzi("closed", new Object[0]);
                    }
                    zzbot.this.zzYa();
                }
            });
        }

        @Override
        public void zza(final zzbso zzbso2) {
            zzbot.this.zzcax.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzbso2.getCause() != null && zzbso2.getCause() instanceof EOFException) {
                        zzbot.this.zzcaJ.zzi("WebSocket reached EOF.", new Object[0]);
                    } else {
                        zzbot.this.zzcaJ.zza("WebSocket error.", zzbso2, new Object[0]);
                    }
                    zzbot.this.zzYa();
                }
            });
        }

        @Override
        public void zziS(String string) {
            this.zzccY.zziS(string);
        }

        @Override
        public void close() {
            this.zzccY.close();
        }

        private void shutdown() {
            this.zzccY.close();
            try {
                this.zzccY.zzabu();
            }
            catch (InterruptedException interruptedException) {
                zzbot.this.zzcaJ.zzd("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.zzccY.connect();
            }
            catch (zzbso zzbso2) {
                if (zzbot.this.zzcaJ.zzaaC()) {
                    zzbot.this.zzcaJ.zza("Error connecting", zzbso2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zziS(String var1);
    }

    public static interface zza {
        public void zzat(Map<String, Object> var1);

        public void zzba(boolean var1);
    }
}

