/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbsl;
import com.google.android.gms.internal.zzbsn;
import com.google.android.gms.internal.zzbso;
import com.google.android.gms.internal.zzbsp;
import com.google.android.gms.internal.zzbsr;
import com.google.android.gms.internal.zzbss;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class zzbsm {
    private static final AtomicInteger zzcjU = new AtomicInteger(0);
    private static final Charset zzcjV = Charset.forName("UTF-8");
    private volatile zza zzcjW = zza.zzcki;
    private volatile Socket zzcjX = null;
    private zzbsn zzcjY = null;
    private final URI zzcjZ;
    private final zzbsr zzcka;
    private final zzbss zzckb;
    private final zzbsp zzckc;
    private final int zzazO = zzcjU.incrementAndGet();
    private final Thread zzckd = zzbsm.getThreadFactory().newThread(new Runnable(){

        @Override
        public void run() {
            zzbsm.this.zzabv();
        }
    });
    private static ThreadFactory zzcke = Executors.defaultThreadFactory();
    private static zzbsl zzckf = new zzbsl(){

        @Override
        public void zza(Thread thread, String string) {
            thread.setName(string);
        }
    };

    static ThreadFactory getThreadFactory() {
        return zzcke;
    }

    static zzbsl zzabp() {
        return zzckf;
    }

    public static void zza(ThreadFactory threadFactory, zzbsl zzbsl2) {
        zzcke = threadFactory;
        zzckf = zzbsl2;
    }

    public zzbsm(URI uRI, String string, Map<String, String> map) {
        this.zzcjZ = uRI;
        this.zzckc = new zzbsp(uRI, string, map);
        this.zzcka = new zzbsr(this);
        this.zzckb = new zzbss(this, "TubeSock", this.zzazO);
    }

    public void zza(zzbsn zzbsn2) {
        this.zzcjY = zzbsn2;
    }

    zzbsn zzabq() {
        return this.zzcjY;
    }

    public synchronized void connect() {
        if (this.zzcjW != zza.zzcki) {
            this.zzcjY.zza(new zzbso("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzazO;
        zzbsm.zzabp().zza(this.zzabw(), new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzcjW = zza.zzckj;
        this.zzabw().start();
    }

    public synchronized void zziS(String string) {
        this.zza((byte)1, string.getBytes(zzcjV));
    }

    synchronized void zzY(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private synchronized void zza(byte by, byte[] byArray) {
        if (this.zzcjW != zza.zzckk) {
            this.zzcjY.zza(new zzbso("error while sending data: not connected"));
        } else {
            try {
                this.zzckb.zzb(by, true, byArray);
            }
            catch (IOException iOException) {
                this.zzcjY.zza(new zzbso("Failed to send frame", iOException));
                this.close();
            }
        }
    }

    void zzb(zzbso zzbso2) {
        this.zzcjY.zza(zzbso2);
        if (this.zzcjW == zza.zzckk) {
            this.close();
        }
        this.zzabs();
    }

    public synchronized void close() {
        switch (this.zzcjW) {
            case zzcki: {
                this.zzcjW = zza.zzckm;
                return;
            }
            case zzckj: {
                this.zzabs();
                return;
            }
            case zzckk: {
                this.zzabt();
                return;
            }
            case zzckl: {
                return;
            }
            case zzckm: {
                return;
            }
        }
    }

    void zzabr() {
        this.zzabs();
    }

    private synchronized void zzabs() {
        if (this.zzcjW == zza.zzckm) {
            return;
        }
        this.zzcka.zzabz();
        this.zzckb.zzabC();
        if (this.zzcjX != null) {
            try {
                this.zzcjX.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzcjW = zza.zzckm;
        this.zzcjY.onClose();
    }

    private void zzabt() {
        try {
            this.zzcjW = zza.zzckl;
            this.zzckb.zzabC();
            this.zzckb.zzb((byte)8, true, new byte[0]);
        }
        catch (IOException iOException) {
            this.zzcjY.zza(new zzbso("Failed to send close frame", iOException));
        }
    }

    private Socket createSocket() {
        Socket socket;
        String string = this.zzcjZ.getScheme();
        String string2 = this.zzcjZ.getHost();
        int n = this.zzcjZ.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzbso(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzcjZ);
                throw new zzbso(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SocketFactory socketFactory = SSLSocketFactory.getDefault();
                SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzcjZ);
                    throw new zzbso(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzbso(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzcjZ);
                throw new zzbso(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzbso(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public void zzabu() throws InterruptedException {
        if (this.zzckb.zzabw().getState() != Thread.State.NEW) {
            this.zzckb.zzabw().join();
        }
        this.zzabw().join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zzabv() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.zzcjX = socket;
                if (this.zzcjW == zza.zzckm) {
                    try {
                        this.zzcjX.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.zzcjX = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzckc.zzabx());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                Object object2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzbso("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    object2 = new String(byArray, zzcjV);
                    if (((String)object2).trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(((String)object2).trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                object2 = new String(byArray, zzcjV);
                String string2 = String.valueOf(object2);
                if (string2.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string2);
                    throw new zzbso(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzbso(string);
            }
            this.zzckc.zzjc((String)arrayList.get(0));
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : arrayList) {
                String[] stringArray = string.split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            this.zzckc.zzc(hashMap);
            this.zzckb.zzb(outputStream);
            this.zzcka.zza((DataInputStream)object);
            this.zzcjW = zza.zzckk;
            this.zzckb.zzabw().start();
            this.zzcjY.zzYc();
            this.zzcka.run();
            return;
        }
        catch (zzbso zzbso2) {
            this.zzcjY.zza(zzbso2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzcjY.zza(new zzbso(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    Thread zzabw() {
        return this.zzckd;
    }

    private static final class zza
    extends Enum<zza> {
        public static final /* enum */ zza zzcki = new zza();
        public static final /* enum */ zza zzckj = new zza();
        public static final /* enum */ zza zzckk = new zza();
        public static final /* enum */ zza zzckl = new zza();
        public static final /* enum */ zza zzckm = new zza();
        private static final /* synthetic */ zza[] zzckn;

        public static zza[] values() {
            return (zza[])zzckn.clone();
        }

        static {
            zzckn = new zza[]{zzcki, zzckj, zzckk, zzckl, zzckm};
        }
    }
}

