/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbol;
import com.google.android.gms.internal.zzbon;
import com.google.android.gms.internal.zzbov;
import com.google.android.gms.internal.zzbrn;
import com.google.android.gms.internal.zzbsm;
import com.google.android.gms.internal.zzbsn;
import com.google.android.gms.internal.zzbso;
import com.google.android.gms.internal.zzbsq;
import com.google.android.gms.internal.zzbsv;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzbot {
    private static long zzccJ = 0L;
    private zzb zzccK;
    private boolean zzccL = false;
    private boolean zzccM = false;
    private long zzccN = 0L;
    private zzbov zzccO;
    private zza zzccP;
    private ScheduledFuture<?> zzccQ;
    private ScheduledFuture<?> zzccR;
    private final zzbol zzccS;
    private final ScheduledExecutorService zzcat;
    private final zzbrn zzcaF;

    public zzbot(zzbol zzbol2, zzbon zzbon2, String string, zza zza2, String string2) {
        this.zzccS = zzbol2;
        this.zzcat = zzbol2.zzXt();
        this.zzccP = zza2;
        long l = zzccJ++;
        this.zzcaF = new zzbrn(zzbol2.zzXr(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.zzccK = this.zza(zzbon2, string, string2);
    }

    private zzb zza(zzbon zzbon2, String string, String string2) {
        String string3 = string != null ? string : zzbon2.getHost();
        URI uRI = zzbon.zza(string3, zzbon2.isSecure(), zzbon2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.zzccS.zzkn());
        zzbsm zzbsm2 = new zzbsm(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzbsm2);
        return zzc2;
    }

    public void open() {
        this.zzccK.connect();
        this.zzccR = this.zzcat.schedule(new Runnable(){

            @Override
            public void run() {
                zzbot.this.zzYc();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.zzcaF.zzaaD()) {
            this.zzcaF.zzi("websocket is being closed", new Object[0]);
        }
        this.zzccM = true;
        this.zzccK.close();
        if (this.zzccR != null) {
            this.zzccR.cancel(true);
        }
        if (this.zzccQ != null) {
            this.zzccQ.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzXZ();
        try {
            int n;
            String string = zzbsv.zzaF(map);
            String[] stringArray = zzbot.zzF(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.zzccK.zziS(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.zzccK.zziS(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.zzcaF.zzd(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zziP(String string) {
        this.zzccO.zziT(string);
        --this.zzccN;
        if (this.zzccN == 0L) {
            try {
                this.zzccO.zzYj();
                Map<String, Object> map = zzbsv.zzje(this.zzccO.toString());
                this.zzccO = null;
                if (this.zzcaF.zzaaD()) {
                    String string2 = String.valueOf(map);
                    this.zzcaF.zzi(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.zzccP.zzat(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.zzccO.toString());
                this.zzcaF.zzd(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.zzccO.toString());
                this.zzcaF.zzd(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zzqw(int n) {
        this.zzccN = n;
        this.zzccO = new zzbov();
        if (this.zzcaF.zzaaD()) {
            long l = this.zzccN;
            this.zzcaF.zzi(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zziQ(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zzqw(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.zzqw(1);
        return string;
    }

    private void zziR(String string) {
        if (!this.zzccM) {
            this.zzXZ();
            if (this.isBuffering()) {
                this.zziP(string);
            } else {
                String string2 = this.zziQ(string);
                if (string2 != null) {
                    this.zziP(string2);
                }
            }
        }
    }

    private void zzXZ() {
        if (!this.zzccM) {
            if (this.zzccQ != null) {
                this.zzccQ.cancel(false);
                if (this.zzcaF.zzaaD()) {
                    long l = this.zzccQ.getDelay(TimeUnit.MILLISECONDS);
                    this.zzcaF.zzi(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.zzcaF.zzaaD()) {
                this.zzcaF.zzi("Reset keepAlive", new Object[0]);
            }
            this.zzccQ = this.zzcat.schedule(this.zzYa(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzYa() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzbot.this.zzccK != null) {
                    zzbot.this.zzccK.zziS("0");
                    zzbot.this.zzXZ();
                }
            }
        };
    }

    private boolean isBuffering() {
        return this.zzccO != null;
    }

    private void zzYb() {
        if (!this.zzccM) {
            if (this.zzcaF.zzaaD()) {
                this.zzcaF.zzi("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.zzccK = null;
        if (this.zzccQ != null) {
            this.zzccQ.cancel(false);
        }
    }

    private void shutdown() {
        this.zzccM = true;
        this.zzccP.zzba(this.zzccL);
    }

    private void zzYc() {
        if (!this.zzccL && !this.zzccM) {
            if (this.zzcaF.zzaaD()) {
                this.zzcaF.zzi("timed out on connect", new Object[0]);
            }
            this.zzccK.close();
        }
    }

    private static String[] zzF(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzbsn {
        private zzbsm zzccU;

        private zzc(zzbsm zzbsm2) {
            this.zzccU = zzbsm2;
            this.zzccU.zza(this);
        }

        @Override
        public void zzYd() {
            zzbot.this.zzcat.execute(new Runnable(){

                @Override
                public void run() {
                    zzbot.this.zzccR.cancel(false);
                    zzbot.this.zzccL = true;
                    if (zzbot.this.zzcaF.zzaaD()) {
                        zzbot.this.zzcaF.zzi("websocket opened", new Object[0]);
                    }
                    zzbot.this.zzXZ();
                }
            });
        }

        @Override
        public void zza(zzbsq zzbsq2) {
            final String string = zzbsq2.getText();
            if (zzbot.this.zzcaF.zzaaD()) {
                String string2 = String.valueOf(string);
                zzbot.this.zzcaF.zzi(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzbot.this.zzcat.execute(new Runnable(){

                @Override
                public void run() {
                    zzbot.this.zziR(string);
                }
            });
        }

        @Override
        public void onClose() {
            zzbot.this.zzcat.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzbot.this.zzcaF.zzaaD()) {
                        zzbot.this.zzcaF.zzi("closed", new Object[0]);
                    }
                    zzbot.this.zzYb();
                }
            });
        }

        @Override
        public void zza(final zzbso zzbso2) {
            zzbot.this.zzcat.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzbso2.getCause() != null && zzbso2.getCause() instanceof EOFException) {
                        zzbot.this.zzcaF.zzi("WebSocket reached EOF.", new Object[0]);
                    } else {
                        zzbot.this.zzcaF.zza("WebSocket error.", zzbso2, new Object[0]);
                    }
                    zzbot.this.zzYb();
                }
            });
        }

        @Override
        public void zziS(String string) {
            this.zzccU.zziS(string);
        }

        @Override
        public void close() {
            this.zzccU.close();
        }

        private void shutdown() {
            this.zzccU.close();
            try {
                this.zzccU.zzabv();
            }
            catch (InterruptedException interruptedException) {
                zzbot.this.zzcaF.zzd("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.zzccU.connect();
            }
            catch (zzbso zzbso2) {
                if (zzbot.this.zzcaF.zzaaD()) {
                    zzbot.this.zzcaF.zza("Error connecting", zzbso2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zziS(String var1);
    }

    public static interface zza {
        public void zzat(Map<String, Object> var1);

        public void zzba(boolean var1);
    }
}

