/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.xu;
import com.google.android.gms.internal.xw;
import com.google.android.gms.internal.xx;
import com.google.android.gms.internal.xy;
import com.google.android.gms.internal.xz;
import com.google.android.gms.internal.ya;
import com.google.android.gms.internal.yb;
import com.google.android.gms.internal.yd;
import com.google.android.gms.internal.ye;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class xv {
    private static final AtomicInteger zzciI = new AtomicInteger(0);
    private static final Charset zzciJ = Charset.forName("UTF-8");
    private volatile int zzciK = xy.zzciU;
    private volatile Socket socket = null;
    private xz zzciL = null;
    private final URI zzciM;
    private final yd zzciN;
    private final ye zzciO;
    private final yb zzciP;
    private final int zzaBC = zzciI.incrementAndGet();
    private final Thread zzciQ = zzciR.newThread(new xx(this));
    private static ThreadFactory zzciR = Executors.defaultThreadFactory();
    private static xu zzciS = new xw();

    static ThreadFactory getThreadFactory() {
        return zzciR;
    }

    static xu zzJm() {
        return zzciS;
    }

    public static void zza(ThreadFactory threadFactory, xu xu2) {
        zzciR = threadFactory;
        zzciS = xu2;
    }

    public xv(URI uRI, String string, Map<String, String> map) {
        this.zzciM = uRI;
        this.zzciP = new yb(uRI, null, map);
        this.zzciN = new yd(this);
        this.zzciO = new ye(this, "TubeSock", this.zzaBC);
    }

    public final void zza(xz xz2) {
        this.zzciL = xz2;
    }

    final xz zzJn() {
        return this.zzciL;
    }

    public final synchronized void connect() {
        if (this.zzciK != xy.zzciU) {
            this.zzciL.zza(new ya("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzaBC;
        zzciS.zza(this.zzciQ, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzciK = xy.zzciV;
        this.zzciQ.start();
    }

    public final synchronized void zzgM(String string) {
        this.zza((byte)1, string.getBytes(zzciJ));
    }

    final synchronized void zzE(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzciK != xy.zzciW) {
            this.zzciL.zza(new ya("error while sending data: not connected"));
            return;
        }
        try {
            this.zzciO.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzciL.zza(new ya("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(ya ya2) {
        this.zzciL.zza(ya2);
        if (this.zzciK == xy.zzciW) {
            this.close();
        }
        this.zzJp();
    }

    public final synchronized void close() {
        switch (this.zzciK - 1) {
            case 0: {
                this.zzciK = xy.zzciY;
                return;
            }
            case 1: {
                this.zzJp();
                return;
            }
            case 2: {
                xv xv2 = this;
                try {
                    xv2.zzciK = xy.zzciX;
                    xv2.zzciO.zzJw();
                    xv2.zzciO.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    xv2.zzciL.zza(new ya("Failed to send close frame", iOException));
                    return;
                }
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
        }
    }

    final void zzJo() {
        this.zzJp();
    }

    private final synchronized void zzJp() {
        if (this.zzciK == xy.zzciY) {
            return;
        }
        this.zzciN.zzJu();
        this.zzciO.zzJw();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzciK = xy.zzciY;
        this.zzciL.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzciM.getScheme();
        String string2 = this.zzciM.getHost();
        int n = this.zzciM.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new ya(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzciM);
                throw new ya(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzciM);
                    throw new ya(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new ya(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzciM);
                throw new ya(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new ya(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzJq() throws InterruptedException {
        if (this.zzciO.zzJy().getState() != Thread.State.NEW) {
            this.zzciO.zzJy().join();
        }
        this.zzciQ.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzJr() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzciK == xy.zzciY) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzciP.zzJs());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new ya("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzciJ);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzciJ);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new ya(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new ya(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new ya("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new ya("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new ya(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new ya("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new ya("connection failed: missing header field in server handshake: Connection");
            }
            this.zzciO.zzb(outputStream);
            this.zzciN.zza((DataInputStream)object);
            this.zzciK = xy.zzciW;
            this.zzciO.zzJy().start();
            this.zzciL.zzGx();
            this.zzciN.run();
            return;
        }
        catch (ya ya2) {
            this.zzciL.zza(ya2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzciL.zza(new ya(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(xv xv2) {
        xv2.zzJr();
    }
}

