/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.yc;
import com.google.android.gms.internal.ye;
import com.google.android.gms.internal.yf;
import com.google.android.gms.internal.yg;
import com.google.android.gms.internal.yh;
import com.google.android.gms.internal.yi;
import com.google.android.gms.internal.yj;
import com.google.android.gms.internal.yk;
import com.google.android.gms.internal.ym;
import com.google.android.gms.internal.yn;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class yd {
    private static final AtomicInteger zzciL = new AtomicInteger(0);
    private static final Charset zzciM = Charset.forName("UTF-8");
    private volatile int zzciN = yh.zzciY;
    private volatile Socket socket = null;
    private yi zzciO = null;
    private final URI zzciP;
    private final ym zzciQ;
    private final yn zzciR;
    private final yk zzciS;
    private final int zzaBC = zzciL.incrementAndGet();
    private final Thread zzciT = zzciU.newThread(new yf(this));
    private static ThreadFactory zzciU = Executors.defaultThreadFactory();
    private static yc zzciV = new ye();

    static ThreadFactory getThreadFactory() {
        return zzciU;
    }

    static yc zzJo() {
        return zzciV;
    }

    public static void zza(ThreadFactory threadFactory, yc yc2) {
        zzciU = threadFactory;
        zzciV = yc2;
    }

    public yd(URI uRI, String string, Map<String, String> map) {
        this.zzciP = uRI;
        this.zzciS = new yk(uRI, null, map);
        this.zzciQ = new ym(this);
        this.zzciR = new yn(this, "TubeSock", this.zzaBC);
    }

    public final void zza(yi yi2) {
        this.zzciO = yi2;
    }

    final yi zzJp() {
        return this.zzciO;
    }

    public final synchronized void connect() {
        if (this.zzciN != yh.zzciY) {
            this.zzciO.zza(new yj("connect() already called"));
            this.close();
            return;
        }
        String string = String.valueOf("TubeSockReader-");
        int n = this.zzaBC;
        zzciV.zza(this.zzciT, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzciN = yh.zzciZ;
        this.zzciT.start();
    }

    public final synchronized void zzgM(String string) {
        this.zza((byte)1, string.getBytes(zzciM));
    }

    final synchronized void zzE(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzciN != yh.zzcja) {
            this.zzciO.zza(new yj("error while sending data: not connected"));
            return;
        }
        try {
            this.zzciR.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzciO.zza(new yj("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(yj yj2) {
        this.zzciO.zza(yj2);
        if (this.zzciN == yh.zzcja) {
            this.close();
        }
        this.zzJr();
    }

    public final synchronized void close() {
        switch (yg.zzciX[this.zzciN - 1]) {
            case 1: {
                this.zzciN = yh.zzcjc;
                return;
            }
            case 2: {
                this.zzJr();
                return;
            }
            case 3: {
                yd yd2 = this;
                try {
                    yd2.zzciN = yh.zzcjb;
                    yd2.zzciR.zzJz();
                    yd2.zzciR.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    yd2.zzciO.zza(new yj("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzJq() {
        this.zzJr();
    }

    private final synchronized void zzJr() {
        if (this.zzciN == yh.zzcjc) {
            return;
        }
        this.zzciQ.zzJx();
        this.zzciR.zzJz();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzciN = yh.zzcjc;
        this.zzciO.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzciP.getScheme();
        String string2 = this.zzciP.getHost();
        int n = this.zzciP.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new yj(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzciP);
                throw new yj(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzciP);
                    throw new yj(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new yj(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzciP);
                throw new yj(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new yj(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzJs() throws InterruptedException {
        if (this.zzciR.zzJB().getState() != Thread.State.NEW) {
            this.zzciR.zzJB().join();
        }
        this.zzciT.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzJt() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzciN == yh.zzcjc) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzciS.zzJv());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new yj("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzciM);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzciM);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new yj(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new yj(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new yj("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new yj("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new yj(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new yj("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new yj("connection failed: missing header field in server handshake: Connection");
            }
            this.zzciR.zzb(outputStream);
            this.zzciQ.zza((DataInputStream)object);
            this.zzciN = yh.zzcja;
            this.zzciR.zzJB().start();
            this.zzciO.zzGy();
            this.zzciQ.run();
            return;
        }
        catch (yj yj2) {
            this.zzciO.zza(yj2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzciO.zza(new yj(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(yd yd2) {
        yd2.zzJt();
    }
}

