/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdyb;
import com.google.android.gms.internal.zzdyd;
import com.google.android.gms.internal.zzdye;
import com.google.android.gms.internal.zzdyf;
import com.google.android.gms.internal.zzdyg;
import com.google.android.gms.internal.zzdyh;
import com.google.android.gms.internal.zzdyi;
import com.google.android.gms.internal.zzdyj;
import com.google.android.gms.internal.zzdyl;
import com.google.android.gms.internal.zzdym;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class zzdyc {
    private static final AtomicInteger zzmfm = new AtomicInteger(0);
    private static final Charset zzmfn = Charset.forName("UTF-8");
    private volatile int zzmfo = zzdyg.zzmfz;
    private volatile Socket socket = null;
    private zzdyh zzmfp = null;
    private final URI zzmfq;
    private final zzdyl zzmfr;
    private final zzdym zzmfs;
    private final zzdyj zzmft;
    private final int zzfif = zzmfm.incrementAndGet();
    private final Thread zzmfu = zzmfv.newThread(new zzdye(this));
    private static ThreadFactory zzmfv = Executors.defaultThreadFactory();
    private static zzdyb zzmfw = new zzdyd();

    static ThreadFactory getThreadFactory() {
        return zzmfv;
    }

    static zzdyb zzbxh() {
        return zzmfw;
    }

    public static void zza(ThreadFactory threadFactory, zzdyb zzdyb2) {
        zzmfv = threadFactory;
        zzmfw = zzdyb2;
    }

    public zzdyc(URI uRI, String string, Map<String, String> map) {
        this.zzmfq = uRI;
        this.zzmft = new zzdyj(uRI, null, map);
        this.zzmfr = new zzdyl(this);
        this.zzmfs = new zzdym(this, "TubeSock", this.zzfif);
    }

    public final void zza(zzdyh zzdyh2) {
        this.zzmfp = zzdyh2;
    }

    final zzdyh zzbxi() {
        return this.zzmfp;
    }

    public final synchronized void connect() {
        if (this.zzmfo != zzdyg.zzmfz) {
            this.zzmfp.zza(new zzdyi("connect() already called"));
            this.close();
            return;
        }
        String string = "TubeSockReader-";
        int n = this.zzfif;
        zzmfw.zza(this.zzmfu, new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString());
        this.zzmfo = zzdyg.zzmga;
        this.zzmfu.start();
    }

    public final synchronized void zzox(String string) {
        this.zza((byte)1, string.getBytes(zzmfn));
    }

    final synchronized void zzan(byte[] byArray) {
        this.zza((byte)10, byArray);
    }

    private final synchronized void zza(byte by, byte[] byArray) {
        if (this.zzmfo != zzdyg.zzmgb) {
            this.zzmfp.zza(new zzdyi("error while sending data: not connected"));
            return;
        }
        try {
            this.zzmfs.zza(by, true, byArray);
            return;
        }
        catch (IOException iOException) {
            this.zzmfp.zza(new zzdyi("Failed to send frame", iOException));
            this.close();
            return;
        }
    }

    final void zzb(zzdyi zzdyi2) {
        this.zzmfp.zza(zzdyi2);
        if (this.zzmfo == zzdyg.zzmgb) {
            this.close();
        }
        this.zzbxk();
    }

    public final synchronized void close() {
        switch (zzdyf.zzmfy[this.zzmfo - 1]) {
            case 1: {
                this.zzmfo = zzdyg.zzmgd;
                return;
            }
            case 2: {
                this.zzbxk();
                return;
            }
            case 3: {
                zzdyc zzdyc2 = this;
                try {
                    zzdyc2.zzmfo = zzdyg.zzmgc;
                    zzdyc2.zzmfs.zzbxr();
                    zzdyc2.zzmfs.zza((byte)8, true, new byte[0]);
                    return;
                }
                catch (IOException iOException) {
                    zzdyc2.zzmfp.zza(new zzdyi("Failed to send close frame", iOException));
                    return;
                }
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    final void zzbxj() {
        this.zzbxk();
    }

    private final synchronized void zzbxk() {
        if (this.zzmfo == zzdyg.zzmgd) {
            return;
        }
        this.zzmfr.zzbxp();
        this.zzmfs.zzbxr();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zzmfo = zzdyg.zzmgd;
        this.zzmfp.onClose();
    }

    private final Socket createSocket() {
        Socket socket;
        String string = this.zzmfq.getScheme();
        String string2 = this.zzmfq.getHost();
        int n = this.zzmfq.getPort();
        if (string != null && string.equals("ws")) {
            if (n == -1) {
                n = 80;
            }
            try {
                socket = new Socket(string2, n);
            }
            catch (UnknownHostException unknownHostException) {
                String string3 = String.valueOf(string2);
                throw new zzdyi(string3.length() != 0 ? "unknown host: ".concat(string3) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string4 = String.valueOf(this.zzmfq);
                throw new zzdyi(new StringBuilder(31 + String.valueOf(string4).length()).append("error while creating socket to ").append(string4).toString(), iOException);
            }
        } else if (string != null && string.equals("wss")) {
            if (n == -1) {
                n = 443;
            }
            try {
                SSLSocket sSLSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(string2, n);
                HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                SSLSession sSLSession = sSLSocket.getSession();
                if (!hostnameVerifier.verify(string2, sSLSession)) {
                    String string5 = String.valueOf(this.zzmfq);
                    throw new zzdyi(new StringBuilder(39 + String.valueOf(string5).length()).append("Error while verifying secure socket to ").append(string5).toString());
                }
                socket = sSLSocket;
            }
            catch (UnknownHostException unknownHostException) {
                String string6 = String.valueOf(string2);
                throw new zzdyi(string6.length() != 0 ? "unknown host: ".concat(string6) : new String("unknown host: "), unknownHostException);
            }
            catch (IOException iOException) {
                String string7 = String.valueOf(this.zzmfq);
                throw new zzdyi(new StringBuilder(38 + String.valueOf(string7).length()).append("error while creating secure socket to ").append(string7).toString(), iOException);
            }
        } else {
            String string8 = String.valueOf(string);
            throw new zzdyi(string8.length() != 0 ? "unsupported protocol: ".concat(string8) : new String("unsupported protocol: "));
        }
        return socket;
    }

    public final void zzbxl() throws InterruptedException {
        if (this.zzmfs.zzbxt().getState() != Thread.State.NEW) {
            this.zzmfs.zzbxt().join();
        }
        this.zzmfu.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzbxm() {
        try {
            Socket socket = this.createSocket();
            Object object = this;
            synchronized (object) {
                this.socket = socket;
                if (this.zzmfo == zzdyg.zzmgd) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    this.socket = null;
                    return;
                }
            }
            object = new DataInputStream(socket.getInputStream());
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(this.zzmft.zzbxn());
            boolean bl = false;
            byte[] byArray = new byte[1000];
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (!bl) {
                String string;
                String string2;
                int n2 = ((FilterInputStream)object).read();
                if (n2 == -1) {
                    throw new zzdyi("Connection closed before handshake was complete");
                }
                byArray[n] = (byte)n2;
                if (byArray[++n - 1] == 10 && byArray[n - 2] == 13) {
                    string2 = new String(byArray, zzmfn);
                    if (string2.trim().equals("")) {
                        bl = true;
                    } else {
                        arrayList.add(string2.trim());
                    }
                    byArray = new byte[1000];
                    n = 0;
                    continue;
                }
                if (n != 1000) continue;
                string2 = new String(byArray, zzmfn);
                String string3 = String.valueOf(string2);
                if (string3.length() != 0) {
                    string = "Unexpected long line in handshake: ".concat(string3);
                    throw new zzdyi(string);
                }
                string = new String("Unexpected long line in handshake: ");
                throw new zzdyi(string);
            }
            int n3 = Integer.valueOf(((String)arrayList.get(0)).substring(9, 12));
            if (n3 == 407) {
                throw new zzdyi("connection failed: proxy authentication not supported");
            }
            if (n3 == 404) {
                throw new zzdyi("connection failed: 404 not found");
            }
            if (n3 != 101) {
                throw new zzdyi(new StringBuilder(50).append("connection failed: unknown status code ").append(n3).toString());
            }
            arrayList.remove(0);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ArrayList<String> arrayList2 = arrayList;
            int n4 = arrayList2.size();
            for (int i = 0; i < n4; ++i) {
                Object e = arrayList2.get(i);
                String[] stringArray = ((String)e).split(": ", 2);
                hashMap.put(stringArray[0], stringArray[1]);
            }
            HashMap<String, String> hashMap2 = hashMap;
            if (!((String)hashMap2.get("Upgrade")).toLowerCase(Locale.US).equals("websocket")) {
                throw new zzdyi("connection failed: missing header field in server handshake: Upgrade");
            }
            if (!((String)hashMap2.get("Connection")).toLowerCase(Locale.US).equals("upgrade")) {
                throw new zzdyi("connection failed: missing header field in server handshake: Connection");
            }
            this.zzmfs.zzb(outputStream);
            this.zzmfr.zza((DataInputStream)object);
            this.zzmfo = zzdyg.zzmgb;
            this.zzmfs.zzbxt().start();
            this.zzmfp.zzbrs();
            this.zzmfr.run();
            return;
        }
        catch (zzdyi zzdyi2) {
            this.zzmfp.zza(zzdyi2);
            return;
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            this.zzmfp.zza(new zzdyi(string.length() != 0 ? "error while connecting: ".concat(string) : new String("error while connecting: "), iOException));
            return;
        }
        finally {
            this.close();
        }
    }

    static /* synthetic */ void zza(zzdyc zzdyc2) {
        zzdyc2.zzbxm();
    }
}

