/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaef;
import com.google.android.gms.internal.zzaeh;
import com.google.android.gms.internal.zzaep;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaie;
import com.google.android.gms.internal.zzaif;
import com.google.android.gms.internal.zzaig;
import com.google.android.gms.internal.zzaii;
import com.google.android.gms.internal.zzaim;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class zzaen {
    private static long zzbJZ = 0L;
    private zzb zzbKa;
    private boolean zzbKb = false;
    private boolean zzbKc = false;
    private long zzbKd = 0L;
    private zzaep zzbKe;
    private zza zzbKf;
    private ScheduledFuture<?> zzbKg;
    private ScheduledFuture<?> zzbKh;
    private final zzaef zzbKi;
    private final ScheduledExecutorService zzbHI;
    private final zzahf zzbHV;

    public zzaen(zzaef zzaef2, zzaeh zzaeh2, String string, zza zza2, String string2) {
        this.zzbKi = zzaef2;
        this.zzbHI = zzaef2.zzPV();
        this.zzbKf = zza2;
        long l = zzbJZ++;
        this.zzbHV = new zzahf(zzaef2.zzPT(), "WebSocket", new StringBuilder(23).append("ws_").append(l).toString());
        this.zzbKa = this.zza(zzaeh2, string, string2);
    }

    private zzb zza(zzaeh zzaeh2, String string, String string2) {
        String string3 = string != null ? string : zzaeh2.getHost();
        URI uRI = zzaeh.zza(string3, zzaeh2.isSecure(), zzaeh2.getNamespace(), string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", this.zzbKi.zziJ());
        zzaie zzaie2 = new zzaie(uRI, null, hashMap);
        zzc zzc2 = new zzc(zzaie2);
        return zzc2;
    }

    public void open() {
        this.zzbKa.connect();
        this.zzbKh = this.zzbHI.schedule(new Runnable(){

            @Override
            public void run() {
                zzaen.this.zzQB();
            }
        }, 30000L, TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void close() {
        if (this.zzbHV.zzTe()) {
            this.zzbHV.zzh("websocket is being closed", new Object[0]);
        }
        this.zzbKc = true;
        this.zzbKa.close();
        if (this.zzbKh != null) {
            this.zzbKh.cancel(true);
        }
        if (this.zzbKg != null) {
            this.zzbKg.cancel(true);
        }
    }

    public void send(Map<String, Object> map) {
        this.zzQx();
        try {
            int n;
            String string = zzaim.zzaB(map);
            String[] stringArray = zzaen.zzD(string, 16384);
            if (stringArray.length > 1) {
                n = stringArray.length;
                this.zzbKa.zzhZ(new StringBuilder(11).append(n).toString());
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.zzbKa.zzhZ(stringArray[n]);
            }
        }
        catch (IOException iOException) {
            String string = String.valueOf(map.toString());
            this.zzbHV.zze(string.length() != 0 ? "Failed to serialize message: ".concat(string) : new String("Failed to serialize message: "), iOException);
            this.shutdown();
        }
    }

    private void zzhW(String string) {
        this.zzbKe.zzia(string);
        --this.zzbKd;
        if (this.zzbKd == 0L) {
            try {
                this.zzbKe.zzQH();
                Map<String, Object> map = zzaim.zzij(this.zzbKe.toString());
                this.zzbKe = null;
                if (this.zzbHV.zzTe()) {
                    String string2 = String.valueOf(map);
                    this.zzbHV.zzh(new StringBuilder(36 + String.valueOf(string2).length()).append("handleIncomingFrame complete frame: ").append(string2).toString(), new Object[0]);
                }
                this.zzbKf.zzap(map);
            }
            catch (IOException iOException) {
                String string3 = String.valueOf(this.zzbKe.toString());
                this.zzbHV.zze(string3.length() != 0 ? "Error parsing frame: ".concat(string3) : new String("Error parsing frame: "), iOException);
                this.close();
                this.shutdown();
            }
            catch (ClassCastException classCastException) {
                String string4 = String.valueOf(this.zzbKe.toString());
                this.zzbHV.zze(string4.length() != 0 ? "Error parsing frame (cast error): ".concat(string4) : new String("Error parsing frame (cast error): "), classCastException);
                this.close();
                this.shutdown();
            }
        }
    }

    private void zznx(int n) {
        this.zzbKd = n;
        this.zzbKe = new zzaep();
        if (this.zzbHV.zzTe()) {
            long l = this.zzbKd;
            this.zzbHV.zzh(new StringBuilder(41).append("HandleNewFrameCount: ").append(l).toString(), new Object[0]);
        }
    }

    private String zzhX(String string) {
        if (string.length() <= 6) {
            try {
                int n = Integer.parseInt(string);
                if (n > 0) {
                    this.zznx(n);
                }
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.zznx(1);
        return string;
    }

    private void zzhY(String string) {
        if (!this.zzbKc) {
            this.zzQx();
            if (this.zzQz()) {
                this.zzhW(string);
            } else {
                String string2 = this.zzhX(string);
                if (string2 != null) {
                    this.zzhW(string2);
                }
            }
        }
    }

    private void zzQx() {
        if (!this.zzbKc) {
            if (this.zzbKg != null) {
                this.zzbKg.cancel(false);
                if (this.zzbHV.zzTe()) {
                    long l = this.zzbKg.getDelay(TimeUnit.MILLISECONDS);
                    this.zzbHV.zzh(new StringBuilder(48).append("Reset keepAlive. Remaining: ").append(l).toString(), new Object[0]);
                }
            } else if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh("Reset keepAlive", new Object[0]);
            }
            this.zzbKg = this.zzbHI.schedule(this.zzQy(), 45000L, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable zzQy() {
        return new Runnable(){

            @Override
            public void run() {
                if (zzaen.this.zzbKa != null) {
                    zzaen.this.zzbKa.zzhZ("0");
                    zzaen.this.zzQx();
                }
            }
        };
    }

    private boolean zzQz() {
        return this.zzbKe != null;
    }

    private void zzQA() {
        if (!this.zzbKc) {
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh("closing itself", new Object[0]);
            }
            this.shutdown();
        }
        this.zzbKa = null;
        if (this.zzbKg != null) {
            this.zzbKg.cancel(false);
        }
    }

    private void shutdown() {
        this.zzbKc = true;
        this.zzbKf.zzaM(this.zzbKb);
    }

    private void zzQB() {
        if (!this.zzbKb && !this.zzbKc) {
            if (this.zzbHV.zzTe()) {
                this.zzbHV.zzh("timed out on connect", new Object[0]);
            }
            this.zzbKa.close();
        }
    }

    private static String[] zzD(String string, int n) {
        if (string.length() <= n) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Math.min(i + n, string.length());
            String string2 = string.substring(i, n2);
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class zzc
    implements zzb,
    zzaif {
        private zzaie zzbKk;

        private zzc(zzaie zzaie2) {
            this.zzbKk = zzaie2;
            this.zzbKk.zza(this);
        }

        @Override
        public void zzQC() {
            zzaen.this.zzbHI.execute(new Runnable(){

                @Override
                public void run() {
                    zzaen.this.zzbKh.cancel(false);
                    zzaen.this.zzbKb = true;
                    if (zzaen.this.zzbHV.zzTe()) {
                        zzaen.this.zzbHV.zzh("websocket opened", new Object[0]);
                    }
                    zzaen.this.zzQx();
                }
            });
        }

        @Override
        public void zza(zzaii zzaii2) {
            final String string = zzaii2.getText();
            if (zzaen.this.zzbHV.zzTe()) {
                String string2 = String.valueOf(string);
                zzaen.this.zzbHV.zzh(string2.length() != 0 ? "ws message: ".concat(string2) : new String("ws message: "), new Object[0]);
            }
            zzaen.this.zzbHI.execute(new Runnable(){

                @Override
                public void run() {
                    zzaen.this.zzhY(string);
                }
            });
        }

        @Override
        public void onClose() {
            String string = "closed";
            zzaen.this.zzbHI.execute(new Runnable(){

                @Override
                public void run() {
                    if (zzaen.this.zzbHV.zzTe()) {
                        zzaen.this.zzbHV.zzh("closed", new Object[0]);
                    }
                    zzaen.this.zzQA();
                }
            });
        }

        @Override
        public void zza(final zzaig zzaig2) {
            zzaen.this.zzbHI.execute(new Runnable(){

                @Override
                public void run() {
                    String string = "had an error";
                    if (zzaen.this.zzbHV.zzTe()) {
                        zzaen.this.zzbHV.zza(string, zzaig2, new Object[0]);
                    }
                    if (zzaig2.getMessage().startsWith("unknown host")) {
                        if (zzaen.this.zzbHV.zzTe()) {
                            zzaen.this.zzbHV.zzh("If you are running on Android, have you added <uses-permission android:name=\"android.permission.INTERNET\" /> under <manifest> in AndroidManifest.xml?", new Object[0]);
                        }
                    } else if (zzaen.this.zzbHV.zzTe()) {
                        String string2 = String.valueOf(zzaig2.getMessage());
                        zzaen.this.zzbHV.zzh(new StringBuilder(2 + String.valueOf(string2).length()).append("|").append(string2).append("|").toString(), new Object[0]);
                    }
                    zzaen.this.zzQA();
                }
            });
        }

        @Override
        public void zzhZ(String string) {
            this.zzbKk.zzhZ(string);
        }

        @Override
        public void close() {
            this.zzbKk.close();
        }

        private void shutdown() {
            this.zzbKk.close();
            try {
                this.zzbKk.zzTW();
            }
            catch (InterruptedException interruptedException) {
                zzaen.this.zzbHV.zze("Interrupted while shutting down websocket threads", interruptedException);
            }
        }

        @Override
        public void connect() {
            try {
                this.zzbKk.connect();
            }
            catch (zzaig zzaig2) {
                if (zzaen.this.zzbHV.zzTe()) {
                    zzaen.this.zzbHV.zza("Error connecting", zzaig2, new Object[0]);
                }
                this.shutdown();
            }
        }
    }

    private static interface zzb {
        public void connect();

        public void close();

        public void zzhZ(String var1);
    }

    public static interface zza {
        public void zzap(Map<String, Object> var1);

        public void zzaM(boolean var1);
    }
}

