/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzboy;
import com.google.android.gms.internal.zzbpb;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbpw;
import com.google.android.gms.internal.zzbrq;
import com.google.android.gms.internal.zzbsc;
import com.google.android.gms.internal.zzbsd;
import com.google.android.gms.internal.zzbsg;
import com.google.android.gms.internal.zzbtb;
import com.google.android.gms.internal.zzbtd;
import com.google.android.gms.internal.zzbte;
import com.google.android.gms.internal.zzbtf;
import com.google.android.gms.internal.zzbtg;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzbpb zzbZQ;

    DatabaseReference(zzbpj zzbpj2, zzbph zzbph2) {
        super(zzbpj2, zzbph2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzWL().isEmpty()) {
            zzbtf.zzjm(string);
        } else {
            zzbtf.zzjl(string);
        }
        zzbph zzbph2 = this.zzWL().zzh(new zzbph(string));
        return new DatabaseReference(this.zzcad, zzbph2);
    }

    public DatabaseReference push() {
        String string = zzbtd.zzaT(this.zzcad.zzYY());
        zzbrq zzbrq2 = zzbrq.zzja(string);
        return new DatabaseReference(this.zzcad, this.zzWL().zza(zzbrq2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzbsg.zzau(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzbsg.zzau(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzbsg.zzau(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzbsg.zzau(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzbsc zzbsc2, CompletionListener completionListener) {
        zzbtf.zzQ(this.zzWL());
        zzbpw.zza(this.zzWL(), object);
        Object object2 = zzbtg.zzay(object);
        zzbtf.zzax(object2);
        final zzbsc zzbsc3 = zzbsd.zza(object2, zzbsc2);
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcad.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcad.zza(DatabaseReference.this.zzWL(), zzbsc3, (CompletionListener)zzbtb2.zzabI());
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzbsg.zzau(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzbsg.zzau(object), completionListener);
    }

    private Task<Void> zza(final zzbsc zzbsc2, CompletionListener completionListener) {
        zzbtf.zzQ(this.zzWL());
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcad.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcad.zza(DatabaseReference.this.zzWL().zza(zzbrq.zzaaH()), zzbsc2, (CompletionListener)zzbtb2.zzabI());
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> map2 = zzbtg.zzaG(map);
        Map<zzbph, zzbsc> map3 = zzbtf.zzc(this.zzWL(), map2);
        final zzboy zzboy2 = zzboy.zzaC(map3);
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcad.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcad.zza(DatabaseReference.this.zzWL(), zzboy2, (CompletionListener)zzbtb2.zzabI(), (Map<String, Object>)map2);
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzbtf.zzQ(this.zzWL());
        return new OnDisconnect(this.zzcad, this.zzWL());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzbtf.zzQ(this.zzWL());
        this.zzcad.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcad.zza(DatabaseReference.this.zzWL(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzWF());
    }

    static void zza(zzbpb zzbpb2) {
        zzbpl.zzd(zzbpb2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzWF());
    }

    static void zzb(zzbpb zzbpb2) {
        zzbpl.zze(zzbpb2);
    }

    public FirebaseDatabase getDatabase() {
        return this.zzcad.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzcad.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzbph zzbph2 = this.zzWL().zzYT();
        if (zzbph2 != null) {
            return new DatabaseReference(this.zzcad, zzbph2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzcad, new zzbph(""));
    }

    public String getKey() {
        if (this.zzWL().isEmpty()) {
            return null;
        }
        return this.zzWL().zzYU().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzbpb zzWF() {
        if (zzbZQ == null) {
            zzbZQ = new zzbpb();
        }
        return zzbZQ;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

