/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzbox;
import com.google.android.gms.internal.zzbpc;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbpx;
import com.google.android.gms.internal.zzbqa;
import com.google.android.gms.internal.zzbrb;
import com.google.android.gms.internal.zzbrc;
import com.google.android.gms.internal.zzbrp;
import com.google.android.gms.internal.zzbrq;
import com.google.android.gms.internal.zzbru;
import com.google.android.gms.internal.zzbrv;
import com.google.android.gms.internal.zzbry;
import com.google.android.gms.internal.zzbsc;
import com.google.android.gms.internal.zzbse;
import com.google.android.gms.internal.zzbsf;
import com.google.android.gms.internal.zzbsg;
import com.google.android.gms.internal.zzbsi;
import com.google.android.gms.internal.zzbsj;
import com.google.android.gms.internal.zzbte;
import com.google.android.gms.internal.zzbtf;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzbpj zzbZZ;
    protected final zzbph zzcag;
    protected final zzbrb zzcak;
    private final boolean zzcal;

    Query(zzbpj zzbpj2, zzbph zzbph2, zzbrb zzbrb2, boolean bl) throws DatabaseException {
        this.zzbZZ = zzbpj2;
        this.zzcag = zzbph2;
        this.zzcak = zzbrb2;
        this.zzcal = bl;
        zzbte.zzb(zzbrb2.isValid(), "Validation of queries failed.");
    }

    Query(zzbpj zzbpj2, zzbph zzbph2) {
        this.zzbZZ = zzbpj2;
        this.zzcag = zzbph2;
        this.zzcak = zzbrb.zzcie;
        this.zzcal = false;
    }

    private void zza(zzbrb zzbrb2) {
        if (zzbrb2.zzaaj().equals(zzbry.zzabg())) {
            zzbrq zzbrq2;
            zzbsc zzbsc2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzbrb2.zzaab()) {
                zzbsc2 = zzbrb2.zzaac();
                zzbrq2 = zzbrb2.zzaad();
                if (zzbrq2 != zzbrq.zzaaG() || !(zzbsc2 instanceof zzbsi)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzbrb2.zzaae()) {
                zzbsc2 = zzbrb2.zzaaf();
                zzbrq2 = zzbrb2.zzaag();
                if (zzbrq2 != zzbrq.zzaaH() || !(zzbsc2 instanceof zzbsi)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzbrb2.zzaaj().equals(zzbsf.zzabk()) && (zzbrb2.zzaab() && !zzbsg.zzq(zzbrb2.zzaac()) || zzbrb2.zzaae() && !zzbsg.zzq(zzbrb2.zzaaf()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzbrb zzbrb2) {
        if (zzbrb2.zzaab() && zzbrb2.zzaae() && zzbrb2.zzaah() && !zzbrb2.zzaai()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzWK() {
        if (this.zzcak.zzaab()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzcak.zzaae()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzWL() {
        if (this.zzcal) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzbpx(this.zzbZZ, valueEventListener, this.zzWN()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzbox(this.zzbZZ, childEventListener, this.zzWN()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzbpx(this.zzbZZ, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzWN()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzbpx(this.zzbZZ, valueEventListener, this.zzWN()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzbox(this.zzbZZ, childEventListener, this.zzWN()));
    }

    private void zza(final zzbpc zzbpc2) {
        zzbqa.zzZu().zzk(zzbpc2);
        this.zzbZZ.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbZZ.zze(zzbpc2);
            }
        });
    }

    private void zzb(final zzbpc zzbpc2) {
        zzbqa.zzZu().zzi(zzbpc2);
        this.zzbZZ.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbZZ.zzf(zzbpc2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.zzcag.isEmpty() && this.zzcag.zzYS().equals(zzbrq.zzaaJ())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzbZZ.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.zzbZZ.zza(Query.this.zzWN(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzbsc zzbsc2 = string != null ? new zzbsi(string, zzbsg.zzabl()) : zzbrv.zzaaZ();
        return this.zza(zzbsc2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzbru(d, zzbsg.zzabl()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzbrp(bl, zzbsg.zzabl()), string);
    }

    private Query zza(zzbsc zzbsc2, String string) {
        zzbtf.zzjp(string);
        if (!zzbsc2.zzaaN() && !zzbsc2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzcak.zzaab()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzbrq zzbrq2 = string != null ? zzbrq.zzja(string) : null;
        zzbrb zzbrb2 = this.zzcak.zza(zzbsc2, zzbrq2);
        this.zzb(zzbrb2);
        this.zza(zzbrb2);
        assert (zzbrb2.isValid());
        return new Query(this.zzbZZ, this.zzcag, zzbrb2, this.zzcal);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzbsc zzbsc2 = string != null ? new zzbsi(string, zzbsg.zzabl()) : zzbrv.zzaaZ();
        return this.zzb(zzbsc2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzbru(d, zzbsg.zzabl()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzbrp(bl, zzbsg.zzabl()), string);
    }

    private Query zzb(zzbsc zzbsc2, String string) {
        zzbrq zzbrq2;
        zzbtf.zzjp(string);
        if (!zzbsc2.zzaaN() && !zzbsc2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzbrq zzbrq3 = zzbrq2 = string != null ? zzbrq.zzja(string) : null;
        if (this.zzcak.zzaae()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzbrb zzbrb2 = this.zzcak.zzb(zzbsc2, zzbrq2);
        this.zzb(zzbrb2);
        this.zza(zzbrb2);
        assert (zzbrb2.isValid());
        return new Query(this.zzbZZ, this.zzcag, zzbrb2, this.zzcal);
    }

    public Query equalTo(String string) {
        this.zzWK();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzWK();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzWK();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzWK();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzWK();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzWK();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzcak.zzaah()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbZZ, this.zzcag, this.zzcak.zzqB(n), this.zzcal);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzcak.zzaah()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbZZ, this.zzcag, this.zzcak.zzqC(n), this.zzcal);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzbtf.zzjl(string);
        this.zzWL();
        zzbph zzbph2 = new zzbph(string);
        if (zzbph2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzbse zzbse2 = new zzbse(zzbph2);
        return new Query(this.zzbZZ, this.zzcag, this.zzcak.zza(zzbse2), true);
    }

    public Query orderByPriority() {
        this.zzWL();
        zzbrb zzbrb2 = this.zzcak.zza(zzbsf.zzabk());
        this.zza(zzbrb2);
        return new Query(this.zzbZZ, this.zzcag, zzbrb2, true);
    }

    public Query orderByKey() {
        this.zzWL();
        zzbrb zzbrb2 = this.zzcak.zza(zzbry.zzabg());
        this.zza(zzbrb2);
        return new Query(this.zzbZZ, this.zzcag, zzbrb2, true);
    }

    public Query orderByValue() {
        this.zzWL();
        return new Query(this.zzbZZ, this.zzcag, this.zzcak.zza(zzbsj.zzabm()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzbZZ, this.zzWM());
    }

    public zzbph zzWM() {
        return this.zzcag;
    }

    public zzbrc zzWN() {
        return new zzbrc(this.zzcag, this.zzcak);
    }
}

