/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzbny;
import com.google.android.gms.internal.zzbod;
import com.google.android.gms.internal.zzbog;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzbnx<K, V>
extends zzbny<K, V> {
    private final K[] zzcaO;
    private final V[] zzcaP;
    private final Comparator<K> zzcaQ;

    public static <A, B, C> zzbnx<A, C> zza(List<A> list, Map<B, C> map, zzbny.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzal(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzbnx<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzbnx<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzbnx.zza(new ArrayList<K>(map.keySet()), map, zzbny.zza.zzWY(), comparator);
    }

    public zzbnx(Comparator<K> comparator) {
        this.zzcaO = new Object[0];
        this.zzcaP = new Object[0];
        this.zzcaQ = comparator;
    }

    private zzbnx(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzcaO = KArray;
        this.zzcaP = VArray;
        this.zzcaQ = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzak(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzak(k);
        return n != -1 ? (V)this.zzcaP[n] : null;
    }

    @Override
    public zzbny<K, V> zzah(K k) {
        int n = this.zzak(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzbnx.zza(this.zzcaO, n);
        V[] VArray = zzbnx.zza(this.zzcaP, n);
        return new zzbnx<K, V>(this.zzcaQ, KArray, VArray);
    }

    @Override
    public zzbny<K, V> zzi(K k, V v) {
        int n = this.zzak(k);
        if (n != -1) {
            if (this.zzcaO[n] == k && this.zzcaP[n] == v) {
                return this;
            }
            K[] KArray = zzbnx.zzb(this.zzcaO, n, k);
            V[] VArray = zzbnx.zzb(this.zzcaP, n, v);
            return new zzbnx<K, V>(this.zzcaQ, KArray, VArray);
        }
        if (this.zzcaO.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzcaO.length + 1);
            for (int i = 0; i < this.zzcaO.length; ++i) {
                hashMap.put(this.zzcaO[i], this.zzcaP[i]);
            }
            hashMap.put(k, v);
            return zzbog.zzc(hashMap, this.zzcaQ);
        }
        int n2 = this.zzaj(k);
        K[] KArray = zzbnx.zza(this.zzcaO, n2, k);
        V[] VArray = zzbnx.zza(this.zzcaP, n2, v);
        return new zzbnx<K, V>(this.zzcaQ, KArray, VArray);
    }

    @Override
    public K zzWV() {
        return this.zzcaO.length > 0 ? (K)this.zzcaO[0] : null;
    }

    @Override
    public K zzWW() {
        return this.zzcaO.length > 0 ? (K)this.zzcaO[this.zzcaO.length - 1] : null;
    }

    @Override
    public int size() {
        return this.zzcaO.length;
    }

    @Override
    public boolean isEmpty() {
        return this.zzcaO.length == 0;
    }

    @Override
    public void zza(zzbod.zzb<K, V> zzb2) {
        for (int i = 0; i < this.zzcaO.length; ++i) {
            zzb2.zzj(this.zzcaO[i], this.zzcaP[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zze(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int zzcaR;
            {
                this.zzcaR = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.zzcaR >= 0 : this.zzcaR < zzbnx.this.zzcaO.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzbnx.this.zzcaO[this.zzcaR];
                Object object2 = zzbnx.this.zzcaP[this.zzcaR];
                this.zzcaR = bl ? this.zzcaR - 1 : this.zzcaR + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zze(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzWX() {
        return this.zze(this.zzcaO.length - 1, true);
    }

    @Override
    public K zzai(K k) {
        int n = this.zzak(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.zzcaO[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.zzcaQ;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzaj(K k) {
        int n;
        for (n = 0; n < this.zzcaO.length && this.zzcaQ.compare(this.zzcaO[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzak(K k) {
        int n = 0;
        for (K k2 : this.zzcaO) {
            if (this.zzcaQ.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

