/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.firebase.database.DatabaseException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class DatabaseError {
    public static final int DATA_STALE = -1;
    public static final int OPERATION_FAILED = -2;
    public static final int PERMISSION_DENIED = -3;
    public static final int DISCONNECTED = -4;
    public static final int EXPIRED_TOKEN = -6;
    public static final int INVALID_TOKEN = -7;
    public static final int MAX_RETRIES = -8;
    public static final int OVERRIDDEN_BY_SET = -9;
    public static final int UNAVAILABLE = -10;
    public static final int USER_CODE_EXCEPTION = -11;
    public static final int NETWORK_ERROR = -24;
    public static final int WRITE_CANCELED = -25;
    public static final int UNKNOWN_ERROR = -999;
    private static final Map<Integer, String> zzbZL = new HashMap<Integer, String>();
    private static final Map<String, Integer> zzbZM;
    private final int code;
    private final String message;
    private final String zzbZN;

    public static DatabaseError zziD(String string) {
        return DatabaseError.zzap(string, null);
    }

    public static DatabaseError zzap(String string, String string2) {
        return DatabaseError.zzs(string, string2, null);
    }

    public static DatabaseError zzqv(int n) {
        if (!zzbZL.containsKey(n)) {
            throw new IllegalArgumentException(new StringBuilder(49).append("Invalid Firebase Database error code: ").append(n).toString());
        }
        String string = zzbZL.get(n);
        return new DatabaseError(n, string, null);
    }

    public static DatabaseError zzs(String string, String string2, String string3) {
        Integer n = zzbZM.get(string.toLowerCase());
        if (n == null) {
            n = -999;
        }
        String string4 = string2 == null ? zzbZL.get(n) : string2;
        return new DatabaseError(n, string4, string3);
    }

    public static DatabaseError fromException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = String.valueOf(zzbZL.get(-11));
        String string2 = String.valueOf(stringWriter.toString());
        String string3 = string2.length() != 0 ? string.concat(string2) : new String(string);
        return new DatabaseError(-11, string3);
    }

    private DatabaseError(int n, String string) {
        this(n, string, null);
    }

    private DatabaseError(int n, String string, String string2) {
        this.code = n;
        this.message = string;
        this.zzbZN = string2 == null ? "" : string2;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.zzbZN;
    }

    public String toString() {
        String string = String.valueOf(this.message);
        return string.length() != 0 ? "DatabaseError: ".concat(string) : new String("DatabaseError: ");
    }

    public DatabaseException toException() {
        String string = String.valueOf(this.message);
        return new DatabaseException(string.length() != 0 ? "Firebase Database error: ".concat(string) : new String("Firebase Database error: "));
    }

    static {
        zzbZL.put(-1, "The transaction needs to be run again with current data");
        zzbZL.put(-2, "The server indicated that this operation failed");
        zzbZL.put(-3, "This client does not have permission to perform this operation");
        zzbZL.put(-4, "The operation had to be aborted due to a network disconnect");
        zzbZL.put(-6, "The supplied auth token has expired");
        zzbZL.put(-7, "The supplied auth token was invalid");
        zzbZL.put(-8, "The transaction had too many retries");
        zzbZL.put(-9, "The transaction was overridden by a subsequent set");
        zzbZL.put(-10, "The service is unavailable");
        zzbZL.put(-11, "User code called from the Firebase Database runloop threw an exception:\n");
        zzbZL.put(-24, "The operation could not be performed due to a network error");
        zzbZL.put(-25, "The write was canceled by the user.");
        zzbZL.put(-999, "An unknown error occurred");
        zzbZM = new HashMap<String, Integer>();
        zzbZM.put("datastale", -1);
        zzbZM.put("failure", -2);
        zzbZM.put("permission_denied", -3);
        zzbZM.put("disconnected", -4);
        zzbZM.put("expired_token", -6);
        zzbZM.put("invalid_token", -7);
        zzbZM.put("maxretries", -8);
        zzbZM.put("overriddenbyset", -9);
        zzbZM.put("unavailable", -10);
        zzbZM.put("network_error", -24);
        zzbZM.put("write_canceled", -25);
    }
}

