/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzboy;
import com.google.android.gms.internal.zzbpb;
import com.google.android.gms.internal.zzbph;
import com.google.android.gms.internal.zzbpj;
import com.google.android.gms.internal.zzbpl;
import com.google.android.gms.internal.zzbpw;
import com.google.android.gms.internal.zzbrq;
import com.google.android.gms.internal.zzbsc;
import com.google.android.gms.internal.zzbsd;
import com.google.android.gms.internal.zzbsg;
import com.google.android.gms.internal.zzbtb;
import com.google.android.gms.internal.zzbtd;
import com.google.android.gms.internal.zzbte;
import com.google.android.gms.internal.zzbtf;
import com.google.android.gms.internal.zzbtg;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzbpb zzbZO;

    DatabaseReference(zzbpj zzbpj2, zzbph zzbph2) {
        super(zzbpj2, zzbph2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzWO().isEmpty()) {
            zzbtf.zzjm(string);
        } else {
            zzbtf.zzjl(string);
        }
        zzbph zzbph2 = this.zzWO().zzh(new zzbph(string));
        return new DatabaseReference(this.zzcab, zzbph2);
    }

    public DatabaseReference push() {
        String string = zzbtd.zzaU(this.zzcab.zzZb());
        zzbrq zzbrq2 = zzbrq.zzja(string);
        return new DatabaseReference(this.zzcab, this.zzWO().zza(zzbrq2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzbsg.zzav(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzbsg.zzav(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzbsg.zzav(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzbsg.zzav(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzbsc zzbsc2, CompletionListener completionListener) {
        zzbtf.zzQ(this.zzWO());
        zzbpw.zza(this.zzWO(), object);
        Object object2 = zzbtg.zzaz(object);
        zzbtf.zzay(object2);
        final zzbsc zzbsc3 = zzbsd.zza(object2, zzbsc2);
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcab.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcab.zza(DatabaseReference.this.zzWO(), zzbsc3, (CompletionListener)zzbtb2.zzabL());
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzbsg.zzav(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzbsg.zzav(object), completionListener);
    }

    private Task<Void> zza(final zzbsc zzbsc2, CompletionListener completionListener) {
        zzbtf.zzQ(this.zzWO());
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcab.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcab.zza(DatabaseReference.this.zzWO().zza(zzbrq.zzaaK()), zzbsc2, (CompletionListener)zzbtb2.zzabL());
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> map2 = zzbtg.zzaG(map);
        Map<zzbph, zzbsc> map3 = zzbtf.zzc(this.zzWO(), map2);
        final zzboy zzboy2 = zzboy.zzaC(map3);
        final zzbtb<Task<Void>, CompletionListener> zzbtb2 = zzbte.zzb(completionListener);
        this.zzcab.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcab.zza(DatabaseReference.this.zzWO(), zzboy2, (CompletionListener)zzbtb2.zzabL(), (Map<String, Object>)map2);
            }
        });
        return zzbtb2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzbtf.zzQ(this.zzWO());
        return new OnDisconnect(this.zzcab, this.zzWO());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzbtf.zzQ(this.zzWO());
        this.zzcab.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzcab.zza(DatabaseReference.this.zzWO(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzWI());
    }

    static void zza(zzbpb zzbpb2) {
        zzbpl.zzd(zzbpb2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzWI());
    }

    static void zzb(zzbpb zzbpb2) {
        zzbpl.zze(zzbpb2);
    }

    public FirebaseDatabase getDatabase() {
        return this.zzcab.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzcab.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzbph zzbph2 = this.zzWO().zzYW();
        if (zzbph2 != null) {
            return new DatabaseReference(this.zzcab, zzbph2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzcab, new zzbph(""));
    }

    public String getKey() {
        if (this.zzWO().isEmpty()) {
            return null;
        }
        return this.zzWO().zzYX().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzbpb zzWI() {
        if (zzbZO == null) {
            zzbZO = new zzbpb();
        }
        return zzbZO;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

