/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.px;
import com.google.android.gms.internal.qi;
import com.google.android.gms.internal.qr;
import com.google.android.gms.internal.qu;
import com.google.android.gms.internal.to;
import com.google.android.gms.internal.tt;
import com.google.android.gms.internal.vq;
import com.google.android.gms.internal.vt;
import com.google.android.gms.internal.wo;
import com.google.android.gms.internal.wp;
import com.google.android.gms.internal.xc;
import com.google.android.gms.internal.xd;
import com.google.android.gms.internal.xg;
import com.google.android.gms.internal.xm;
import com.google.android.gms.internal.xq;
import com.google.android.gms.internal.xr;
import com.google.android.gms.internal.xs;
import com.google.android.gms.internal.xu;
import com.google.android.gms.internal.xw;
import com.google.android.gms.internal.zd;
import com.google.android.gms.internal.zf;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;
import com.google.firebase.database.zzp;
import com.google.firebase.database.zzq;
import com.google.firebase.database.zzr;
import com.google.firebase.database.zzs;

public class Query {
    protected final qu zzbYY;
    protected final qr zzbZf;
    private vq zzbZj;
    private final boolean zzbZk;

    private Query(qu qu2, qr qr2, vq vq2, boolean bl) throws DatabaseException {
        this.zzbYY = qu2;
        this.zzbZf = qr2;
        this.zzbZj = vq2;
        this.zzbZk = bl;
        vq vq3 = vq2;
        zd.zzb(!vq3.zzIe() || !vq3.zzIh() || !vq3.zzIk() || vq3.zzIl(), "Validation of queries failed.");
    }

    Query(qu qu2, qr qr2) {
        this.zzbYY = qu2;
        this.zzbZf = qr2;
        this.zzbZj = vq.zzcgZ;
        this.zzbZk = false;
    }

    private static void zza(vq vq2) {
        if (vq2.zzIm().equals(xg.zzJh())) {
            xm xm2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (vq2.zzIe()) {
                xm2 = vq2.zzIf();
                if (vq2.zzIg() != wp.zzIJ() || !(xm2 instanceof xu)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (vq2.zzIh()) {
                xm2 = vq2.zzIi();
                if (vq2.zzIj() != wp.zzIK() || !(xm2 instanceof xu)) {
                    throw new IllegalArgumentException(string);
                }
            }
            return;
        }
        if (vq2.zzIm().equals(xr.zzJl()) && (vq2.zzIe() && !xs.zzl(vq2.zzIf()) || vq2.zzIh() && !xs.zzl(vq2.zzIi()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private static void zzb(vq vq2) {
        if (vq2.zzIe() && vq2.zzIh() && vq2.zzIk() && !vq2.zzIl()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private final void zzFo() {
        if (this.zzbZj.zzIe()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.zzbZj.zzIh()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private final void zzFp() {
        if (this.zzbZk) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new to(this.zzbYY, valueEventListener, this.zzFr()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new px(this.zzbYY, childEventListener, this.zzFr()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(ValueEventListener valueEventListener) {
        this.zzb(new to(this.zzbYY, new zzp(this, valueEventListener), this.zzFr()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new to(this.zzbYY, valueEventListener, this.zzFr()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new px(this.zzbYY, childEventListener, this.zzFr()));
    }

    private final void zza(qi qi2) {
        tt.zzHA().zzj(qi2);
        this.zzbYY.zzq(new zzq(this, qi2));
    }

    private final void zzb(qi qi2) {
        tt.zzHA().zzi(qi2);
        this.zzbYY.zzq(new zzr(this, qi2));
    }

    public void keepSynced(boolean bl) {
        if (!this.zzbZf.isEmpty() && this.zzbZf.zzHc().equals(wp.zzIM())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.zzbYY.zzq(new zzs(this, bl));
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        xm xm2 = string != null ? new xu(string, xd.zzJb()) : xd.zzJb();
        return this.zza(xm2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new xc(d, xd.zzJb()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new wo(bl, xd.zzJb()), string);
    }

    private final Query zza(xm xm2, String string) {
        zf.zzhd(string);
        if (!xm2.zzIQ() && !xm2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.zzbZj.zzIe()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        wp wp2 = string != null ? wp.zzgT(string) : null;
        vq vq2 = this.zzbZj.zza(xm2, wp2);
        Query.zzb(vq2);
        Query.zza(vq2);
        return new Query(this.zzbYY, this.zzbZf, vq2, this.zzbZk);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        xm xm2 = string != null ? new xu(string, xd.zzJb()) : xd.zzJb();
        return this.zzb(xm2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new xc(d, xd.zzJb()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new wo(bl, xd.zzJb()), string);
    }

    private final Query zzb(xm xm2, String string) {
        wp wp2;
        zf.zzhd(string);
        if (!xm2.zzIQ() && !xm2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        wp wp3 = wp2 = string != null ? wp.zzgT(string) : null;
        if (this.zzbZj.zzIh()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        vq vq2 = this.zzbZj.zzb(xm2, wp2);
        Query.zzb(vq2);
        Query.zza(vq2);
        return new Query(this.zzbYY, this.zzbZf, vq2, this.zzbZk);
    }

    public Query equalTo(String string) {
        this.zzFo();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzFo();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzFo();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzFo();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzFo();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzFo();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbZj.zzIk()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbYY, this.zzbZf, this.zzbZj.zzbW(n), this.zzbZk);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.zzbZj.zzIk()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.zzbYY, this.zzbZf, this.zzbZj.zzbX(n), this.zzbZk);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zf.zzhb(string);
        this.zzFp();
        qr qr2 = new qr(string);
        if (qr2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        xq xq2 = new xq(qr2);
        return new Query(this.zzbYY, this.zzbZf, this.zzbZj.zza(xq2), true);
    }

    public Query orderByPriority() {
        this.zzFp();
        vq vq2 = this.zzbZj.zza(xr.zzJl());
        Query.zza(vq2);
        return new Query(this.zzbYY, this.zzbZf, vq2, true);
    }

    public Query orderByKey() {
        this.zzFp();
        vq vq2 = this.zzbZj.zza(xg.zzJh());
        Query.zza(vq2);
        return new Query(this.zzbYY, this.zzbZf, vq2, true);
    }

    public Query orderByValue() {
        this.zzFp();
        return new Query(this.zzbYY, this.zzbZf, this.zzbZj.zza(xw.zzJm()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.zzbYY, this.zzbZf);
    }

    public final qr zzFq() {
        return this.zzbZf;
    }

    public final vt zzFr() {
        return new vt(this.zzbZf, this.zzbZj);
    }
}

