/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdnl;
import com.google.android.gms.internal.zzdnm;
import com.google.android.gms.internal.zzdnp;
import com.google.android.gms.internal.zzdnx;
import com.google.android.gms.internal.zzdoa;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzdnk<K, V>
extends zzdnm<K, V> {
    private final K[] zzlnm;
    private final V[] zzlnn;
    private final Comparator<K> zzlno;

    public static <A, B, C> zzdnk<A, C> zza(List<A> list, Map<B, C> map, zzdnp<A, B> zzdnp2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zzdnp2.zzbb(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzdnk<Object, Object>(comparator, objectArray, objectArray2);
    }

    public zzdnk(Comparator<K> comparator) {
        this.zzlnm = new Object[0];
        this.zzlnn = new Object[0];
        this.zzlno = comparator;
    }

    private zzdnk(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzlnm = KArray;
        this.zzlnn = VArray;
        this.zzlno = comparator;
    }

    @Override
    public final boolean containsKey(K k) {
        return this.zzba(k) != -1;
    }

    @Override
    public final V get(K k) {
        int n = this.zzba(k);
        if (n != -1) {
            return this.zzlnn[n];
        }
        return null;
    }

    @Override
    public final zzdnm<K, V> zzax(K k) {
        int n = this.zzba(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzdnk.zza(this.zzlnm, n);
        V[] VArray = zzdnk.zza(this.zzlnn, n);
        return new zzdnk<K, V>(this.zzlno, KArray, VArray);
    }

    @Override
    public final zzdnm<K, V> zzg(K k, V v) {
        int n = this.zzba(k);
        if (n != -1) {
            if (this.zzlnm[n] == k && this.zzlnn[n] == v) {
                return this;
            }
            K[] KArray = zzdnk.zzb(this.zzlnm, n, k);
            V[] VArray = zzdnk.zzb(this.zzlnn, n, v);
            return new zzdnk<K, V>(this.zzlno, KArray, VArray);
        }
        if (this.zzlnm.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzlnm.length + 1);
            for (int i = 0; i < this.zzlnm.length; ++i) {
                hashMap.put(this.zzlnm[i], this.zzlnn[i]);
            }
            hashMap.put(k, v);
            return zzdoa.zzb(hashMap, this.zzlno);
        }
        int n2 = this.zzaz(k);
        K[] KArray = zzdnk.zza(this.zzlnm, n2, k);
        V[] VArray = zzdnk.zza(this.zzlnn, n2, v);
        return new zzdnk<K, V>(this.zzlno, KArray, VArray);
    }

    @Override
    public final K zzbpr() {
        if (this.zzlnm.length > 0) {
            return this.zzlnm[0];
        }
        return null;
    }

    @Override
    public final K zzbps() {
        if (this.zzlnm.length > 0) {
            return this.zzlnm[this.zzlnm.length - 1];
        }
        return null;
    }

    @Override
    public final int size() {
        return this.zzlnm.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.zzlnm.length == 0;
    }

    @Override
    public final void zza(zzdnx<K, V> zzdnx2) {
        for (int i = 0; i < this.zzlnm.length; ++i) {
            zzdnx2.zzh(this.zzlnm[i], this.zzlnn[i]);
        }
    }

    private final Iterator<Map.Entry<K, V>> zzj(int n, boolean bl) {
        return new zzdnl(this, n, bl);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> iterator() {
        return this.zzj(0, false);
    }

    @Override
    public final Iterator<Map.Entry<K, V>> zzbpt() {
        return this.zzj(this.zzlnm.length - 1, true);
    }

    @Override
    public final K zzay(K k) {
        int n = this.zzba(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        if (n > 0) {
            return this.zzlnm[n - 1];
        }
        return null;
    }

    @Override
    public final Comparator<K> getComparator() {
        return this.zzlno;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private final int zzaz(K k) {
        int n;
        for (n = 0; n < this.zzlnm.length && this.zzlno.compare(this.zzlnm[n], k) < 0; ++n) {
        }
        return n;
    }

    private final int zzba(K k) {
        int n = 0;
        K[] KArray = this.zzlnm;
        int n2 = this.zzlnm.length;
        for (int i = 0; i < n2; ++i) {
            K k2 = KArray[i];
            if (this.zzlno.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static /* synthetic */ Object[] zza(zzdnk zzdnk2) {
        return zzdnk2.zzlnm;
    }

    static /* synthetic */ Object[] zzb(zzdnk zzdnk2) {
        return zzdnk2.zzlnn;
    }
}

