/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzdyl;
import com.google.android.gms.internal.zzdym;
import com.google.android.gms.internal.zzdyn;
import com.google.android.gms.internal.zzebi;
import com.google.android.gms.internal.zzebm;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzeev;
import com.google.android.gms.internal.zzefr;
import com.google.android.gms.internal.zzefs;
import com.google.android.gms.internal.zzefw;
import com.google.android.gms.internal.zzege;
import com.google.android.gms.internal.zzegz;
import com.google.android.gms.internal.zzehc;
import com.google.android.gms.internal.zzehu;
import com.google.android.gms.internal.zzehy;
import com.google.android.gms.internal.zzeia;
import com.google.android.gms.internal.zzeim;
import com.google.android.gms.internal.zzeiu;
import com.google.android.gms.internal.zzeiv;
import com.google.android.gms.internal.zzeiy;
import com.google.android.gms.internal.zzeka;
import com.google.android.gms.internal.zzekh;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzekm;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzdyk
implements zzefr {
    private static final Charset zzffb = Charset.forName("UTF-8");
    private final SQLiteDatabase zzmhc;
    private final zzehu zzmhd;
    private boolean zzmhe;
    private long zzmhf = 0L;

    public zzdyk(Context context, zzebm zzebm2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzmhd = zzebm2.zzpg("Persistence");
        this.zzmhc = zzdyk.zzal(context, string2);
    }

    @Override
    public final void zza(zzeca zzeca2, zzeiv zzeiv2, long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdyk.zzbd(zzeiv2.getValue(true));
        this.zza(zzeca2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzeca zzeca2, zzebi zzebi2, long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzdyk.zzbd(zzebi2.zzck(true));
        this.zza(zzeca2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbk(long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        int n = this.zzmhc.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzeev> zzbrd() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzeev> arrayList = new ArrayList<zzeev>();
        try (Cursor cursor = this.zzmhc.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzeev> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzeev zzeev2;
                Iterable<zzeiu> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzeca(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzdyk.zzaq(arrayList3);
                }
                Object object = zzeka.zzpn((String)new String(byArray, zzffb));
                if ("o".equals(string)) {
                    iterable = zzeiy.zza(object, zzeim.zzbyj());
                    zzeev2 = new zzeev(l2, (zzeca)((Object)arrayList2), (zzeiv)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzebi.zzaj((Map)object);
                    zzeev2 = new zzeev(l2, (zzeca)((Object)arrayList2), (zzebi)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzeev2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmhd.zzbxp()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzmhd.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzeca zzeca2, long l, String string, byte[] byArray) {
        this.zzbrh();
        this.zzmhc.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzdyk.zzf(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzdyk.zzc(zzeca2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzmhc.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzdyk.zzc(zzeca2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzmhc.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzeiv zza(zzeca zzeca2) {
        return this.zzb(zzeca2);
    }

    @Override
    public final void zza(zzeca zzeca2, zzeiv zzeiv2) {
        this.zzbrh();
        this.zza(zzeca2, zzeiv2, false);
    }

    @Override
    public final void zzb(zzeca zzeca2, zzeiv zzeiv2) {
        this.zzbrh();
        this.zza(zzeca2, zzeiv2, true);
    }

    private final void zza(zzeca zzeca2, zzeiv zzeiv2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzeca2);
            n = this.zzc(zzeca2, zzeiv2);
        } else {
            n2 = 0;
            n = 0;
            for (zzeiu zzeiu2 : zzeiv2) {
                n2 += this.zza("serverCache", zzeca2.zza(zzeiu2.zzbys()));
                n += this.zzc(zzeca2.zza(zzeiu2.zzbys()), zzeiu2.zzbqy());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzeca2.toString(), l2);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzeca zzeca2, zzebi zzebi2) {
        this.zzbrh();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzeca, zzeiv> entry : zzebi2) {
            n2 += this.zza("serverCache", zzeca2.zzh(entry.getKey()));
            n += this.zzc(zzeca2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzeca2.toString(), l2);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbre() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzmhc.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzefw zzefw2) {
        this.zzbrh();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzefw2.id));
        contentValues.put("path", zzdyk.zzc(zzefw2.zzmuh.zzbrb()));
        contentValues.put("queryParams", zzefw2.zzmuh.zzbxc().zzbxa());
        contentValues.put("lastUse", Long.valueOf(zzefw2.zzmui));
        contentValues.put("complete", Boolean.valueOf(zzefw2.complete));
        contentValues.put("active", Boolean.valueOf(zzefw2.zzivx));
        this.zzmhc.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbrh();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmhc.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzmhc.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzefw> zzbrf() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzefw> arrayList = new ArrayList<zzefw>();
        try (Cursor cursor = this.zzmhc.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzefw> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzeca(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzeka.zzpm((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzefw> arrayList3 = arrayList2;
                objectArray = zzegz.zzal((Map<String, Object>)object);
                zzehc zzehc2 = new zzehc((zzeca)((Object)arrayList3), (zzegz)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzefw zzefw2 = new zzefw(l2, zzehc2, l3, bl, bl2);
                arrayList.add(zzefw2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmhd.zzbxp()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzmhd.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzmhc.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzmhd.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzehy> set) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmhc.delete("trackedKeys", string2, new String[]{string});
        for (zzehy zzehy2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzehy2.asString());
            this.zzmhc.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzmhd.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzehy> set, Set<zzehy> set2) {
        this.zzbrh();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzehy zzehy2 : set2) {
            this.zzmhc.delete("trackedKeys", string, new String[]{string2, zzehy2.asString()});
        }
        for (zzehy zzehy2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzehy2.asString());
            this.zzmhc.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzmhd.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzehy> zzbn(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzehy> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzdyk.zzr(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzmhc.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzehy.zzpk(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzmhd.zzbxp()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzmhd.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzeca zzeca2, zzefs zzefs2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzehy> iterable2;
        if (!zzefs2.zzbvw()) {
            return;
        }
        this.zzbrh();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzeca2, new String[]{"rowid", "path"});
        zzege<Object> zzege2 = new zzege<Object>(null);
        zzege<Object> zzege3 = new zzege<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzeca(cursor.getString(1));
            if (!zzeca2.zzi((zzeca)iterable2)) {
                iterable = String.valueOf(zzeca2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzmhd.zze(string2, null);
                continue;
            }
            iterable = zzeca.zza(zzeca2, (zzeca)iterable2);
            if (zzefs2.zzv((zzeca)iterable)) {
                zzege2 = zzege2.zzb((zzeca)iterable, l2);
                continue;
            }
            if (zzefs2.zzw((zzeca)iterable)) {
                zzege3 = zzege3.zzb((zzeca)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzeca2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzmhd.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzege2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzeca2, zzeca.zzbui(), zzege2, zzege3, zzefs2, (List<zzekj<zzeca, zzeiv>>)iterable2);
            iterable = zzege2.values();
            string = zzdyk.zzr(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzmhc.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzekj zzekj2 = (zzekj)e;
                this.zzc(zzeca2.zzh((zzeca)zzekj2.getFirst()), (zzeiv)zzekj2.zzbzl());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzmhd.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzeca zzeca2, zzeca zzeca3, zzege<Long> zzege2, zzege<Long> zzege3, zzefs zzefs2, List<zzekj<zzeca, zzeiv>> list) {
        if (zzege2.getValue() != null) {
            int n = zzefs2.zza(0, new zzdyl(this, zzege3));
            if (n > 0) {
                zzeca zzeca4 = zzeca2.zzh(zzeca3);
                if (this.zzmhd.zzbxp()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzeca4);
                    this.zzmhd.zzb(string, null, objectArray);
                }
                zzeiv zzeiv2 = this.zzb(zzeca4);
                zzefs2.zza(null, new zzdym(this, zzege3, list, zzeca3, zzeiv2));
            }
            return;
        }
        for (Map.Entry entry : zzege2.zzbwb()) {
            zzehy zzehy2 = (zzehy)entry.getKey();
            zzefs zzefs3 = zzefs2.zzd((zzehy)entry.getKey());
            this.zza(zzeca2, zzeca3.zza(zzehy2), (zzege)entry.getValue(), zzege3.zze(zzehy2), zzefs3, list);
        }
    }

    @Override
    public final void zzbrg() {
        this.zzbrh();
        long l = System.currentTimeMillis();
        int n = this.zzmhc.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzekm.zzb(!this.zzmhe, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzmhd.zzb("Starting transaction.", null, objectArray);
        }
        this.zzmhc.beginTransaction();
        this.zzmhe = true;
        this.zzmhf = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzmhc.endTransaction();
        this.zzmhe = false;
        long l = System.currentTimeMillis() - this.zzmhf;
        if (this.zzmhd.zzbxp()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzmhd.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzmhc.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzal(Context context, String string) {
        zzdyn zzdyn2 = new zzdyn(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzdyn2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbrh() {
        zzekm.zzb(this.zzmhe, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzeca zzeca2, zzeiv zzeiv2) {
        long l = zzekh.zzn(zzeiv2);
        if (zzeiv2 instanceof zzeia && l > 16384L) {
            if (this.zzmhd.zzbxp()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzeca2, l, 16384);
                this.zzmhd.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzeiu zzeiu2 : zzeiv2) {
                n += this.zzc(zzeca2.zza(zzeiu2.zzbys()), zzeiu2.zzbqy());
            }
            if (!zzeiv2.zzbxz().isEmpty()) {
                this.zzd(zzeca2.zza(zzehy.zzbxt()), zzeiv2.zzbxz());
                ++n;
            }
            this.zzd(zzeca2, zzeim.zzbyj());
            return ++n;
        }
        this.zzd(zzeca2, zzeiv2);
        return 1;
    }

    private static String zza(zzeca zzeca2, int n) {
        String string = String.valueOf(zzdyk.zzc(zzeca2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzeca zzeca2, zzeiv zzeiv2) {
        byte[] byArray = zzdyk.zzbd(zzeiv2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzdyk.zzf(byArray, 262144);
            if (this.zzmhd.zzbxp()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzmhd.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzdyk.zza(zzeca2, n));
                contentValues.put("value", list.get(n));
                this.zzmhc.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzdyk.zzc(zzeca2));
        contentValues.put("value", byArray);
        this.zzmhc.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzeiv zzb(zzeca zzeca2) {
        String string;
        Object[] objectArray;
        zzeca zzeca3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzeca2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzeiv zzeiv2 = zzeim.zzbyj();
        boolean bl = false;
        HashMap<zzeca, void> hashMap = new HashMap<zzeca, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzeca3 = new zzeca(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzdyk.zza(zzeca3, arrayList, i);
                if (this.zzmhd.zzbxp()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzmhd.zzb(string, null, objectArray);
                }
                zzeiv zzeiv3 = zzdyk.zzam(zzdyk.zzaq(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzeiv zzeiv4 = zzdyk.zzam((byte[])arrayList2.get(i));
                zzeca3 = new zzeca((String)arrayList.get(i));
            }
            if (zzeca3.zzbuo() != null && zzeca3.zzbuo().zzbxv()) {
                hashMap.put(zzeca3, object);
                continue;
            }
            if (zzeca3.zzi(zzeca2)) {
                zzekm.zzb(!bl, "Descendants of path must come after ancestors.");
                zzeiv2 = object.zzan(zzeca.zza(zzeca3, zzeca2));
                continue;
            }
            if (zzeca2.zzi(zzeca3)) {
                bl = true;
                object2 = zzeca.zza(zzeca2, zzeca3);
                zzeiv2 = zzeiv2.zzl((zzeca)object2, (zzeiv)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzeca3, zzeca2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzeca3 = (zzeca)entry.getKey();
            zzeiv2 = zzeiv2.zzl(zzeca.zza(zzeca2, zzeca3), (zzeiv)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzmhd.zzbxp()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzekh.zzo(zzeiv2), zzeca2, l7, l2, l4, l6);
            this.zzmhd.zzb(string, null, objectArray);
        }
        return zzeiv2;
    }

    private static int zza(zzeca zzeca2, List<String> list, int n) {
        int n2;
        String string = zzdyk.zzc(zzeca2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzdyk.zza(zzeca2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzeca zzeca2, String[] stringArray) {
        String[] stringArray2;
        String string = zzdyk.zzc(zzeca2);
        String string2 = zzdyk.zzot(string);
        String[] stringArray3 = stringArray2 = new String[zzeca2.size() + 3];
        zzeca zzeca3 = zzeca2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzeca3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzdyk.zzc(zzeca3);
            zzeca3 = zzeca3.zzbun();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzdyk.zzc(zzeca.zzbui());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzeca2.size() + 1] = string;
        stringArray2[zzeca2.size() + 2] = string2;
        String string6 = "path";
        return this.zzmhc.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzeca zzeca2) {
        if (zzeca2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzeca2.toString()).concat("/");
    }

    private static String zzot(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzeca zzeca2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzdyk.zzc(zzeca2);
        String string4 = zzdyk.zzot(string3);
        return this.zzmhc.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzf(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzaq(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzbd(Object object) {
        try {
            return zzeka.zzbs((Object)object).getBytes(zzffb);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzeiv zzam(byte[] byArray) {
        try {
            return zzeiy.zza(zzeka.zzpn((String)new String(byArray, zzffb)), zzeim.zzbyj());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzffb);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzr(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

