/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzebi;
import com.google.android.gms.internal.zzebp;
import com.google.android.gms.internal.zzeca;
import com.google.android.gms.internal.zzecd;
import com.google.android.gms.internal.zzedh;
import com.google.android.gms.internal.zzeew;
import com.google.android.gms.internal.zzehy;
import com.google.android.gms.internal.zzeiv;
import com.google.android.gms.internal.zzeiy;
import com.google.android.gms.internal.zzejb;
import com.google.android.gms.internal.zzekj;
import com.google.android.gms.internal.zzekl;
import com.google.android.gms.internal.zzekm;
import com.google.android.gms.internal.zzeko;
import com.google.android.gms.internal.zzekp;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import com.google.firebase.database.zzc;
import com.google.firebase.database.zzd;
import com.google.firebase.database.zze;
import com.google.firebase.database.zzf;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzebp zzmfk;

    DatabaseReference(zzecd zzecd2, zzeca zzeca2) {
        super(zzecd2, zzeca2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzmge.isEmpty()) {
            zzeko.zzpt(string);
        } else {
            zzeko.zzps(string);
        }
        zzeca zzeca2 = this.zzmge.zzh(new zzeca(string));
        return new DatabaseReference(this.zzmfx, zzeca2);
    }

    public DatabaseReference push() {
        zzehy zzehy2 = zzehy.zzpk(zzekl.zzby(this.zzmfx.zzbur()));
        return new DatabaseReference(this.zzmfx, this.zzmge.zza(zzehy2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzejb.zzc(this.zzmge, null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzejb.zzc(this.zzmge, object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzejb.zzc(this.zzmge, null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzejb.zzc(this.zzmge, object2), completionListener);
    }

    private final Task<Void> zza(Object object, zzeiv zzeiv2, CompletionListener completionListener) {
        zzeko.zzao(this.zzmge);
        zzeew.zza(this.zzmge, object);
        Object object2 = zzekp.zzbv(object);
        zzeko.zzbu(object2);
        zzeiv zzeiv3 = zzeiy.zza(object2, zzeiv2);
        zzekj<Task<Void>, CompletionListener> zzekj2 = zzekm.zzb(completionListener);
        this.zzmfx.zzo(new zzc(this, zzeiv3, zzekj2));
        return zzekj2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzejb.zzc(this.zzmge, object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzejb.zzc(this.zzmge, object), completionListener);
    }

    private final Task<Void> zza(zzeiv zzeiv2, CompletionListener completionListener) {
        zzeko.zzao(this.zzmge);
        zzekj<Task<Void>, CompletionListener> zzekj2 = zzekm.zzb(completionListener);
        this.zzmfx.zzo(new zzd(this, zzeiv2, zzekj2));
        return zzekj2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private final Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<String, Object> map2 = zzekp.zzam(map);
        zzebi zzebi2 = zzebi.zzak(zzeko.zzb(this.zzmge, map2));
        zzekj<Task<Void>, CompletionListener> zzekj2 = zzekm.zzb(completionListener);
        this.zzmfx.zzo(new zze(this, zzebi2, zzekj2, map2));
        return zzekj2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzeko.zzao(this.zzmge);
        return new OnDisconnect(this.zzmfx, this.zzmge);
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(Transaction.Handler handler, boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzeko.zzao(this.zzmge);
        this.zzmfx.zzo(new zzf(this, handler, bl));
    }

    public static void goOffline() {
        zzedh.zzd(DatabaseReference.zzbqw());
    }

    public static void goOnline() {
        zzedh.zze(DatabaseReference.zzbqw());
    }

    public FirebaseDatabase getDatabase() {
        return this.zzmfx.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzmfx.toString();
        }
        try {
            String string = databaseReference.toString();
            String string2 = URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20");
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzeca zzeca2 = this.zzmge.zzbun();
        if (zzeca2 != null) {
            return new DatabaseReference(this.zzmfx, zzeca2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzmfx, new zzeca(""));
    }

    public String getKey() {
        if (this.zzmge.isEmpty()) {
            return null;
        }
        return this.zzmge.zzbuo().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzebp zzbqw() {
        if (zzmfk == null) {
            zzmfk = new zzebp();
        }
        return zzmfk;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

