/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import com.google.android.gms.internal.zzeab;
import com.google.android.gms.internal.zzeac;
import com.google.android.gms.internal.zzead;
import com.google.android.gms.internal.zzecy;
import com.google.android.gms.internal.zzedc;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzegd;
import com.google.android.gms.internal.zzegz;
import com.google.android.gms.internal.zzeha;
import com.google.android.gms.internal.zzehe;
import com.google.android.gms.internal.zzehm;
import com.google.android.gms.internal.zzeih;
import com.google.android.gms.internal.zzeik;
import com.google.android.gms.internal.zzejc;
import com.google.android.gms.internal.zzejg;
import com.google.android.gms.internal.zzeji;
import com.google.android.gms.internal.zzeju;
import com.google.android.gms.internal.zzekc;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzekg;
import com.google.android.gms.internal.zzelh;
import com.google.android.gms.internal.zzelo;
import com.google.android.gms.internal.zzelq;
import com.google.android.gms.internal.zzelt;
import com.google.firebase.database.DatabaseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class zzeaa
implements zzegz {
    private static final Charset zzfhj = Charset.forName("UTF-8");
    private final SQLiteDatabase zzmlq;
    private final zzejc zzmlr;
    private boolean zzmls;
    private long zzmlt = 0L;

    public zzeaa(Context context, zzedc zzedc2, String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "utf-8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.zzmlr = zzedc2.zzpv("Persistence");
        this.zzmlq = zzeaa.zzal(context, string2);
    }

    @Override
    public final void zza(zzedk zzedk2, zzekd zzekd2, long l) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzeaa.zzbe(zzekd2.getValue(true));
        this.zza(zzedk2, l, "o", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user overwrite in %dms", l3);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzedk zzedk2, zzecy zzecy2, long l) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        byte[] byArray = zzeaa.zzbe(zzecy2.zzcn(true));
        this.zza(zzedk2, l, "m", byArray);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted user merge in %dms", l3);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbl(long l) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        int n = this.zzmlq.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d write(s) with writeId %d in %dms", n, l, l3);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final List<zzegd> zzbtb() {
        String[] stringArray = new String[]{"id", "path", "type", "part", "node"};
        long l = System.currentTimeMillis();
        ArrayList<zzegd> arrayList = new ArrayList<zzegd>();
        try (Cursor cursor = this.zzmlq.query("writes", stringArray, null, null, null, null, "id, part");){
            ArrayList<zzegd> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                zzegd zzegd2;
                Iterable<zzekc> iterable;
                byte[] byArray;
                l2 = cursor.getLong(0);
                arrayList2 = new zzedk(cursor.getString(1));
                String string = cursor.getString(2);
                if (cursor.isNull(3)) {
                    byArray = cursor.getBlob(4);
                } else {
                    ArrayList<byte[]> arrayList3 = new ArrayList<byte[]>();
                    do {
                        arrayList3.add(cursor.getBlob(4));
                    } while (cursor.moveToNext() && cursor.getLong(0) == l2);
                    cursor.moveToPrevious();
                    byArray = zzeaa.zzar(arrayList3);
                }
                Object object = zzelh.zzqc((String)new String(byArray, zzfhj));
                if ("o".equals(string)) {
                    iterable = zzekg.zza(object, zzeju.zzcaf());
                    zzegd2 = new zzegd(l2, (zzedk)((Object)arrayList2), (zzekd)iterable, true);
                } else if ("m".equals(string)) {
                    iterable = zzecy.zzak((Map)object);
                    zzegd2 = new zzegd(l2, (zzedk)((Object)arrayList2), (zzecy)iterable);
                } else {
                    String string2 = String.valueOf(string);
                    throw new IllegalStateException(string2.length() != 0 ? "Got invalid write type: ".concat(string2) : new String("Got invalid write type: "));
                }
                arrayList.add(zzegd2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmlr.zzbzl()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Loaded %d writes in %dms", arrayList.size(), l2);
                this.zzmlr.zzb(string, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private final void zza(zzedk zzedk2, long l, String string, byte[] byArray) {
        this.zzbtf();
        this.zzmlq.delete("writes", "id = ?", new String[]{String.valueOf(l)});
        if (byArray.length >= 262144) {
            List<byte[]> list = zzeaa.zzf(byArray, 262144);
            for (int i = 0; i < list.size(); ++i) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("id", Long.valueOf(l));
                contentValues.put("path", zzeaa.zzc(zzedk2));
                contentValues.put("type", string);
                contentValues.put("part", Integer.valueOf(i));
                contentValues.put("node", list.get(i));
                this.zzmlq.insertWithOnConflict("writes", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(l));
        contentValues.put("path", zzeaa.zzc(zzedk2));
        contentValues.put("type", string);
        contentValues.put("part", null);
        contentValues.put("node", byArray);
        this.zzmlq.insertWithOnConflict("writes", null, contentValues, 5);
    }

    @Override
    public final zzekd zza(zzedk zzedk2) {
        return this.zzb(zzedk2);
    }

    @Override
    public final void zza(zzedk zzedk2, zzekd zzekd2) {
        this.zzbtf();
        this.zza(zzedk2, zzekd2, false);
    }

    @Override
    public final void zzb(zzedk zzedk2, zzekd zzekd2) {
        this.zzbtf();
        this.zza(zzedk2, zzekd2, true);
    }

    private final void zza(zzedk zzedk2, zzekd zzekd2, boolean bl) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        if (!bl) {
            n2 = this.zza("serverCache", zzedk2);
            n = this.zzc(zzedk2, zzekd2);
        } else {
            n2 = 0;
            n = 0;
            for (zzekc zzekc2 : zzekd2) {
                n2 += this.zza("serverCache", zzedk2.zza(zzekc2.zzcao()));
                n += this.zzc(zzedk2.zza(zzekc2.zzcao()), zzekc2.zzbsv());
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a set at %s in %dms", n, n2, zzedk2.toString(), l2);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zza(zzedk zzedk2, zzecy zzecy2) {
        this.zzbtf();
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<zzedk, zzekd> entry : zzecy2) {
            n2 += this.zza("serverCache", zzedk2.zzh(entry.getKey()));
            n += this.zzc(zzedk2.zzh(entry.getKey()), entry.getValue());
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Persisted a total of %d rows and deleted %d rows for a merge at %s in %dms", n, n2, zzedk2.toString(), l2);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final long zzbtc() {
        String string = String.format("SELECT sum(length(%s) + length(%s)) FROM %s", "value", "path", "serverCache");
        try (Cursor cursor = this.zzmlq.rawQuery(string, null);){
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            throw new IllegalStateException("Couldn't read database result!");
        }
    }

    @Override
    public final void zza(zzehe zzehe2) {
        this.zzbtf();
        long l = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        contentValues.put("id", Long.valueOf(zzehe2.id));
        contentValues.put("path", zzeaa.zzc(zzehe2.zzmyn.zzbsy()));
        contentValues.put("queryParams", zzehe2.zzmyn.zzbyy().zzbyw());
        contentValues.put("lastUse", Long.valueOf(zzehe2.zzmyo));
        contentValues.put("complete", Boolean.valueOf(zzehe2.complete));
        contentValues.put("active", Boolean.valueOf(zzehe2.zziyi));
        this.zzmlq.insertWithOnConflict("trackedQueries", null, contentValues, 5);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Saved new tracked query in %dms", l2);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void zzbm(long l) {
        this.zzbtf();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmlq.delete("trackedQueries", string2, new String[]{string});
        String string3 = "id = ?";
        this.zzmlq.delete("trackedKeys", string3, new String[]{string});
    }

    @Override
    public final List<zzehe> zzbtd() {
        String[] stringArray = new String[]{"id", "path", "queryParams", "lastUse", "complete", "active"};
        long l = System.currentTimeMillis();
        ArrayList<zzehe> arrayList = new ArrayList<zzehe>();
        try (Cursor cursor = this.zzmlq.query("trackedQueries", stringArray, null, null, null, null, "id");){
            Object[] objectArray;
            Object object;
            ArrayList<zzehe> arrayList2;
            long l2;
            while (cursor.moveToNext()) {
                Map map;
                l2 = cursor.getLong(0);
                arrayList2 = new zzedk(cursor.getString(1));
                String string = cursor.getString(2);
                try {
                    map = zzelh.zzqb((String)string);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                object = map;
                ArrayList<zzehe> arrayList3 = arrayList2;
                objectArray = zzeih.zzam((Map<String, Object>)object);
                zzeik zzeik2 = new zzeik((zzedk)((Object)arrayList3), (zzeih)objectArray);
                long l3 = cursor.getLong(3);
                boolean bl = cursor.getInt(4) != 0;
                boolean bl2 = cursor.getInt(5) != 0;
                zzehe zzehe2 = new zzehe(l2, zzeik2, l3, bl, bl2);
                arrayList.add(zzehe2);
            }
            l2 = System.currentTimeMillis() - l;
            if (this.zzmlr.zzbzl()) {
                objectArray = new Object[]{};
                object = String.format("Loaded %d tracked queries in %dms", arrayList.size(), l2);
                this.zzmlr.zzb((String)object, null, objectArray);
            }
            arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @Override
    public final void zzbn(long l) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        String string = "active = 1";
        ContentValues contentValues = new ContentValues();
        contentValues.put("active", Boolean.valueOf(false));
        contentValues.put("lastUse", Long.valueOf(l));
        this.zzmlq.updateWithOnConflict("trackedQueries", contentValues, string, new String[0], 5);
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string2 = String.format("Reset active tracked queries in %dms", l3);
            this.zzmlr.zzb(string2, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzejg> set) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        String string = String.valueOf(l);
        String string2 = "id = ?";
        this.zzmlq.delete("trackedKeys", string2, new String[]{string});
        for (zzejg zzejg2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzejg2.asString());
            this.zzmlq.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Set %d tracked query keys for tracked query %d in %dms", set.size(), l, l3);
            this.zzmlr.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final void zza(long l, Set<zzejg> set, Set<zzejg> set2) {
        this.zzbtf();
        long l2 = System.currentTimeMillis();
        String string = "id = ? AND key = ?";
        String string2 = String.valueOf(l);
        for (zzejg zzejg2 : set2) {
            this.zzmlq.delete("trackedKeys", string, new String[]{string2, zzejg2.asString()});
        }
        for (zzejg zzejg2 : set) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("id", Long.valueOf(l));
            contentValues.put("key", zzejg2.asString());
            this.zzmlq.insertWithOnConflict("trackedKeys", null, contentValues, 5);
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string3 = String.format("Updated tracked query keys (%d added, %d removed) for tracked query id %d in %dms", set.size(), set2.size(), l, l3);
            this.zzmlr.zzb(string3, null, objectArray);
        }
    }

    @Override
    public final Set<zzejg> zzbo(long l) {
        return this.zze(Collections.singleton(l));
    }

    @Override
    public final Set<zzejg> zze(Set<Long> set) {
        String[] stringArray = new String[]{"key"};
        long l = System.currentTimeMillis();
        String string = "id IN (";
        Object object = zzeaa.zzr(set);
        String string2 = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(object).length()).append(string).append((String)object).append(")").toString();
        string = this.zzmlq.query(true, "trackedKeys", stringArray, string2, null, null, null, null, null);
        object = new HashSet();
        try {
            while (string.moveToNext()) {
                String string3 = string.getString(0);
                object.add(zzejg.zzpz(string3));
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.zzmlr.zzbzl()) {
                Object[] objectArray = new Object[]{};
                String string4 = String.format("Loaded %d tracked queries keys for tracked queries %s in %dms", object.size(), set.toString(), l2);
                this.zzmlr.zzb(string4, null, objectArray);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            string.close();
        }
    }

    @Override
    public final void zza(zzedk zzedk2, zzeha zzeha2) {
        String string;
        String string2;
        String string3;
        Iterable<Object> iterable;
        Iterable<zzejg> iterable2;
        if (!zzeha2.zzbxs()) {
            return;
        }
        this.zzbtf();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzedk2, new String[]{"rowid", "path"});
        zzehm<Object> zzehm2 = new zzehm<Object>(null);
        zzehm<Object> zzehm3 = new zzehm<Object>(null);
        while (cursor.moveToNext()) {
            long l2 = cursor.getLong(0);
            iterable2 = new zzedk(cursor.getString(1));
            if (!zzedk2.zzi((zzedk)iterable2)) {
                iterable = String.valueOf(zzedk2);
                string3 = String.valueOf(iterable2);
                string2 = new StringBuilder(67 + String.valueOf(iterable).length() + String.valueOf(string3).length()).append("We are pruning at ").append((String)((Object)iterable)).append(" but we have data stored higher up at ").append(string3).append(". Ignoring.").toString();
                this.zzmlr.zze(string2, null);
                continue;
            }
            iterable = zzedk.zza(zzedk2, (zzedk)iterable2);
            if (zzeha2.zzv((zzedk)iterable)) {
                zzehm2 = zzehm2.zzb((zzedk)iterable, l2);
                continue;
            }
            if (zzeha2.zzw((zzedk)iterable)) {
                zzehm3 = zzehm3.zzb((zzedk)iterable, l2);
                continue;
            }
            string3 = String.valueOf(zzedk2);
            string = String.valueOf(iterable2);
            string2 = new StringBuilder(88 + String.valueOf(string3).length() + String.valueOf(string).length()).append("We are pruning at ").append(string3).append(" and have data at ").append(string).append(" that isn't marked for pruning or keeping. Ignoring.").toString();
            this.zzmlr.zze(string2, null);
        }
        int n = 0;
        int n2 = 0;
        if (!zzehm2.isEmpty()) {
            iterable2 = new ArrayList();
            this.zza(zzedk2, zzedk.zzbwe(), zzehm2, zzehm3, zzeha2, (List<zzelq<zzedk, zzekd>>)iterable2);
            iterable = zzehm2.values();
            string = zzeaa.zzr(iterable);
            string3 = new StringBuilder(11 + String.valueOf(string).length()).append("rowid IN (").append(string).append(")").toString();
            this.zzmlq.delete("serverCache", string3, null);
            ArrayList arrayList = (ArrayList)iterable2;
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList.get(i);
                zzelq zzelq2 = (zzelq)e;
                this.zzc(zzedk2.zzh((zzedk)zzelq2.getFirst()), (zzekd)zzelq2.zzcbg());
            }
            n = iterable.size();
            n2 = iterable2.size();
        }
        long l3 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            string2 = String.format("Pruned %d rows with %d nodes resaved in %dms", n, n2, l3);
            this.zzmlr.zzb(string2, null, objectArray);
        }
    }

    private final void zza(zzedk zzedk2, zzedk zzedk3, zzehm<Long> zzehm2, zzehm<Long> zzehm3, zzeha zzeha2, List<zzelq<zzedk, zzekd>> list) {
        if (zzehm2.getValue() != null) {
            int n = zzeha2.zza(0, new zzeab(this, zzehm3));
            if (n > 0) {
                zzedk zzedk4 = zzedk2.zzh(zzedk3);
                if (this.zzmlr.zzbzl()) {
                    Object[] objectArray = new Object[]{};
                    String string = String.format("Need to rewrite %d nodes below path %s", n, zzedk4);
                    this.zzmlr.zzb(string, null, objectArray);
                }
                zzekd zzekd2 = this.zzb(zzedk4);
                zzeha2.zza(null, new zzeac(this, zzehm3, list, zzedk3, zzekd2));
            }
            return;
        }
        for (Map.Entry entry : zzehm2.zzbxx()) {
            zzejg zzejg2 = (zzejg)entry.getKey();
            zzeha zzeha3 = zzeha2.zzd((zzejg)entry.getKey());
            this.zza(zzedk2, zzedk3.zza(zzejg2), (zzehm)entry.getValue(), zzehm3.zze(zzejg2), zzeha3, list);
        }
    }

    @Override
    public final void zzbte() {
        this.zzbtf();
        long l = System.currentTimeMillis();
        int n = this.zzmlq.delete("writes", null, null);
        long l2 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Deleted %d (all) write(s) in %dms", n, l2);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void beginTransaction() {
        zzelt.zzb(!this.zzmls, "runInTransaction called when an existing transaction is already in progress.");
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = "Starting transaction.";
            this.zzmlr.zzb("Starting transaction.", null, objectArray);
        }
        this.zzmlq.beginTransaction();
        this.zzmls = true;
        this.zzmlt = System.currentTimeMillis();
    }

    @Override
    public final void endTransaction() {
        this.zzmlq.endTransaction();
        this.zzmls = false;
        long l = System.currentTimeMillis() - this.zzmlt;
        if (this.zzmlr.zzbzl()) {
            Object[] objectArray = new Object[]{};
            String string = String.format("Transaction completed. Elapsed: %dms", l);
            this.zzmlr.zzb(string, null, objectArray);
        }
    }

    @Override
    public final void setTransactionSuccessful() {
        this.zzmlq.setTransactionSuccessful();
    }

    private static SQLiteDatabase zzal(Context context, String string) {
        zzead zzead2 = new zzead(context, string);
        try {
            SQLiteDatabase sQLiteDatabase = zzead2.getWritableDatabase();
            sQLiteDatabase.rawQuery("PRAGMA locking_mode = EXCLUSIVE", null).close();
            sQLiteDatabase.beginTransaction();
            sQLiteDatabase.endTransaction();
            return sQLiteDatabase;
        }
        catch (SQLiteException sQLiteException) {
            SQLiteException sQLiteException2 = sQLiteException;
            if (sQLiteException instanceof SQLiteDatabaseLockedException) {
                String string2 = "Failed to gain exclusive lock to Firebase Database's offline persistence. This generally means you are using Firebase Database from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing FirebaseDatabase in your Application class. If you are intentionally using Firebase Database from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.";
                throw new DatabaseException(string2, sQLiteException2);
            }
            throw sQLiteException2;
        }
    }

    private final void zzbtf() {
        zzelt.zzb(this.zzmls, "Transaction expected to already be in progress.");
    }

    private final int zzc(zzedk zzedk2, zzekd zzekd2) {
        long l = zzelo.zzn(zzekd2);
        if (zzekd2 instanceof zzeji && l > 16384L) {
            if (this.zzmlr.zzbzl()) {
                Object[] objectArray = new Object[]{};
                String string = String.format("Node estimated serialized size at path %s of %d bytes exceeds limit of %d bytes. Splitting up.", zzedk2, l, 16384);
                this.zzmlr.zzb(string, null, objectArray);
            }
            int n = 0;
            for (zzekc zzekc2 : zzekd2) {
                n += this.zzc(zzedk2.zza(zzekc2.zzcao()), zzekc2.zzbsv());
            }
            if (!zzekd2.zzbzv().isEmpty()) {
                this.zzd(zzedk2.zza(zzejg.zzbzp()), zzekd2.zzbzv());
                ++n;
            }
            this.zzd(zzedk2, zzeju.zzcaf());
            return ++n;
        }
        this.zzd(zzedk2, zzekd2);
        return 1;
    }

    private static String zza(zzedk zzedk2, int n) {
        String string = String.valueOf(zzeaa.zzc(zzedk2));
        String string2 = String.valueOf(String.format(".part-%04d", n));
        if (string2.length() != 0) {
            return string.concat(string2);
        }
        return new String(string);
    }

    private final void zzd(zzedk zzedk2, zzekd zzekd2) {
        byte[] byArray = zzeaa.zzbe(zzekd2.getValue(true));
        if (byArray.length >= 262144) {
            int n;
            List<byte[]> list = zzeaa.zzf(byArray, 262144);
            if (this.zzmlr.zzbzl()) {
                n = list.size();
                Object[] objectArray = new Object[]{};
                String string = new StringBuilder(45).append("Saving huge leaf node with ").append(n).append(" parts.").toString();
                this.zzmlr.zzb(string, null, objectArray);
            }
            for (n = 0; n < list.size(); ++n) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("path", zzeaa.zza(zzedk2, n));
                contentValues.put("value", list.get(n));
                this.zzmlq.insertWithOnConflict("serverCache", null, contentValues, 5);
            }
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("path", zzeaa.zzc(zzedk2));
        contentValues.put("value", byArray);
        this.zzmlq.insertWithOnConflict("serverCache", null, contentValues, 5);
    }

    /*
     * WARNING - void declaration
     */
    private final zzekd zzb(zzedk zzedk2) {
        String string;
        Object[] objectArray;
        zzedk zzedk3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        long l = System.currentTimeMillis();
        Cursor cursor = this.zza(zzedk2, new String[]{"path", "value"});
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        try {
            while (cursor.moveToNext()) {
                arrayList.add(cursor.getString(0));
                arrayList2.add(cursor.getBlob(1));
            }
        }
        finally {
            cursor.close();
        }
        long l4 = System.currentTimeMillis() - l3;
        long l5 = System.currentTimeMillis();
        zzekd zzekd2 = zzeju.zzcaf();
        boolean bl = false;
        HashMap<zzedk, void> hashMap = new HashMap<zzedk, void>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            void object;
            Object object2;
            if (((String)arrayList.get(i)).endsWith(".part-0000")) {
                object2 = (String)arrayList.get(i);
                zzedk3 = new zzedk(((String)object2).substring(0, ((String)object2).length() - 10));
                int n = zzeaa.zza(zzedk3, arrayList, i);
                if (this.zzmlr.zzbzl()) {
                    objectArray = new Object[]{};
                    string = new StringBuilder(42).append("Loading split node with ").append(n).append(" parts.").toString();
                    this.zzmlr.zzb(string, null, objectArray);
                }
                zzekd zzekd3 = zzeaa.zzan(zzeaa.zzar(arrayList2.subList(i, i + n)));
                i = i + n - 1;
            } else {
                zzekd zzekd4 = zzeaa.zzan((byte[])arrayList2.get(i));
                zzedk3 = new zzedk((String)arrayList.get(i));
            }
            if (zzedk3.zzbwk() != null && zzedk3.zzbwk().zzbzr()) {
                hashMap.put(zzedk3, object);
                continue;
            }
            if (zzedk3.zzi(zzedk2)) {
                zzelt.zzb(!bl, "Descendants of path must come after ancestors.");
                zzekd2 = object.zzan(zzedk.zza(zzedk3, zzedk2));
                continue;
            }
            if (zzedk2.zzi(zzedk3)) {
                bl = true;
                object2 = zzedk.zza(zzedk2, zzedk3);
                zzekd2 = zzekd2.zzl((zzedk)object2, (zzekd)object);
                continue;
            }
            throw new IllegalStateException(String.format("Loading an unrelated row with path %s for %s", zzedk3, zzedk2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            zzedk3 = (zzedk)entry.getKey();
            zzekd2 = zzekd2.zzl(zzedk.zza(zzedk2, zzedk3), (zzekd)entry.getValue());
        }
        long l6 = System.currentTimeMillis() - l5;
        long l7 = System.currentTimeMillis() - l;
        if (this.zzmlr.zzbzl()) {
            objectArray = new Object[]{};
            string = String.format("Loaded a total of %d rows for a total of %d nodes at %s in %dms (Query: %dms, Loading: %dms, Serializing: %dms)", arrayList2.size(), zzelo.zzo(zzekd2), zzedk2, l7, l2, l4, l6);
            this.zzmlr.zzb(string, null, objectArray);
        }
        return zzekd2;
    }

    private static int zza(zzedk zzedk2, List<String> list, int n) {
        int n2;
        String string = zzeaa.zzc(zzedk2);
        if (!list.get(n).startsWith(string)) {
            throw new IllegalStateException("Extracting split nodes needs to start with path prefix");
        }
        for (n2 = n + 1; n2 < list.size() && list.get(n2).equals(zzeaa.zza(zzedk2, n2 - n)); ++n2) {
        }
        if (n2 < list.size()) {
            String string2 = String.valueOf(string);
            String string3 = String.valueOf(".part-");
            if (list.get(n2).startsWith(string3.length() != 0 ? string2.concat(string3) : new String(string2))) {
                throw new IllegalStateException("Run did not finish with all parts");
            }
        }
        return n2 - n;
    }

    private final Cursor zza(zzedk zzedk2, String[] stringArray) {
        String[] stringArray2;
        String string = zzeaa.zzc(zzedk2);
        String string2 = zzeaa.zzpi(string);
        String[] stringArray3 = stringArray2 = new String[zzedk2.size() + 3];
        zzedk zzedk3 = zzedk2;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder("(");
        while (!zzedk3.isEmpty()) {
            stringBuilder.append("path");
            stringBuilder.append(" = ? OR ");
            stringArray3[n] = zzeaa.zzc(zzedk3);
            zzedk3 = zzedk3.zzbwj();
            ++n;
        }
        stringBuilder.append("path");
        stringBuilder.append(" = ?)");
        stringArray3[n] = zzeaa.zzc(zzedk.zzbwe());
        String string3 = String.valueOf(stringBuilder.toString());
        String string4 = String.valueOf(" OR (path > ? AND path < ?)");
        String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
        stringArray2[zzedk2.size() + 1] = string;
        stringArray2[zzedk2.size() + 2] = string2;
        String string6 = "path";
        return this.zzmlq.query("serverCache", stringArray, string5, stringArray2, null, null, string6);
    }

    private static String zzc(zzedk zzedk2) {
        if (zzedk2.isEmpty()) {
            return "/";
        }
        return String.valueOf(zzedk2.toString()).concat("/");
    }

    private static String zzpi(String string) {
        String string2 = string.substring(0, string.length() - 1);
        return new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append('0').toString();
    }

    private final int zza(String string, zzedk zzedk2) {
        String string2 = "path >= ? AND path < ?";
        String string3 = zzeaa.zzc(zzedk2);
        String string4 = zzeaa.zzpi(string3);
        return this.zzmlq.delete(string, string2, new String[]{string3, string4});
    }

    private static List<byte[]> zzf(byte[] byArray, int n) {
        int n2 = (byArray.length - 1) / 262144 + 1;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = Math.min(262144, byArray.length - i * 262144);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, i * 262144, byArray2, 0, n3);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    private static byte[] zzar(List<byte[]> list) {
        int n = 0;
        for (byte[] byArray : list) {
            n += byArray.length;
        }
        Object object = new byte[n];
        int n2 = 0;
        for (byte[] byArray : list) {
            System.arraycopy(byArray, 0, object, n2, byArray.length);
            n2 += byArray.length;
        }
        return object;
    }

    private static byte[] zzbe(Object object) {
        try {
            return zzelh.zzbt((Object)object).getBytes(zzfhj);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize leaf node", iOException);
        }
    }

    private static zzekd zzan(byte[] byArray) {
        try {
            return zzekg.zza(zzelh.zzqc((String)new String(byArray, zzfhj)), zzeju.zzcaf());
        }
        catch (IOException iOException) {
            String string = new String(byArray, zzfhj);
            String string2 = String.valueOf(string);
            throw new RuntimeException(string2.length() != 0 ? "Could not deserialize node: ".concat(string2) : new String("Could not deserialize node: "), iOException);
        }
    }

    private static String zzr(Collection<Long> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (long l : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(l);
        }
        return stringBuilder.toString();
    }
}

