/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import android.support.annotation.Nullable;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzejw;
import com.google.android.gms.internal.zzekc;
import com.google.android.gms.internal.zzekd;
import com.google.android.gms.internal.zzelv;
import com.google.android.gms.internal.zzelw;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.GenericTypeIndicator;
import com.google.firebase.database.zza;
import java.util.Iterator;

public class DataSnapshot {
    private final zzejw zzmjq;
    private final DatabaseReference zzmjr;

    DataSnapshot(DatabaseReference databaseReference, zzejw zzejw2) {
        this.zzmjq = zzejw2;
        this.zzmjr = databaseReference;
    }

    public DataSnapshot child(String string) {
        DatabaseReference databaseReference = this.zzmjr.child(string);
        zzekd zzekd2 = this.zzmjq.zzbsv().zzan(new zzedk(string));
        return new DataSnapshot(databaseReference, zzejw.zzj(zzekd2));
    }

    public boolean hasChild(String string) {
        if (this.zzmjr.getParent() == null) {
            zzelv.zzqi(string);
        } else {
            zzelv.zzqh(string);
        }
        return !this.zzmjq.zzbsv().zzan(new zzedk(string)).isEmpty();
    }

    public boolean hasChildren() {
        return this.zzmjq.zzbsv().getChildCount() > 0;
    }

    public boolean exists() {
        return !this.zzmjq.zzbsv().isEmpty();
    }

    @Nullable
    public Object getValue() {
        return this.zzmjq.zzbsv().getValue();
    }

    @Nullable
    public Object getValue(boolean bl) {
        return this.zzmjq.zzbsv().getValue(bl);
    }

    @Nullable
    public <T> T getValue(Class<T> clazz) {
        return zzelw.zza(this.zzmjq.zzbsv().getValue(), clazz);
    }

    @Nullable
    public <T> T getValue(GenericTypeIndicator<T> genericTypeIndicator) {
        return zzelw.zza(this.zzmjq.zzbsv().getValue(), genericTypeIndicator);
    }

    public long getChildrenCount() {
        return this.zzmjq.zzbsv().getChildCount();
    }

    public DatabaseReference getRef() {
        return this.zzmjr;
    }

    public String getKey() {
        return this.zzmjr.getKey();
    }

    public Iterable<DataSnapshot> getChildren() {
        Iterator<zzekc> iterator = this.zzmjq.iterator();
        return new zza(this, iterator);
    }

    public Object getPriority() {
        Object object = this.zzmjq.zzbsv().zzbzv().getValue();
        if (object instanceof Long) {
            return (double)((Long)object).longValue();
        }
        return object;
    }

    public String toString() {
        String string = this.zzmjr.getKey();
        String string2 = String.valueOf(this.zzmjq.zzbsv().getValue(true));
        return new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("DataSnapshot { key = ").append(string).append(", value = ").append(string2).append(" }").toString();
    }

    static /* synthetic */ DatabaseReference zza(DataSnapshot dataSnapshot) {
        return dataSnapshot.zzmjr;
    }
}

