/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzads;
import com.google.android.gms.internal.zzadx;
import com.google.android.gms.internal.zzaea;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzadr<K, V>
extends zzads<K, V> {
    private final K[] zzbId;
    private final V[] zzbIe;
    private final Comparator<K> zzbIf;

    public static <A, B, C> zzadr<A, C> zza(List<A> list, Map<B, C> map, zzads.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzah(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzadr<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzadr<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzadr.zza(new ArrayList<K>(map.keySet()), map, zzads.zza.zzPy(), comparator);
    }

    public zzadr(Comparator<K> comparator) {
        this.zzbId = new Object[0];
        this.zzbIe = new Object[0];
        this.zzbIf = comparator;
    }

    private zzadr(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.zzbId = KArray;
        this.zzbIe = VArray;
        this.zzbIf = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzag(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzag(k);
        return n != -1 ? (V)this.zzbIe[n] : null;
    }

    @Override
    public zzads<K, V> zzad(K k) {
        int n = this.zzag(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzadr.zza(this.zzbId, n);
        V[] VArray = zzadr.zza(this.zzbIe, n);
        return new zzadr<K, V>(this.zzbIf, KArray, VArray);
    }

    @Override
    public zzads<K, V> zzj(K k, V v) {
        int n = this.zzag(k);
        if (n != -1) {
            if (this.zzbId[n] == k && this.zzbIe[n] == v) {
                return this;
            }
            K[] KArray = zzadr.zzb(this.zzbId, n, k);
            V[] VArray = zzadr.zzb(this.zzbIe, n, v);
            return new zzadr<K, V>(this.zzbIf, KArray, VArray);
        }
        if (this.zzbId.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.zzbId.length + 1);
            for (int i = 0; i < this.zzbId.length; ++i) {
                hashMap.put(this.zzbId[i], this.zzbIe[i]);
            }
            hashMap.put(k, v);
            return zzaea.zzc(hashMap, this.zzbIf);
        }
        int n2 = this.zzaf(k);
        K[] KArray = zzadr.zza(this.zzbId, n2, k);
        V[] VArray = zzadr.zza(this.zzbIe, n2, v);
        return new zzadr<K, V>(this.zzbIf, KArray, VArray);
    }

    @Override
    public K zzPu() {
        return this.zzbId.length > 0 ? (K)this.zzbId[0] : null;
    }

    @Override
    public K zzPv() {
        return this.zzbId.length > 0 ? (K)this.zzbId[this.zzbId.length - 1] : null;
    }

    @Override
    public int size() {
        return this.zzbId.length;
    }

    @Override
    public boolean isEmpty() {
        return this.zzbId.length == 0;
    }

    @Override
    public void zza(zzadx.zzb<K, V> zzb2) {
        for (int i = 0; i < this.zzbId.length; ++i) {
            zzb2.zzk(this.zzbId[i], this.zzbIe[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zzh(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int zzbIg;
            {
                this.zzbIg = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.zzbIg >= 0 : this.zzbIg < zzadr.this.zzbId.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzadr.this.zzbId[this.zzbIg];
                Object object2 = zzadr.this.zzbIe[this.zzbIg];
                this.zzbIg = bl ? this.zzbIg - 1 : this.zzbIg + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zzh(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzPw() {
        return this.zzh(this.zzbId.length - 1, true);
    }

    @Override
    public K zzae(K k) {
        int n = this.zzag(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.zzbId[n - 1] : null;
    }

    @Override
    public Comparator<K> zzPx() {
        return this.zzbIf;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzaf(K k) {
        int n;
        for (n = 0; n < this.zzbId.length && this.zzbIf.compare(this.zzbId[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzag(K k) {
        int n = 0;
        for (K k2 : this.zzbId) {
            if (this.zzbIf.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

