/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzahi;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzafa
implements Comparable<zzafa>,
Iterable<zzahi> {
    private final zzahi[] zzbLK;
    private final int start;
    private final int end;
    private static final zzafa zzbLL = new zzafa("");

    public static zzafa zza(zzafa zzafa2, zzafa zzafa3) {
        zzahi zzahi2 = zzafa2.zzRt();
        zzahi zzahi3 = zzafa3.zzRt();
        if (zzahi2 == null) {
            return zzafa3;
        }
        if (zzahi2.equals(zzahi3)) {
            return zzafa.zza(zzafa2.zzRu(), zzafa3.zzRu());
        }
        String string = String.valueOf(zzafa3);
        String string2 = String.valueOf(zzafa2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzafa zzRq() {
        return zzbLL;
    }

    public zzafa(zzahi ... zzahiArray) {
        this.zzbLK = Arrays.copyOf(zzahiArray, zzahiArray.length);
        this.start = 0;
        this.end = zzahiArray.length;
        for (zzahi zzahi2 : zzahiArray) {
            assert (zzahi2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzafa(List<String> list) {
        this.zzbLK = new zzahi[list.size()];
        int n = 0;
        for (String string : list) {
            this.zzbLK[n++] = zzahi.zzig(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzafa(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.zzbLK = new zzahi[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.zzbLK[n2++] = zzahi.zzig(string3);
        }
        this.start = 0;
        this.end = this.zzbLK.length;
    }

    private zzafa(zzahi[] zzahiArray, int n, int n2) {
        this.zzbLK = zzahiArray;
        this.start = n;
        this.end = n2;
    }

    public zzafa zzh(zzafa zzafa2) {
        int n = this.size() + zzafa2.size();
        zzahi[] zzahiArray = new zzahi[n];
        System.arraycopy(this.zzbLK, this.start, zzahiArray, 0, this.size());
        System.arraycopy(zzafa2.zzbLK, zzafa2.start, zzahiArray, this.size(), zzafa2.size());
        return new zzafa(zzahiArray, 0, n);
    }

    public zzafa zza(zzahi zzahi2) {
        int n = this.size();
        zzahi[] zzahiArray = new zzahi[n + 1];
        System.arraycopy(this.zzbLK, this.start, zzahiArray, 0, n);
        zzahiArray[n] = zzahi2;
        return new zzafa(zzahiArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.zzbLK[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzRr() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.zzbLK[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzRs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzahi zzahi2 : this) {
            arrayList.add(zzahi2.asString());
        }
        return arrayList;
    }

    public zzahi zzRt() {
        if (this.isEmpty()) {
            return null;
        }
        return this.zzbLK[this.start];
    }

    public zzafa zzRu() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzafa(this.zzbLK, n, this.end);
    }

    public zzafa zzRv() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzafa(this.zzbLK, this.start, this.end - 1);
    }

    public zzahi zzRw() {
        if (!this.isEmpty()) {
            return this.zzbLK[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzahi> iterator() {
        return new Iterator<zzahi>(){
            int offset;
            {
                this.offset = zzafa.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzafa.this.end;
            }

            public zzahi zzRx() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzahi zzahi2 = zzafa.this.zzbLK[this.offset];
                ++this.offset;
                return zzahi2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzRx();
            }
        };
    }

    public boolean zzi(zzafa zzafa2) {
        if (this.size() > zzafa2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzafa2.start;
        while (n < this.end) {
            if (!this.zzbLK[n].equals(zzafa2.zzbLK[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzafa)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzafa zzafa2 = (zzafa)object;
        if (this.size() != zzafa2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzafa2.start; n < this.end && i < zzafa2.end; ++n, ++i) {
            if (this.zzbLK[n].equals(zzafa2.zzbLK[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.zzbLK[i].hashCode();
        }
        return n;
    }

    public int zzj(zzafa zzafa2) {
        int n;
        int n2 = this.start;
        for (n = zzafa2.start; n2 < this.end && n < zzafa2.end; ++n2, ++n) {
            int n3 = this.zzbLK[n2].zzi(zzafa2.zzbLK[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzafa2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzafa)object);
    }
}

