/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahj;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzaiv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class zzahk {
    private final List<zzafa> zzbIH;
    private final List<String> zzbII;

    private zzahk(List<zzafa> list, List<String> list2) {
        if (list.size() != list2.size() - 1) {
            throw new IllegalArgumentException("Number of posts need to be n-1 for n hashes in CompoundHash");
        }
        this.zzbIH = list;
        this.zzbII = list2;
    }

    public List<zzafa> zzPR() {
        return Collections.unmodifiableList(this.zzbIH);
    }

    public List<String> zzPS() {
        return Collections.unmodifiableList(this.zzbII);
    }

    public static zzahk zzh(zzahu zzahu2) {
        return zzahk.zza(zzahu2, new zzb(zzahu2));
    }

    public static zzahk zza(zzahu zzahu2, zzc zzc2) {
        if (zzahu2.isEmpty()) {
            return new zzahk(Collections.emptyList(), Collections.singletonList(""));
        }
        zza zza2 = new zza(zzc2);
        zzahk.zza(zzahu2, zza2);
        zza2.zzTy();
        return new zzahk(zza2.zzbQP, zza2.zzbQQ);
    }

    private static void zza(zzahu zzahu2, final zza zza2) {
        if (zzahu2.zzTo()) {
            zza2.zzb((zzahr)zzahu2);
        } else {
            if (zzahu2.isEmpty()) {
                throw new IllegalArgumentException("Can't calculate hash on empty node!");
            }
            if (!(zzahu2 instanceof zzahj)) {
                String string = String.valueOf(zzahu2);
                throw new IllegalStateException(new StringBuilder(33 + String.valueOf(string).length()).append("Expected children node, but got: ").append(string).toString());
            }
            zzahj zzahj2 = (zzahj)zzahu2;
            zzahj.zza zza3 = new zzahj.zza(){

                @Override
                public void zzb(zzahi zzahi2, zzahu zzahu2) {
                    zza2.zzn(zzahi2);
                    zzahk.zza(zzahu2, zza2);
                    zza2.zzTx();
                }
            };
            zzahj2.zza(zza3, true);
        }
    }

    static class zza {
        private StringBuilder zzbQK = null;
        private Stack<zzahi> zzbQL = new Stack();
        private int zzbQM = -1;
        private int zzbQN;
        private boolean zzbQO = true;
        private final List<zzafa> zzbQP = new ArrayList<zzafa>();
        private final List<String> zzbQQ = new ArrayList<String>();
        private final zzc zzbQR;

        public zza(zzc zzc2) {
            this.zzbQR = zzc2;
        }

        public boolean zzTt() {
            return this.zzbQK != null;
        }

        public int zzTu() {
            return this.zzbQK.length();
        }

        public zzafa zzTv() {
            return this.zznE(this.zzbQN);
        }

        private zzafa zznE(int n) {
            zzahi[] zzahiArray = new zzahi[n];
            for (int i = 0; i < n; ++i) {
                zzahiArray[i] = (zzahi)this.zzbQL.get(i);
            }
            return new zzafa(zzahiArray);
        }

        private void zzTw() {
            if (!this.zzTt()) {
                this.zzbQK = new StringBuilder();
                this.zzbQK.append("(");
                for (zzahi zzahi2 : this.zznE(this.zzbQN)) {
                    this.zza(this.zzbQK, zzahi2);
                    this.zzbQK.append(":(");
                }
                this.zzbQO = false;
            }
        }

        private void zza(StringBuilder stringBuilder, zzahi zzahi2) {
            stringBuilder.append(zzaiv.zzin(zzahi2.asString()));
        }

        private void zzb(zzahr<?> zzahr2) {
            this.zzTw();
            this.zzbQM = this.zzbQN;
            this.zzbQK.append(zzahr2.zza(zzahu.zza.zzbRk));
            this.zzbQO = true;
            if (this.zzbQR.zze(this)) {
                this.zzTz();
            }
        }

        private void zzn(zzahi zzahi2) {
            this.zzTw();
            if (this.zzbQO) {
                this.zzbQK.append(",");
            }
            this.zza(this.zzbQK, zzahi2);
            this.zzbQK.append(":(");
            if (this.zzbQN == this.zzbQL.size()) {
                this.zzbQL.add(zzahi2);
            } else {
                this.zzbQL.set(this.zzbQN, zzahi2);
            }
            ++this.zzbQN;
            this.zzbQO = false;
        }

        private void zzTx() {
            --this.zzbQN;
            if (this.zzTt()) {
                this.zzbQK.append(")");
            }
            this.zzbQO = true;
        }

        private void zzTy() {
            zzaiv.zzb(this.zzbQN == 0, "Can't finish hashing in the middle processing a child");
            if (this.zzTt()) {
                this.zzTz();
            }
            this.zzbQQ.add("");
        }

        private void zzTz() {
            zzaiv.zzb(this.zzTt(), "Can't end range without starting a range!");
            for (int i = 0; i < this.zzbQN; ++i) {
                this.zzbQK.append(")");
            }
            this.zzbQK.append(")");
            zzafa zzafa2 = this.zznE(this.zzbQM);
            String string = zzaiv.zzim(this.zzbQK.toString());
            this.zzbQQ.add(string);
            this.zzbQP.add(zzafa2);
            this.zzbQK = null;
        }
    }

    private static class zzb
    implements zzc {
        private final long zzbQS;

        public zzb(zzahu zzahu2) {
            long l = zzaiq.zzs(zzahu2);
            this.zzbQS = Math.max(512L, (long)Math.sqrt(l * 100L));
        }

        @Override
        public boolean zze(zza zza2) {
            return (long)zza2.zzTu() > this.zzbQS && (zza2.zzTv().isEmpty() || !zza2.zzTv().zzRw().equals(zzahi.zzTj()));
        }
    }

    public static interface zzc {
        public boolean zze(zza var1);
    }
}

