/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzaes;
import com.google.android.gms.internal.zzaev;
import com.google.android.gms.internal.zzafa;
import com.google.android.gms.internal.zzafc;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzafo;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzahu;
import com.google.android.gms.internal.zzahv;
import com.google.android.gms.internal.zzahy;
import com.google.android.gms.internal.zzais;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaiv;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzaev zzbHb;

    DatabaseReference(zzafc zzafc2, zzafa zzafa2) {
        super(zzafc2, zzafa2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzPn().isEmpty()) {
            zzaiw.zzir(string);
        } else {
            zzaiw.zziq(string);
        }
        zzafa zzafa2 = this.zzPn().zzh(new zzafa(string));
        return new DatabaseReference(this.zzbHo, zzafa2);
    }

    public DatabaseReference push() {
        String string = zzaiu.zzaJ(this.zzbHo.zzRA());
        zzahi zzahi2 = zzahi.zzig(string);
        return new DatabaseReference(this.zzbHo, this.zzPn().zza(zzahi2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzahy.zzar(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzahy.zzar(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzahy.zzar(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzahy.zzar(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzahu zzahu2, CompletionListener completionListener) {
        zzaiw.zzQ(this.zzPn());
        zzafo.zza(this.zzPn(), object);
        Object object2 = zzaix.zzav(object);
        zzaiw.zzau(object2);
        final zzahu zzahu3 = zzahv.zza(object2, zzahu2);
        final zzais<Task<Void>, CompletionListener> zzais2 = zzaiv.zzb(completionListener);
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbHo.zza(DatabaseReference.this.zzPn(), zzahu3, (CompletionListener)zzais2.zzUj());
            }
        });
        return zzais2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzahy.zzar(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzahy.zzar(object), completionListener);
    }

    private Task<Void> zza(final zzahu zzahu2, CompletionListener completionListener) {
        zzaiw.zzQ(this.zzPn());
        final zzais<Task<Void>, CompletionListener> zzais2 = zzaiv.zzb(completionListener);
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbHo.zza(DatabaseReference.this.zzPn().zza(zzahi.zzTj()), zzahu2, (CompletionListener)zzais2.zzUj());
            }
        });
        return zzais2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(final Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<zzafa, zzahu> map2 = zzaiw.zzc(this.zzPn(), map);
        final zzaes zzaes2 = zzaes.zzay(map2);
        final zzais<Task<Void>, CompletionListener> zzais2 = zzaiv.zzb(completionListener);
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbHo.zza(DatabaseReference.this.zzPn(), zzaes2, (CompletionListener)zzais2.zzUj(), (Map<String, Object>)map);
            }
        });
        return zzais2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzaiw.zzQ(this.zzPn());
        return new OnDisconnect(this.zzbHo, this.zzPn());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzaiw.zzQ(this.zzPn());
        this.zzbHo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.zzbHo.zza(DatabaseReference.this.zzPn(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzPh());
    }

    static void zza(zzaev zzaev2) {
        zzafe.zzd(zzaev2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzPh());
    }

    static void zzb(zzaev zzaev2) {
        zzafe.zze(zzaev2);
    }

    public FirebaseDatabase getDatabase() {
        return this.zzbHo.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.zzbHo.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzafa zzafa2 = this.zzPn().zzRv();
        if (zzafa2 != null) {
            return new DatabaseReference(this.zzbHo, zzafa2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.zzbHo, new zzafa(""));
    }

    public String getKey() {
        if (this.zzPn().isEmpty()) {
            return null;
        }
        return this.zzPn().zzRw().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzaev zzPh() {
        if (zzbHb == null) {
            zzbHb = new zzaev();
        }
        return zzbHb;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

