/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzagf;
import com.google.android.gms.internal.zzagk;
import com.google.android.gms.internal.zzagn;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzage<K, V>
extends zzagf<K, V> {
    private final K[] aPX;
    private final V[] aPY;
    private final Comparator<K> aPZ;

    public static <A, B, C> zzage<A, C> zza(List<A> list, Map<B, C> map, zzagf.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzbh(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzage<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzage<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzage.zza(new ArrayList<K>(map.keySet()), map, zzagf.zza.zzcne(), comparator);
    }

    public zzage(Comparator<K> comparator) {
        this.aPX = new Object[0];
        this.aPY = new Object[0];
        this.aPZ = comparator;
    }

    private zzage(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.aPX = KArray;
        this.aPY = VArray;
        this.aPZ = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzbg(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzbg(k);
        return n != -1 ? (V)this.aPY[n] : null;
    }

    @Override
    public zzagf<K, V> zzbd(K k) {
        int n = this.zzbg(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzage.zza(this.aPX, n);
        V[] VArray = zzage.zza(this.aPY, n);
        return new zzage<K, V>(this.aPZ, KArray, VArray);
    }

    @Override
    public zzagf<K, V> zzj(K k, V v) {
        int n = this.zzbg(k);
        if (n != -1) {
            if (this.aPX[n] == k && this.aPY[n] == v) {
                return this;
            }
            K[] KArray = zzage.zzb(this.aPX, n, k);
            V[] VArray = zzage.zzb(this.aPY, n, v);
            return new zzage<K, V>(this.aPZ, KArray, VArray);
        }
        if (this.aPX.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.aPX.length + 1);
            for (int i = 0; i < this.aPX.length; ++i) {
                hashMap.put(this.aPX[i], this.aPY[i]);
            }
            hashMap.put(k, v);
            return zzagn.zzc(hashMap, this.aPZ);
        }
        int n2 = this.zzbf(k);
        K[] KArray = zzage.zza(this.aPX, n2, k);
        V[] VArray = zzage.zza(this.aPY, n2, v);
        return new zzage<K, V>(this.aPZ, KArray, VArray);
    }

    @Override
    public K zzcnb() {
        return this.aPX.length > 0 ? (K)this.aPX[0] : null;
    }

    @Override
    public K zzcnc() {
        return this.aPX.length > 0 ? (K)this.aPX[this.aPX.length - 1] : null;
    }

    @Override
    public int size() {
        return this.aPX.length;
    }

    @Override
    public boolean isEmpty() {
        return this.aPX.length == 0;
    }

    @Override
    public void zza(zzagk.zzb<K, V> zzb2) {
        for (int i = 0; i < this.aPX.length; ++i) {
            zzb2.zzk(this.aPX[i], this.aPY[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zzh(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int aQa;
            {
                this.aQa = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.aQa >= 0 : this.aQa < zzage.this.aPX.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzage.this.aPX[this.aQa];
                Object object2 = zzage.this.aPY[this.aQa];
                this.aQa = bl ? this.aQa - 1 : this.aQa + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zzh(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzcnd() {
        return this.zzh(this.aPX.length - 1, true);
    }

    @Override
    public K zzbe(K k) {
        int n = this.zzbg(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.aPX[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.aPZ;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzbf(K k) {
        int n;
        for (n = 0; n < this.aPX.length && this.aPZ.compare(this.aPX[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzbg(K k) {
        int n = 0;
        for (K k2 : this.aPX) {
            if (this.aPZ.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

