/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzajx;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzaho
implements Comparable<zzaho>,
Iterable<zzajx> {
    private final zzajx[] aTB;
    private final int start;
    private final int end;
    private static final zzaho aTC = new zzaho("");

    public static zzaho zza(zzaho zzaho2, zzaho zzaho3) {
        zzajx zzajx2 = zzaho2.zzcqz();
        zzajx zzajx3 = zzaho3.zzcqz();
        if (zzajx2 == null) {
            return zzaho3;
        }
        if (zzajx2.equals(zzajx3)) {
            return zzaho.zza(zzaho2.zzcra(), zzaho3.zzcra());
        }
        String string = String.valueOf(zzaho3);
        String string2 = String.valueOf(zzaho2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzaho zzcqw() {
        return aTC;
    }

    public zzaho(zzajx ... zzajxArray) {
        this.aTB = Arrays.copyOf(zzajxArray, zzajxArray.length);
        this.start = 0;
        this.end = zzajxArray.length;
        for (zzajx zzajx2 : zzajxArray) {
            assert (zzajx2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzaho(List<String> list) {
        this.aTB = new zzajx[list.size()];
        int n = 0;
        for (String string : list) {
            this.aTB[n++] = zzajx.zzsc(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzaho(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.aTB = new zzajx[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.aTB[n2++] = zzajx.zzsc(string3);
        }
        this.start = 0;
        this.end = this.aTB.length;
    }

    private zzaho(zzajx[] zzajxArray, int n, int n2) {
        this.aTB = zzajxArray;
        this.start = n;
        this.end = n2;
    }

    public zzaho zzh(zzaho zzaho2) {
        int n = this.size() + zzaho2.size();
        zzajx[] zzajxArray = new zzajx[n];
        System.arraycopy(this.aTB, this.start, zzajxArray, 0, this.size());
        System.arraycopy(zzaho2.aTB, zzaho2.start, zzajxArray, this.size(), zzaho2.size());
        return new zzaho(zzajxArray, 0, n);
    }

    public zzaho zza(zzajx zzajx2) {
        int n = this.size();
        zzajx[] zzajxArray = new zzajx[n + 1];
        System.arraycopy(this.aTB, this.start, zzajxArray, 0, n);
        zzajxArray[n] = zzajx2;
        return new zzaho(zzajxArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.aTB[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzcqx() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.aTB[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzcqy() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzajx zzajx2 : this) {
            arrayList.add(zzajx2.asString());
        }
        return arrayList;
    }

    public zzajx zzcqz() {
        if (this.isEmpty()) {
            return null;
        }
        return this.aTB[this.start];
    }

    public zzaho zzcra() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzaho(this.aTB, n, this.end);
    }

    public zzaho zzcrb() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzaho(this.aTB, this.start, this.end - 1);
    }

    public zzajx zzcrc() {
        if (!this.isEmpty()) {
            return this.aTB[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzajx> iterator() {
        return new Iterator<zzajx>(){
            int offset;
            {
                this.offset = zzaho.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzaho.this.end;
            }

            public zzajx zzcrd() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzajx zzajx2 = zzaho.this.aTB[this.offset];
                ++this.offset;
                return zzajx2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzcrd();
            }
        };
    }

    public boolean zzi(zzaho zzaho2) {
        if (this.size() > zzaho2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzaho2.start;
        while (n < this.end) {
            if (!this.aTB[n].equals(zzaho2.aTB[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzaho)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzaho zzaho2 = (zzaho)object;
        if (this.size() != zzaho2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzaho2.start; n < this.end && i < zzaho2.end; ++n, ++i) {
            if (this.aTB[n].equals(zzaho2.aTB[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.aTB[i].hashCode();
        }
        return n;
    }

    public int zzj(zzaho zzaho2) {
        int n;
        int n2 = this.start;
        for (n = zzaho2.start; n2 < this.end && n < zzaho2.end; ++n2, ++n) {
            int n3 = this.aTB[n2].zzi(zzaho2.aTB[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzaho2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzaho)object);
    }
}

