/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzaid;
import com.google.android.gms.internal.zzajx;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakn;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalk;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzaln;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzahi aOV;

    DatabaseReference(zzahq zzahq2, zzaho zzaho2) {
        super(zzahq2, zzaho2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzcmu().isEmpty()) {
            zzalm.zzso(string);
        } else {
            zzalm.zzsn(string);
        }
        zzaho zzaho2 = this.zzcmu().zzh(new zzaho(string));
        return new DatabaseReference(this.aPi, zzaho2);
    }

    public DatabaseReference push() {
        String string = zzalk.zzcn(this.aPi.zzcrg());
        zzajx zzajx2 = zzajx.zzsc(string);
        return new DatabaseReference(this.aPi, this.zzcmu().zza(zzajx2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzakn.zzbr(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzakn.zzbr(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzakn.zzbr(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzakn.zzbr(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzakj zzakj2, CompletionListener completionListener) {
        zzalm.zzaq(this.zzcmu());
        zzaid.zza(this.zzcmu(), object);
        Object object2 = zzaln.zzbv(object);
        zzalm.zzbu(object2);
        final zzakj zzakj3 = zzakk.zza(object2, zzakj2);
        final zzali<Task<Void>, CompletionListener> zzali2 = zzall.zzb(completionListener);
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPi.zza(DatabaseReference.this.zzcmu(), zzakj3, (CompletionListener)zzali2.zzcwp());
            }
        });
        return zzali2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzakn.zzbr(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzakn.zzbr(object), completionListener);
    }

    private Task<Void> zza(final zzakj zzakj2, CompletionListener completionListener) {
        zzalm.zzaq(this.zzcmu());
        final zzali<Task<Void>, CompletionListener> zzali2 = zzall.zzb(completionListener);
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPi.zza(DatabaseReference.this.zzcmu().zza(zzajx.zzcup()), zzakj2, (CompletionListener)zzali2.zzcwp());
            }
        });
        return zzali2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(final Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        Map<zzaho, zzakj> map2 = zzalm.zzc(this.zzcmu(), map);
        final zzahf zzahf2 = zzahf.zzby(map2);
        final zzali<Task<Void>, CompletionListener> zzali2 = zzall.zzb(completionListener);
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPi.zza(DatabaseReference.this.zzcmu(), zzahf2, (CompletionListener)zzali2.zzcwp(), (Map<String, Object>)map);
            }
        });
        return zzali2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzalm.zzaq(this.zzcmu());
        return new OnDisconnect(this.aPi, this.zzcmu());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzalm.zzaq(this.zzcmu());
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aPi.zza(DatabaseReference.this.zzcmu(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzcmo());
    }

    static void zza(zzahi zzahi2) {
        zzahs.zzd(zzahi2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzcmo());
    }

    static void zzb(zzahi zzahi2) {
        zzahs.zze(zzahi2);
    }

    public FirebaseDatabase getDatabase() {
        return this.aPi.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.aPi.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzaho zzaho2 = this.zzcmu().zzcrb();
        if (zzaho2 != null) {
            return new DatabaseReference(this.aPi, zzaho2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.aPi, new zzaho(""));
    }

    public String getKey() {
        if (this.zzcmu().isEmpty()) {
            return null;
        }
        return this.zzcmu().zzcrc().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzahi zzcmo() {
        if (aOV == null) {
            aOV = new zzahi();
        }
        return aOV;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

