/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzahi;
import com.google.android.gms.internal.zzaho;
import com.google.android.gms.internal.zzahq;
import com.google.android.gms.internal.zzahr;
import com.google.android.gms.internal.zzahs;
import com.google.android.gms.internal.zzalj;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzalm;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> aPe = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp aPf;
    private final zzahr aPg;
    private final zzahi aPh;
    private zzahq aPi;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!aPe.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzalj zzalj2 = zzall.zzsi(string);
            if (!zzalj2.aPq.isEmpty()) {
                String string2 = String.valueOf(zzalj2.aPq.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzahi zzahi2 = new zzahi();
            if (!firebaseApp.zzckb()) {
                zzahi2.zzsa(firebaseApp.getName());
            }
            zzahi2.zze(firebaseApp);
            aPe.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzalj2.aPg, zzahi2));
        }
        return aPe.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzahr zzahr2, zzahi zzahi2) {
        this.aPf = firebaseApp;
        this.aPg = zzahr2;
        this.aPh = zzahi2;
    }

    public FirebaseApp getApp() {
        return this.aPf;
    }

    public DatabaseReference getReference() {
        this.zzcmp();
        return new DatabaseReference(this.aPi, zzaho.zzcqw());
    }

    public DatabaseReference getReference(String string) {
        this.zzcmp();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzalm.zzso(string);
        zzaho zzaho2 = new zzaho(string);
        return new DatabaseReference(this.aPi, zzaho2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzcmp();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzalj zzalj2 = zzall.zzsi(string);
        if (!zzalj2.aPg.aQT.equals(this.aPi.zzcrf().aQT)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.aPi, zzalj2.aPq);
    }

    public void purgeOutstandingWrites() {
        this.zzcmp();
        this.aPi.zzs(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.aPi.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzcmp();
        zzahs.zzl(this.aPi);
    }

    public void goOffline() {
        this.zzcmp();
        zzahs.zzk(this.aPi);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzrh("setLogLevel");
        this.aPh.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzrh("setPersistenceEnabled");
        this.aPh.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zzrh(String string) {
        if (this.aPi != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzcmp() {
        if (this.aPi == null) {
            this.aPi = zzahs.zza(this.aPh, this.aPg, this);
        }
    }
}

