/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajl;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzamq
implements zzaje {
    private ScheduledThreadPoolExecutor bgQ;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzajl zzcvd() {
        return zzajl.bcv;
    }

    public abstract void zzj(Throwable var1);

    public zzamq() {
        boolean bl = true;
        zza zza2 = new zza();
        this.bgQ = new ScheduledThreadPoolExecutor(1, zza2){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                if (throwable == null && runnable instanceof Future) {
                    Future future = (Future)((Object)runnable);
                    try {
                        if (future.isDone()) {
                            future.get();
                        }
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        throwable = executionException.getCause();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (throwable != null) {
                    zzamq.this.zzj(throwable);
                }
            }
        };
        this.bgQ.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public ScheduledExecutorService zzcsh() {
        return this.bgQ;
    }

    @Override
    public void zzs(Runnable runnable) {
        this.bgQ.execute(runnable);
    }

    @Override
    public void shutdown() {
        this.bgQ.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.bgQ.setCorePoolSize(1);
    }

    public static String zzl(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }

    private class zza
    implements ThreadFactory {
        private zza() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = zzamq.this.getThreadFactory().newThread(runnable);
            zzajl zzajl2 = zzamq.this.zzcvd();
            zzajl2.zza(thread, "FirebaseDatabaseWorker");
            zzajl2.zza(thread, true);
            zzajl2.zza(thread, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    zzamq.this.zzj(throwable);
                }
            });
            return thread;
        }
    }
}

