/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiz;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzajo;
import com.google.android.gms.internal.zzali;
import com.google.android.gms.internal.zzalu;
import com.google.android.gms.internal.zzalv;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzamt;
import com.google.android.gms.internal.zzamv;
import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzait aVK;

    DatabaseReference(zzajb zzajb2, zzaiz zzaiz2) {
        super(zzajb2, zzaiz2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzcra().isEmpty()) {
            zzamx.zztk(string);
        } else {
            zzamx.zztj(string);
        }
        zzaiz zzaiz2 = this.zzcra().zzh(new zzaiz(string));
        return new DatabaseReference(this.aVX, zzaiz2);
    }

    public DatabaseReference push() {
        String string = zzamv.zzcq(this.aVX.zzcvo());
        zzali zzali2 = zzali.zzsy(string);
        return new DatabaseReference(this.aVX, this.zzcra().zza(zzali2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzaly.zzbv(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzaly.zzbv(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzaly.zzbv(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzaly.zzbv(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzalu zzalu2, CompletionListener completionListener) {
        zzamx.zzaq(this.zzcra());
        zzajo.zza(this.zzcra(), object);
        Object object2 = zzamy.zzbz(object);
        zzamx.zzby(object2);
        final zzalu zzalu3 = zzalv.zza(object2, zzalu2);
        final zzamt<Task<Void>, CompletionListener> zzamt2 = zzamw.zzb(completionListener);
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aVX.zza(DatabaseReference.this.zzcra(), zzalu3, (CompletionListener)zzamt2.y());
            }
        });
        return zzamt2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzaly.zzbv(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzaly.zzbv(object), completionListener);
    }

    private Task<Void> zza(final zzalu zzalu2, CompletionListener completionListener) {
        zzamx.zzaq(this.zzcra());
        final zzamt<Task<Void>, CompletionListener> zzamt2 = zzamw.zzb(completionListener);
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aVX.zza(DatabaseReference.this.zzcra().zza(zzali.zzcyx()), zzalu2, (CompletionListener)zzamt2.y());
            }
        });
        return zzamt2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> map2 = zzamy.zzcd(map);
        Map<zzaiz, zzalu> map3 = zzamx.zzc(this.zzcra(), map2);
        final zzaiq zzaiq2 = zzaiq.zzbz(map3);
        final zzamt<Task<Void>, CompletionListener> zzamt2 = zzamw.zzb(completionListener);
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aVX.zza(DatabaseReference.this.zzcra(), zzaiq2, (CompletionListener)zzamt2.y(), (Map<String, Object>)map2);
            }
        });
        return zzamt2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzamx.zzaq(this.zzcra());
        return new OnDisconnect(this.aVX, this.zzcra());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzamx.zzaq(this.zzcra());
        this.aVX.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aVX.zza(DatabaseReference.this.zzcra(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzcqu());
    }

    static void zza(zzait zzait2) {
        zzajd.zzd(zzait2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzcqu());
    }

    static void zzb(zzait zzait2) {
        zzajd.zze(zzait2);
    }

    public FirebaseDatabase getDatabase() {
        return this.aVX.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.aVX.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzaiz zzaiz2 = this.zzcra().zzcvj();
        if (zzaiz2 != null) {
            return new DatabaseReference(this.aVX, zzaiz2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.aVX, new zzaiz(""));
    }

    public String getKey() {
        if (this.zzcra().isEmpty()) {
            return null;
        }
        return this.zzcra().zzcvk().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzait zzcqu() {
        if (aVK == null) {
            aVK = new zzait();
        }
        return aVK;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

