/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaih;
import com.google.android.gms.internal.zzaim;
import com.google.android.gms.internal.zzaip;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class zzaig<K, V>
extends zzaih<K, V> {
    private final K[] aZZ;
    private final V[] baa;
    private final Comparator<K> bab;

    public static <A, B, C> zzaig<A, C> zza(List<A> list, Map<B, C> map, zzaih.zza.zza<A, B> zza2, Comparator<A> comparator) {
        Collections.sort(list, comparator);
        int n = list.size();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        for (A a : list) {
            objectArray[n2] = a;
            C c = map.get(zza2.zzbk(a));
            objectArray2[n2] = c;
            ++n2;
        }
        return new zzaig<Object, Object>(comparator, objectArray, objectArray2);
    }

    public static <K, V> zzaig<K, V> zza(Map<K, V> map, Comparator<K> comparator) {
        return zzaig.zza(new ArrayList<K>(map.keySet()), map, zzaih.zza.zzcrm(), comparator);
    }

    public zzaig(Comparator<K> comparator) {
        this.aZZ = new Object[0];
        this.baa = new Object[0];
        this.bab = comparator;
    }

    private zzaig(Comparator<K> comparator, K[] KArray, V[] VArray) {
        this.aZZ = KArray;
        this.baa = VArray;
        this.bab = comparator;
    }

    @Override
    public boolean containsKey(K k) {
        return this.zzbj(k) != -1;
    }

    @Override
    public V get(K k) {
        int n = this.zzbj(k);
        return n != -1 ? (V)this.baa[n] : null;
    }

    @Override
    public zzaih<K, V> zzbg(K k) {
        int n = this.zzbj(k);
        if (n == -1) {
            return this;
        }
        K[] KArray = zzaig.zza(this.aZZ, n);
        V[] VArray = zzaig.zza(this.baa, n);
        return new zzaig<K, V>(this.bab, KArray, VArray);
    }

    @Override
    public zzaih<K, V> zzj(K k, V v) {
        int n = this.zzbj(k);
        if (n != -1) {
            if (this.aZZ[n] == k && this.baa[n] == v) {
                return this;
            }
            K[] KArray = zzaig.zzb(this.aZZ, n, k);
            V[] VArray = zzaig.zzb(this.baa, n, v);
            return new zzaig<K, V>(this.bab, KArray, VArray);
        }
        if (this.aZZ.length > 25) {
            HashMap<K, V> hashMap = new HashMap<K, V>(this.aZZ.length + 1);
            for (int i = 0; i < this.aZZ.length; ++i) {
                hashMap.put(this.aZZ[i], this.baa[i]);
            }
            hashMap.put(k, v);
            return zzaip.zzc(hashMap, this.bab);
        }
        int n2 = this.zzbi(k);
        K[] KArray = zzaig.zza(this.aZZ, n2, k);
        V[] VArray = zzaig.zza(this.baa, n2, v);
        return new zzaig<K, V>(this.bab, KArray, VArray);
    }

    @Override
    public K zzcrj() {
        return this.aZZ.length > 0 ? (K)this.aZZ[0] : null;
    }

    @Override
    public K zzcrk() {
        return this.aZZ.length > 0 ? (K)this.aZZ[this.aZZ.length - 1] : null;
    }

    @Override
    public int size() {
        return this.aZZ.length;
    }

    @Override
    public boolean isEmpty() {
        return this.aZZ.length == 0;
    }

    @Override
    public void zza(zzaim.zzb<K, V> zzb2) {
        for (int i = 0; i < this.aZZ.length; ++i) {
            zzb2.zzk(this.aZZ[i], this.baa[i]);
        }
    }

    private Iterator<Map.Entry<K, V>> zze(final int n, final boolean bl) {
        return new Iterator<Map.Entry<K, V>>(){
            int bac;
            {
                this.bac = n;
            }

            @Override
            public boolean hasNext() {
                return bl ? this.bac >= 0 : this.bac < zzaig.this.aZZ.length;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object object = zzaig.this.aZZ[this.bac];
                Object object2 = zzaig.this.baa[this.bac];
                this.bac = bl ? this.bac - 1 : this.bac + 1;
                return new AbstractMap.SimpleImmutableEntry<Object, Object>(object, object2);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove elements from ImmutableSortedMap");
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.zze(0, false);
    }

    @Override
    public Iterator<Map.Entry<K, V>> zzcrl() {
        return this.zze(this.aZZ.length - 1, true);
    }

    @Override
    public K zzbh(K k) {
        int n = this.zzbj(k);
        if (n == -1) {
            throw new IllegalArgumentException("Can't find predecessor of nonexistent key");
        }
        return n > 0 ? (K)this.aZZ[n - 1] : null;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.bab;
    }

    private static <T> T[] zza(T[] TArray, int n) {
        int n2 = TArray.length - 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        System.arraycopy(TArray, n + 1, objectArray, n, n2 - n);
        return objectArray;
    }

    private static <T> T[] zza(T[] TArray, int n, T t) {
        int n2 = TArray.length + 1;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n);
        objectArray[n] = t;
        System.arraycopy(TArray, n, objectArray, n + 1, n2 - n - 1);
        return objectArray;
    }

    private static <T> T[] zzb(T[] TArray, int n, T t) {
        int n2 = TArray.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(TArray, 0, objectArray, 0, n2);
        objectArray[n] = t;
        return objectArray;
    }

    private int zzbi(K k) {
        int n;
        for (n = 0; n < this.aZZ.length && this.bab.compare(this.aZZ[n], k) < 0; ++n) {
        }
        return n;
    }

    private int zzbj(K k) {
        int n = 0;
        for (K k2 : this.aZZ) {
            if (this.bab.compare(k, k2) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

