/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzalz;
import com.google.firebase.database.DatabaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class zzajq
implements Comparable<zzajq>,
Iterable<zzalz> {
    private final zzalz[] bdF;
    private final int start;
    private final int end;
    private static final zzajq bdG = new zzajq("");

    public static zzajq zza(zzajq zzajq2, zzajq zzajq3) {
        zzalz zzalz2 = zzajq2.zzcvj();
        zzalz zzalz3 = zzajq3.zzcvj();
        if (zzalz2 == null) {
            return zzajq3;
        }
        if (zzalz2.equals(zzalz3)) {
            return zzajq.zza(zzajq2.zzcvk(), zzajq3.zzcvk());
        }
        String string = String.valueOf(zzajq3);
        String string2 = String.valueOf(zzajq2);
        throw new DatabaseException(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("INTERNAL ERROR: ").append(string).append(" is not contained in ").append(string2).toString());
    }

    public static zzajq zzcvg() {
        return bdG;
    }

    public zzajq(zzalz ... zzalzArray) {
        this.bdF = Arrays.copyOf(zzalzArray, zzalzArray.length);
        this.start = 0;
        this.end = zzalzArray.length;
        for (zzalz zzalz2 : zzalzArray) {
            assert (zzalz2 != null) : "Can't construct a path with a null value!";
        }
    }

    public zzajq(List<String> list) {
        this.bdF = new zzalz[list.size()];
        int n = 0;
        for (String string : list) {
            this.bdF[n++] = zzalz.zzsx(string);
        }
        this.start = 0;
        this.end = list.size();
    }

    public zzajq(String string) {
        String[] stringArray = string.split("/");
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            ++n;
        }
        this.bdF = new zzalz[n];
        int n2 = 0;
        for (String string3 : stringArray) {
            if (string3.length() <= 0) continue;
            this.bdF[n2++] = zzalz.zzsx(string3);
        }
        this.start = 0;
        this.end = this.bdF.length;
    }

    private zzajq(zzalz[] zzalzArray, int n, int n2) {
        this.bdF = zzalzArray;
        this.start = n;
        this.end = n2;
    }

    public zzajq zzh(zzajq zzajq2) {
        int n = this.size() + zzajq2.size();
        zzalz[] zzalzArray = new zzalz[n];
        System.arraycopy(this.bdF, this.start, zzalzArray, 0, this.size());
        System.arraycopy(zzajq2.bdF, zzajq2.start, zzalzArray, this.size(), zzajq2.size());
        return new zzajq(zzalzArray, 0, n);
    }

    public zzajq zza(zzalz zzalz2) {
        int n = this.size();
        zzalz[] zzalzArray = new zzalz[n + 1];
        System.arraycopy(this.bdF, this.start, zzalzArray, 0, n);
        zzalzArray[n] = zzalz2;
        return new zzajq(zzalzArray, 0, n + 1);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            stringBuilder.append("/");
            stringBuilder.append(this.bdF[i].asString());
        }
        return stringBuilder.toString();
    }

    public String zzcvh() {
        if (this.isEmpty()) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = this.start; i < this.end; ++i) {
            if (i > this.start) {
                stringBuilder.append("/");
            }
            stringBuilder.append(this.bdF[i].asString());
        }
        return stringBuilder.toString();
    }

    public List<String> zzcvi() {
        ArrayList<String> arrayList = new ArrayList<String>(this.size());
        for (zzalz zzalz2 : this) {
            arrayList.add(zzalz2.asString());
        }
        return arrayList;
    }

    public zzalz zzcvj() {
        if (this.isEmpty()) {
            return null;
        }
        return this.bdF[this.start];
    }

    public zzajq zzcvk() {
        int n = this.start;
        if (!this.isEmpty()) {
            ++n;
        }
        return new zzajq(this.bdF, n, this.end);
    }

    public zzajq zzcvl() {
        if (this.isEmpty()) {
            return null;
        }
        return new zzajq(this.bdF, this.start, this.end - 1);
    }

    public zzalz zzcvm() {
        if (!this.isEmpty()) {
            return this.bdF[this.end - 1];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public int size() {
        return this.end - this.start;
    }

    @Override
    public Iterator<zzalz> iterator() {
        return new Iterator<zzalz>(){
            int offset;
            {
                this.offset = zzajq.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.offset < zzajq.this.end;
            }

            public zzalz zzcvn() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements.");
                }
                zzalz zzalz2 = zzajq.this.bdF[this.offset];
                ++this.offset;
                return zzalz2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove component from immutable Path!");
            }

            @Override
            public /* synthetic */ Object next() {
                return this.zzcvn();
            }
        };
    }

    public boolean zzi(zzajq zzajq2) {
        if (this.size() > zzajq2.size()) {
            return false;
        }
        int n = this.start;
        int n2 = zzajq2.start;
        while (n < this.end) {
            if (!this.bdF[n].equals(zzajq2.bdF[n2])) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof zzajq)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        zzajq zzajq2 = (zzajq)object;
        if (this.size() != zzajq2.size()) {
            return false;
        }
        int n = this.start;
        for (int i = zzajq2.start; n < this.end && i < zzajq2.end; ++n, ++i) {
            if (this.bdF[n].equals(zzajq2.bdF[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.start; i < this.end; ++i) {
            n = n * 37 + this.bdF[i].hashCode();
        }
        return n;
    }

    public int zzj(zzajq zzajq2) {
        int n;
        int n2 = this.start;
        for (n = zzajq2.start; n2 < this.end && n < zzajq2.end; ++n2, ++n) {
            int n3 = this.bdF[n2].zzi(zzajq2.bdF[n]);
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 == this.end && n == zzajq2.end) {
            return 0;
        }
        if (n2 == this.end) {
            return -1;
        }
        return 1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zzj((zzajq)object);
    }
}

