/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzajv;
import com.google.android.gms.internal.zzakc;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class zzanh
implements zzajv {
    private ScheduledThreadPoolExecutor bkc;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected zzakc zzcvf() {
        return zzakc.bfH;
    }

    public abstract void zzj(Throwable var1);

    public zzanh() {
        boolean bl = true;
        zza zza2 = new zza();
        this.bkc = new ScheduledThreadPoolExecutor(1, zza2){

            @Override
            protected void afterExecute(Runnable runnable, Throwable throwable) {
                super.afterExecute(runnable, throwable);
                if (throwable == null && runnable instanceof Future) {
                    Future future = (Future)((Object)runnable);
                    try {
                        if (future.isDone()) {
                            future.get();
                        }
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException executionException) {
                        throwable = executionException.getCause();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (throwable != null) {
                    zzanh.this.zzj(throwable);
                }
            }
        };
        this.bkc.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public ScheduledExecutorService zzcsj() {
        return this.bkc;
    }

    @Override
    public void zzs(Runnable runnable) {
        this.bkc.execute(runnable);
    }

    @Override
    public void shutdown() {
        this.bkc.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.bkc.setCorePoolSize(1);
    }

    public static String zzl(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (throwable instanceof DatabaseException) {
            return "";
        }
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }

    private class zza
    implements ThreadFactory {
        private zza() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = zzanh.this.getThreadFactory().newThread(runnable);
            zzakc zzakc2 = zzanh.this.zzcvf();
            zzakc2.zza(thread, "FirebaseDatabaseWorker");
            zzakc2.zza(thread, true);
            zzakc2.zza(thread, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    zzanh.this.zzj(throwable);
                }
            });
            return thread;
        }
    }
}

