/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzajh;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzakf;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamm;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzank;
import com.google.android.gms.internal.zzanm;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzano;
import com.google.android.gms.internal.zzanp;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.OnDisconnect;
import com.google.firebase.database.Query;
import com.google.firebase.database.Transaction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class DatabaseReference
extends Query {
    private static zzajk aYW;

    DatabaseReference(zzajs zzajs2, zzajq zzajq2) {
        super(zzajs2, zzajq2);
    }

    public DatabaseReference child(String string) {
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in child()");
        }
        if (this.zzcrc().isEmpty()) {
            zzano.zztj(string);
        } else {
            zzano.zzti(string);
        }
        zzajq zzajq2 = this.zzcrc().zzh(new zzajq(string));
        return new DatabaseReference(this.aZj, zzajq2);
    }

    public DatabaseReference push() {
        String string = zzanm.zzco(this.aZj.zzcvq());
        zzalz zzalz2 = zzalz.zzsx(string);
        return new DatabaseReference(this.aZj, this.zzcrc().zza(zzalz2));
    }

    public Task<Void> setValue(Object object) {
        return this.zza(object, zzamp.zzbu(null), null);
    }

    public Task<Void> setValue(Object object, Object object2) {
        return this.zza(object, zzamp.zzbu(object2), null);
    }

    public void setValue(Object object, CompletionListener completionListener) {
        this.zza(object, zzamp.zzbu(null), completionListener);
    }

    public void setValue(Object object, Object object2, CompletionListener completionListener) {
        this.zza(object, zzamp.zzbu(object2), completionListener);
    }

    private Task<Void> zza(Object object, zzaml zzaml2, CompletionListener completionListener) {
        zzano.zzaq(this.zzcrc());
        zzakf.zza(this.zzcrc(), object);
        Object object2 = zzanp.zzby(object);
        zzano.zzbx(object2);
        final zzaml zzaml3 = zzamm.zza(object2, zzaml2);
        final zzank<Task<Void>, CompletionListener> zzank2 = zzann.zzb(completionListener);
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aZj.zza(DatabaseReference.this.zzcrc(), zzaml3, (CompletionListener)zzank2.A());
            }
        });
        return zzank2.getFirst();
    }

    public Task<Void> setPriority(Object object) {
        return this.zza(zzamp.zzbu(object), null);
    }

    public void setPriority(Object object, CompletionListener completionListener) {
        this.zza(zzamp.zzbu(object), completionListener);
    }

    private Task<Void> zza(final zzaml zzaml2, CompletionListener completionListener) {
        zzano.zzaq(this.zzcrc());
        final zzank<Task<Void>, CompletionListener> zzank2 = zzann.zzb(completionListener);
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aZj.zza(DatabaseReference.this.zzcrc().zza(zzalz.zzcyz()), zzaml2, (CompletionListener)zzank2.A());
            }
        });
        return zzank2.getFirst();
    }

    public Task<Void> updateChildren(Map<String, Object> map) {
        return this.zza(map, null);
    }

    public void updateChildren(Map<String, Object> map, CompletionListener completionListener) {
        this.zza(map, completionListener);
    }

    private Task<Void> zza(Map<String, Object> map, CompletionListener completionListener) {
        if (map == null) {
            throw new NullPointerException("Can't pass null for argument 'update' in updateChildren()");
        }
        final Map<String, Object> map2 = zzanp.zzcf(map);
        Map<zzajq, zzaml> map3 = zzano.zzc(this.zzcrc(), map2);
        final zzajh zzajh2 = zzajh.zzcb(map3);
        final zzank<Task<Void>, CompletionListener> zzank2 = zzann.zzb(completionListener);
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aZj.zza(DatabaseReference.this.zzcrc(), zzajh2, (CompletionListener)zzank2.A(), (Map<String, Object>)map2);
            }
        });
        return zzank2.getFirst();
    }

    public Task<Void> removeValue() {
        return this.setValue(null);
    }

    public void removeValue(CompletionListener completionListener) {
        this.setValue(null, completionListener);
    }

    public OnDisconnect onDisconnect() {
        zzano.zzaq(this.zzcrc());
        return new OnDisconnect(this.aZj, this.zzcrc());
    }

    public void runTransaction(Transaction.Handler handler) {
        this.runTransaction(handler, true);
    }

    public void runTransaction(final Transaction.Handler handler, final boolean bl) {
        if (handler == null) {
            throw new NullPointerException("Can't pass null for argument 'handler' in runTransaction()");
        }
        zzano.zzaq(this.zzcrc());
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                DatabaseReference.this.aZj.zza(DatabaseReference.this.zzcrc(), handler, bl);
            }
        });
    }

    public static void goOffline() {
        DatabaseReference.zza(DatabaseReference.zzcqw());
    }

    static void zza(zzajk zzajk2) {
        zzaju.zzd(zzajk2);
    }

    public static void goOnline() {
        DatabaseReference.zzb(DatabaseReference.zzcqw());
    }

    static void zzb(zzajk zzajk2) {
        zzaju.zze(zzajk2);
    }

    public FirebaseDatabase getDatabase() {
        return this.aZj.getDatabase();
    }

    public String toString() {
        DatabaseReference databaseReference = this.getParent();
        if (databaseReference == null) {
            return this.aZj.toString();
        }
        try {
            String string = String.valueOf(databaseReference.toString());
            String string2 = String.valueOf(URLEncoder.encode(this.getKey(), "UTF-8").replace("+", "%20"));
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("/").append(string2).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = String.valueOf(this.getKey());
            throw new DatabaseException(string.length() != 0 ? "Failed to URLEncode key: ".concat(string) : new String("Failed to URLEncode key: "), unsupportedEncodingException);
        }
    }

    public DatabaseReference getParent() {
        zzajq zzajq2 = this.zzcrc().zzcvl();
        if (zzajq2 != null) {
            return new DatabaseReference(this.aZj, zzajq2);
        }
        return null;
    }

    public DatabaseReference getRoot() {
        return new DatabaseReference(this.aZj, new zzajq(""));
    }

    public String getKey() {
        if (this.zzcrc().isEmpty()) {
            return null;
        }
        return this.zzcrc().zzcvm().asString();
    }

    public boolean equals(Object object) {
        return object instanceof DatabaseReference && this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static synchronized zzajk zzcqw() {
        if (aYW == null) {
            aYW = new zzajk();
        }
        return aYW;
    }

    public static interface CompletionListener {
        public void onComplete(DatabaseError var1, DatabaseReference var2);
    }
}

