/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzajt;
import com.google.android.gms.internal.zzaju;
import com.google.android.gms.internal.zzanl;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzano;
import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Logger;
import java.util.HashMap;
import java.util.Map;

public class FirebaseDatabase {
    private static final Map<String, FirebaseDatabase> aZf = new HashMap<String, FirebaseDatabase>();
    private final FirebaseApp aZg;
    private final zzajt aZh;
    private final zzajk aZi;
    private zzajs aZj;

    public static FirebaseDatabase getInstance() {
        return FirebaseDatabase.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseDatabase getInstance(FirebaseApp firebaseApp) {
        if (!aZf.containsKey(firebaseApp.getName())) {
            String string = firebaseApp.getOptions().getDatabaseUrl();
            if (string == null) {
                throw new DatabaseException("Failed to get FirebaseDatabase instance: FirebaseApp object has no DatabaseURL in its FirebaseOptions object.");
            }
            zzanl zzanl2 = zzann.zztd(string);
            if (!zzanl2.aZr.isEmpty()) {
                String string2 = String.valueOf(zzanl2.aZr.toString());
                throw new DatabaseException(new StringBuilder(114 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Configured Database URL '").append(string).append("' is invalid. It should point to the root of a Firebase Database but it includes a path: ").append(string2).toString());
            }
            zzajk zzajk2 = new zzajk();
            if (!firebaseApp.zzcnu()) {
                zzajk2.zzsv(firebaseApp.getName());
            }
            zzajk2.zzf(firebaseApp);
            aZf.put(firebaseApp.getName(), new FirebaseDatabase(firebaseApp, zzanl2.aZh, zzajk2));
        }
        return aZf.get(firebaseApp.getName());
    }

    private FirebaseDatabase(FirebaseApp firebaseApp, zzajt zzajt2, zzajk zzajk2) {
        this.aZg = firebaseApp;
        this.aZh = zzajt2;
        this.aZi = zzajk2;
    }

    public FirebaseApp getApp() {
        return this.aZg;
    }

    public DatabaseReference getReference() {
        this.zzcqx();
        return new DatabaseReference(this.aZj, zzajq.zzcvg());
    }

    public DatabaseReference getReference(String string) {
        this.zzcqx();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'pathString' in FirebaseDatabase.getReference()");
        }
        zzano.zztj(string);
        zzajq zzajq2 = new zzajq(string);
        return new DatabaseReference(this.aZj, zzajq2);
    }

    public DatabaseReference getReferenceFromUrl(String string) {
        this.zzcqx();
        if (string == null) {
            throw new NullPointerException("Can't pass null for argument 'url' in FirebaseDatabase.getReferenceFromUrl()");
        }
        zzanl zzanl2 = zzann.zztd(string);
        if (!zzanl2.aZh.baV.equals(this.aZj.zzcvp().baV)) {
            String string2 = String.valueOf(this.getReference().toString());
            throw new DatabaseException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid URL (").append(string).append(") passed to getReference().  URL was expected to match configured Database URL: ").append(string2).toString());
        }
        return new DatabaseReference(this.aZj, zzanl2.aZr);
    }

    public void purgeOutstandingWrites() {
        this.zzcqx();
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                FirebaseDatabase.this.aZj.purgeOutstandingWrites();
            }
        });
    }

    public void goOnline() {
        this.zzcqx();
        zzaju.zzl(this.aZj);
    }

    public void goOffline() {
        this.zzcqx();
        zzaju.zzk(this.aZj);
    }

    public synchronized void setLogLevel(Logger.Level level) {
        this.zzsb("setLogLevel");
        this.aZi.setLogLevel(level);
    }

    public synchronized void setPersistenceEnabled(boolean bl) {
        this.zzsb("setPersistenceEnabled");
        this.aZi.setPersistenceEnabled(bl);
    }

    public static String getSdkVersion() {
        return "3.0.0";
    }

    private void zzsb(String string) {
        if (this.aZj != null) {
            throw new DatabaseException(new StringBuilder(77 + String.valueOf(string).length()).append("Calls to ").append(string).append("() must be made before any other usage of FirebaseDatabase instance.").toString());
        }
    }

    private synchronized void zzcqx() {
        if (this.aZj == null) {
            this.aZj = zzaju.zza(this.aZi, this.aZh, this);
        }
    }
}

