/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database;

import com.google.android.gms.internal.zzajg;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzajq;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzakg;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzalk;
import com.google.android.gms.internal.zzall;
import com.google.android.gms.internal.zzaly;
import com.google.android.gms.internal.zzalz;
import com.google.android.gms.internal.zzamd;
import com.google.android.gms.internal.zzame;
import com.google.android.gms.internal.zzamh;
import com.google.android.gms.internal.zzaml;
import com.google.android.gms.internal.zzamn;
import com.google.android.gms.internal.zzamo;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzamr;
import com.google.android.gms.internal.zzams;
import com.google.android.gms.internal.zzann;
import com.google.android.gms.internal.zzano;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.ValueEventListener;

public class Query {
    protected final zzajs aZj;
    protected final zzajq aZr;
    protected final zzalk aZv;
    private final boolean aZw;

    Query(zzajs zzajs2, zzajq zzajq2, zzalk zzalk2, boolean bl) throws DatabaseException {
        this.aZj = zzajs2;
        this.aZr = zzajq2;
        this.aZv = zzalk2;
        this.aZw = bl;
        zzann.zzb(zzalk2.isValid(), "Validation of queries failed.");
    }

    Query(zzajs zzajs2, zzajq zzajq2) {
        this.aZj = zzajs2;
        this.aZr = zzajq2;
        this.aZv = zzalk.bhG;
        this.aZw = false;
    }

    private void zza(zzalk zzalk2) {
        if (zzalk2.zzcya().equals(zzamh.zzczx())) {
            zzalz zzalz2;
            zzaml zzaml2;
            String string = "You must use startAt(String value), endAt(String value) or equalTo(String value) in combination with orderByKey(). Other type of values or using the version with 2 parameters is not supported";
            if (zzalk2.zzcxs()) {
                zzaml2 = zzalk2.zzcxt();
                zzalz2 = zzalk2.zzcxu();
                if (zzalz2 != zzalz.zzcyx() || !(zzaml2 instanceof zzamr)) {
                    throw new IllegalArgumentException(string);
                }
            }
            if (zzalk2.zzcxv()) {
                zzaml2 = zzalk2.zzcxw();
                zzalz2 = zzalk2.zzcxx();
                if (zzalz2 != zzalz.zzcyy() || !(zzaml2 instanceof zzamr)) {
                    throw new IllegalArgumentException(string);
                }
            }
        } else if (zzalk2.zzcya().equals(zzamo.b()) && (zzalk2.zzcxs() && !zzamp.zzq(zzalk2.zzcxt()) || zzalk2.zzcxv() && !zzamp.zzq(zzalk2.zzcxw()))) {
            throw new IllegalArgumentException("When using orderByPriority(), values provided to startAt(), endAt(), or equalTo() must be valid priorities.");
        }
    }

    private void zzb(zzalk zzalk2) {
        if (zzalk2.zzcxs() && zzalk2.zzcxv() && zzalk2.zzcxy() && !zzalk2.zzcxz()) {
            throw new IllegalArgumentException("Can't combine startAt(), endAt() and limit(). Use limitToFirst() or limitToLast() instead");
        }
    }

    private void zzcra() {
        if (this.aZv.zzcxs()) {
            throw new IllegalArgumentException("Can't call equalTo() and startAt() combined");
        }
        if (this.aZv.zzcxv()) {
            throw new IllegalArgumentException("Can't call equalTo() and endAt() combined");
        }
    }

    private void zzcrb() {
        if (this.aZw) {
            throw new IllegalArgumentException("You can't combine multiple orderBy calls!");
        }
    }

    public ValueEventListener addValueEventListener(ValueEventListener valueEventListener) {
        this.zzb(new zzakg(this.aZj, valueEventListener, this.zzcrd()));
        return valueEventListener;
    }

    public ChildEventListener addChildEventListener(ChildEventListener childEventListener) {
        this.zzb(new zzajg(this.aZj, childEventListener, this.zzcrd()));
        return childEventListener;
    }

    public void addListenerForSingleValueEvent(final ValueEventListener valueEventListener) {
        this.zzb(new zzakg(this.aZj, new ValueEventListener(){

            @Override
            public void onDataChange(DataSnapshot dataSnapshot) {
                Query.this.removeEventListener(this);
                valueEventListener.onDataChange(dataSnapshot);
            }

            @Override
            public void onCancelled(DatabaseError databaseError) {
                valueEventListener.onCancelled(databaseError);
            }
        }, this.zzcrd()));
    }

    public void removeEventListener(ValueEventListener valueEventListener) {
        if (valueEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzakg(this.aZj, valueEventListener, this.zzcrd()));
    }

    public void removeEventListener(ChildEventListener childEventListener) {
        if (childEventListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.zza(new zzajg(this.aZj, childEventListener, this.zzcrd()));
    }

    private void zza(final zzajl zzajl2) {
        zzakj.zzcwl().zzk(zzajl2);
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aZj.zze(zzajl2);
            }
        });
    }

    private void zzb(final zzajl zzajl2) {
        zzakj.zzcwl().zzi(zzajl2);
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aZj.zzf(zzajl2);
            }
        });
    }

    public void keepSynced(final boolean bl) {
        if (!this.aZr.isEmpty() && this.aZr.zzcvj().equals(zzalz.zzcza())) {
            throw new DatabaseException("Can't call keepSynced() on .info paths.");
        }
        this.aZj.zzs(new Runnable(){

            @Override
            public void run() {
                Query.this.aZj.zza(Query.this.zzcrd(), bl);
            }
        });
    }

    public Query startAt(String string) {
        return this.startAt(string, null);
    }

    public Query startAt(double d) {
        return this.startAt(d, null);
    }

    public Query startAt(boolean bl) {
        return this.startAt(bl, null);
    }

    public Query startAt(String string, String string2) {
        zzaml zzaml2 = string != null ? new zzamr(string, zzamp.c()) : zzame.zzczq();
        return this.zza(zzaml2, string2);
    }

    public Query startAt(double d, String string) {
        return this.zza(new zzamd(d, zzamp.c()), string);
    }

    public Query startAt(boolean bl, String string) {
        return this.zza(new zzaly(bl, zzamp.c()), string);
    }

    private Query zza(zzaml zzaml2, String string) {
        zzano.zztm(string);
        if (!zzaml2.zzcze() && !zzaml2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for startAt()");
        }
        if (this.aZv.zzcxs()) {
            throw new IllegalArgumentException("Can't call startAt() or equalTo() multiple times");
        }
        zzalz zzalz2 = string != null ? zzalz.zzsx(string) : null;
        zzalk zzalk2 = this.aZv.zza(zzaml2, zzalz2);
        this.zzb(zzalk2);
        this.zza(zzalk2);
        assert (zzalk2.isValid());
        return new Query(this.aZj, this.aZr, zzalk2, this.aZw);
    }

    public Query endAt(String string) {
        return this.endAt(string, null);
    }

    public Query endAt(double d) {
        return this.endAt(d, null);
    }

    public Query endAt(boolean bl) {
        return this.endAt(bl, null);
    }

    public Query endAt(String string, String string2) {
        zzaml zzaml2 = string != null ? new zzamr(string, zzamp.c()) : zzame.zzczq();
        return this.zzb(zzaml2, string2);
    }

    public Query endAt(double d, String string) {
        return this.zzb(new zzamd(d, zzamp.c()), string);
    }

    public Query endAt(boolean bl, String string) {
        return this.zzb(new zzaly(bl, zzamp.c()), string);
    }

    private Query zzb(zzaml zzaml2, String string) {
        zzalz zzalz2;
        zzano.zztm(string);
        if (!zzaml2.zzcze() && !zzaml2.isEmpty()) {
            throw new IllegalArgumentException("Can only use simple values for endAt()");
        }
        zzalz zzalz3 = zzalz2 = string != null ? zzalz.zzsx(string) : null;
        if (this.aZv.zzcxv()) {
            throw new IllegalArgumentException("Can't call endAt() or equalTo() multiple times");
        }
        zzalk zzalk2 = this.aZv.zzb(zzaml2, zzalz2);
        this.zzb(zzalk2);
        this.zza(zzalk2);
        assert (zzalk2.isValid());
        return new Query(this.aZj, this.aZr, zzalk2, this.aZw);
    }

    public Query equalTo(String string) {
        this.zzcra();
        return this.startAt(string).endAt(string);
    }

    public Query equalTo(double d) {
        this.zzcra();
        return this.startAt(d).endAt(d);
    }

    public Query equalTo(boolean bl) {
        this.zzcra();
        return this.startAt(bl).endAt(bl);
    }

    public Query equalTo(String string, String string2) {
        this.zzcra();
        return this.startAt(string, string2).endAt(string, string2);
    }

    public Query equalTo(double d, String string) {
        this.zzcra();
        return this.startAt(d, string).endAt(d, string);
    }

    public Query equalTo(boolean bl, String string) {
        this.zzcra();
        return this.startAt(bl, string).endAt(bl, string);
    }

    public Query limitToFirst(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aZv.zzcxy()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aZj, this.aZr, this.aZv.zzafy(n), this.aZw);
    }

    public Query limitToLast(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Limit must be a positive integer!");
        }
        if (this.aZv.zzcxy()) {
            throw new IllegalArgumentException("Can't call limitToLast on query with previously set limit!");
        }
        return new Query(this.aZj, this.aZr, this.aZv.zzafz(n), this.aZw);
    }

    public Query orderByChild(String string) {
        if (string == null) {
            throw new NullPointerException("Key can't be null");
        }
        if (string.equals("$key") || string.equals(".key")) {
            throw new IllegalArgumentException(new StringBuilder(54 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByKey() instead!").toString());
        }
        if (string.equals("$priority") || string.equals(".priority")) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByPriority() instead!").toString());
        }
        if (string.equals("$value") || string.equals(".value")) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't use '").append(string).append("' as path, please use orderByValue() instead!").toString());
        }
        zzano.zzti(string);
        this.zzcrb();
        zzajq zzajq2 = new zzajq(string);
        if (zzajq2.size() == 0) {
            throw new IllegalArgumentException("Can't use empty path, use orderByValue() instead!");
        }
        zzamn zzamn2 = new zzamn(zzajq2);
        return new Query(this.aZj, this.aZr, this.aZv.zza(zzamn2), true);
    }

    public Query orderByPriority() {
        this.zzcrb();
        zzalk zzalk2 = this.aZv.zza(zzamo.b());
        this.zza(zzalk2);
        return new Query(this.aZj, this.aZr, zzalk2, true);
    }

    public Query orderByKey() {
        this.zzcrb();
        zzalk zzalk2 = this.aZv.zza(zzamh.zzczx());
        this.zza(zzalk2);
        return new Query(this.aZj, this.aZr, zzalk2, true);
    }

    public Query orderByValue() {
        this.zzcrb();
        return new Query(this.aZj, this.aZr, this.aZv.zza(zzams.d()), true);
    }

    public DatabaseReference getRef() {
        return new DatabaseReference(this.aZj, this.zzcrc());
    }

    public zzajq zzcrc() {
        return this.aZr;
    }

    public zzall zzcrd() {
        return new zzall(this.aZr, this.aZv);
    }
}

