/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.ze;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zzcjK;

    DynamicLink(Bundle bundle) {
        this.zzcjK = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zzcjK;
        ze.zzE(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzbPI;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzbPI = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPI = new Bundle();

            public final Builder setTitle(String string) {
                this.zzbPI.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzbPI.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzbPI.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzbPI, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzbPI;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzbPI = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPI = new Bundle();

            public final Builder setProviderToken(String string) {
                this.zzbPI.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzbPI.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzbPI.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzbPI, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzbPI;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzbPI = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPI = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzbPI.putString("utm_source", string);
                this.zzbPI.putString("utm_medium", string2);
                this.zzbPI.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzbPI.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzbPI.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzbPI.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzbPI.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzbPI.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzbPI, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzbPI;

        private IosParameters(Bundle bundle) {
            this.zzbPI = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPI = new Bundle();

            public Builder(@NonNull String string) {
                this.zzbPI.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPI.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzbPI.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzbPI.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzbPI.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzbPI.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzbPI.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzbPI, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzbPI;

        private AndroidParameters(Bundle bundle) {
            this.zzbPI = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPI;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzbPI = new Bundle();
                this.zzbPI.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzbPI = new Bundle();
                this.zzbPI.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPI.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzbPI.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzbPI, null);
            }
        }
    }

    public static final class Builder {
        private final ze zzcjL;
        private final Bundle zzcjK;
        private final Bundle zzcjM;

        public Builder(ze ze2) {
            this.zzcjL = ze2;
            this.zzcjK = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzcjK.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzcjM = new Bundle();
            this.zzcjK.putBundle("parameters", this.zzcjM);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzcjK.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzcjM.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zzcjK.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzcjM.putAll(androidParameters.zzbPI);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzcjM.putAll(iosParameters.zzbPI);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzcjM.putAll(googleAnalyticsParameters.zzbPI);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzcjM.putAll(itunesConnectAnalyticsParameters.zzbPI);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzcjM.putAll(socialMetaTagParameters.zzbPI);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            ze.zzE(this.zzcjK);
            return new DynamicLink(this.zzcjK);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzJF();
            return this.zzcjL.zzD(this.zzcjK);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzJF();
            this.zzcjK.putInt("suffix", n);
            return this.zzcjL.zzD(this.zzcjK);
        }

        private final void zzJF() {
            if (this.zzcjK.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

