/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.dynamiclinks;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zn;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.dynamiclinks.ShortDynamicLink;
import com.google.firebase.dynamiclinks.zza;

public final class DynamicLink {
    private final Bundle zzcjO;

    DynamicLink(Bundle bundle) {
        this.zzcjO = bundle;
    }

    public final Uri getUri() {
        Bundle bundle = this.zzcjO;
        zn.zzE(bundle);
        Uri uri = (Uri)bundle.getParcelable("dynamicLink");
        if (uri == null) {
            Uri.Builder builder = new Uri.Builder();
            builder.scheme("https");
            builder.authority(bundle.getString("domain"));
            Bundle bundle2 = bundle.getBundle("parameters");
            for (String string : bundle2.keySet()) {
                Object object = bundle2.get(string);
                if (object == null) continue;
                builder.appendQueryParameter(string, object.toString());
            }
            uri = builder.build();
        }
        return uri;
    }

    public static final class SocialMetaTagParameters {
        final Bundle zzbPK;

        private SocialMetaTagParameters(Bundle bundle) {
            this.zzbPK = bundle;
        }

        /* synthetic */ SocialMetaTagParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPK = new Bundle();

            public final Builder setTitle(String string) {
                this.zzbPK.putString("st", string);
                return this;
            }

            public final Builder setDescription(String string) {
                this.zzbPK.putString("sd", string);
                return this;
            }

            public final Builder setImageUrl(Uri uri) {
                this.zzbPK.putParcelable("si", (Parcelable)uri);
                return this;
            }

            public final SocialMetaTagParameters build() {
                return new SocialMetaTagParameters(this.zzbPK, null);
            }
        }
    }

    public static final class ItunesConnectAnalyticsParameters {
        final Bundle zzbPK;

        private ItunesConnectAnalyticsParameters(Bundle bundle) {
            this.zzbPK = bundle;
        }

        /* synthetic */ ItunesConnectAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPK = new Bundle();

            public final Builder setProviderToken(String string) {
                this.zzbPK.putString("pt", string);
                return this;
            }

            public final Builder setAffiliateToken(String string) {
                this.zzbPK.putString("at", string);
                return this;
            }

            public final Builder setCampaignToken(String string) {
                this.zzbPK.putString("ct", string);
                return this;
            }

            public final ItunesConnectAnalyticsParameters build() {
                return new ItunesConnectAnalyticsParameters(this.zzbPK, null);
            }
        }
    }

    public static final class GoogleAnalyticsParameters {
        Bundle zzbPK;

        private GoogleAnalyticsParameters(Bundle bundle) {
            this.zzbPK = bundle;
        }

        /* synthetic */ GoogleAnalyticsParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPK = new Bundle();

            public Builder() {
            }

            public Builder(String string, String string2, String string3) {
                this.zzbPK.putString("utm_source", string);
                this.zzbPK.putString("utm_medium", string2);
                this.zzbPK.putString("utm_campaign", string3);
            }

            public final Builder setSource(String string) {
                this.zzbPK.putString("utm_source", string);
                return this;
            }

            public final Builder setMedium(String string) {
                this.zzbPK.putString("utm_medium", string);
                return this;
            }

            public final Builder setCampaign(String string) {
                this.zzbPK.putString("utm_campaign", string);
                return this;
            }

            public final Builder setTerm(String string) {
                this.zzbPK.putString("utm_term", string);
                return this;
            }

            public final Builder setContent(String string) {
                this.zzbPK.putString("utm_content", string);
                return this;
            }

            public final GoogleAnalyticsParameters build() {
                return new GoogleAnalyticsParameters(this.zzbPK, null);
            }
        }
    }

    public static final class IosParameters {
        final Bundle zzbPK;

        private IosParameters(Bundle bundle) {
            this.zzbPK = bundle;
        }

        /* synthetic */ IosParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPK = new Bundle();

            public Builder(@NonNull String string) {
                this.zzbPK.putString("ibi", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPK.putParcelable("ifl", (Parcelable)uri);
                return this;
            }

            public final Builder setCustomScheme(String string) {
                this.zzbPK.putString("ius", string);
                return this;
            }

            public final Builder setIpadFallbackUrl(Uri uri) {
                this.zzbPK.putParcelable("ipfl", (Parcelable)uri);
                return this;
            }

            public final Builder setIpadBundleId(String string) {
                this.zzbPK.putString("ipbi", string);
                return this;
            }

            public final Builder setAppStoreId(String string) {
                this.zzbPK.putString("isi", string);
                return this;
            }

            public final Builder setMinimumVersion(String string) {
                this.zzbPK.putString("imv", string);
                return this;
            }

            public final IosParameters build() {
                return new IosParameters(this.zzbPK, null);
            }
        }
    }

    public static final class AndroidParameters {
        final Bundle zzbPK;

        private AndroidParameters(Bundle bundle) {
            this.zzbPK = bundle;
        }

        /* synthetic */ AndroidParameters(Bundle bundle, zza zza2) {
            this(bundle);
        }

        public static final class Builder {
            private final Bundle zzbPK;

            public Builder() {
                if (FirebaseApp.getInstance() == null) {
                    throw new IllegalStateException("FirebaseApp not initialized.");
                }
                this.zzbPK = new Bundle();
                this.zzbPK.putString("apn", FirebaseApp.getInstance().getApplicationContext().getPackageName());
            }

            public Builder(@NonNull String string) {
                this.zzbPK = new Bundle();
                this.zzbPK.putString("apn", string);
            }

            public final Builder setFallbackUrl(Uri uri) {
                this.zzbPK.putParcelable("afl", (Parcelable)uri);
                return this;
            }

            public final Builder setMinimumVersion(int n) {
                this.zzbPK.putInt("amv", n);
                return this;
            }

            public final AndroidParameters build() {
                return new AndroidParameters(this.zzbPK, null);
            }
        }
    }

    public static final class Builder {
        private final zn zzcjP;
        private final Bundle zzcjO;
        private final Bundle zzcjQ;

        public Builder(zn zn2) {
            this.zzcjP = zn2;
            this.zzcjO = new Bundle();
            if (FirebaseApp.getInstance() != null) {
                this.zzcjO.putString("apiKey", FirebaseApp.getInstance().getOptions().getApiKey());
            }
            this.zzcjQ = new Bundle();
            this.zzcjO.putBundle("parameters", this.zzcjQ);
        }

        public final Builder setLongLink(@NonNull Uri uri) {
            this.zzcjO.putParcelable("dynamicLink", (Parcelable)uri);
            return this;
        }

        public final Builder setLink(@NonNull Uri uri) {
            this.zzcjQ.putParcelable("link", (Parcelable)uri);
            return this;
        }

        public final Builder setDynamicLinkDomain(@NonNull String string) {
            this.zzcjO.putString("domain", string);
            return this;
        }

        public final Builder setAndroidParameters(AndroidParameters androidParameters) {
            this.zzcjQ.putAll(androidParameters.zzbPK);
            return this;
        }

        public final Builder setIosParameters(IosParameters iosParameters) {
            this.zzcjQ.putAll(iosParameters.zzbPK);
            return this;
        }

        public final Builder setGoogleAnalyticsParameters(GoogleAnalyticsParameters googleAnalyticsParameters) {
            this.zzcjQ.putAll(googleAnalyticsParameters.zzbPK);
            return this;
        }

        public final Builder setItunesConnectAnalyticsParameters(ItunesConnectAnalyticsParameters itunesConnectAnalyticsParameters) {
            this.zzcjQ.putAll(itunesConnectAnalyticsParameters.zzbPK);
            return this;
        }

        public final Builder setSocialMetaTagParameters(SocialMetaTagParameters socialMetaTagParameters) {
            this.zzcjQ.putAll(socialMetaTagParameters.zzbPK);
            return this;
        }

        public final DynamicLink buildDynamicLink() {
            zn.zzE(this.zzcjO);
            return new DynamicLink(this.zzcjO);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink() {
            this.zzJI();
            return this.zzcjP.zzD(this.zzcjO);
        }

        public final Task<ShortDynamicLink> buildShortDynamicLink(int n) {
            this.zzJI();
            this.zzcjO.putInt("suffix", n);
            return this.zzcjP.zzD(this.zzcjO);
        }

        private final void zzJI() {
            if (this.zzcjO.getString("apiKey") == null) {
                throw new IllegalArgumentException("Missing API key. Set with setApiKey().");
            }
        }
    }
}

